/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.ProxyHandler;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;
import net.yacy.server.http.ChunkedInputStream;
import net.yacy.server.http.HTTPDProxyHandler;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UrlProxyServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 4900000000000001121L;
    private String _stopProxyText = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String tmps = config.getInitParameter("stopProxyText");
        if (tmps != null) {
            this._stopProxyText = tmps;
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!Switchboard.getSwitchboard().getConfigBool("proxyURL", false)) {
            response.sendError(403, "proxy use not allowed. URL proxy globally switched off (see: System Administration -> Advanced Settings -> URL proxy)");
            return;
        }
        String remoteHost = req.getRemoteAddr();
        if (!Domains.isThisHostIP(remoteHost) && !this.proxyippatternmatch(remoteHost)) {
            response.sendError(403, "proxy use not granted for IP " + remoteHost + " (see: System Administration -> Advanced Settings -> URL Proxy Access Settings -> Restrict URL proxy use filter)");
            return;
        }
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            return;
        }
        DigestURL proxyurl = null;
        String strUrl = request.getParameter("url");
        if (strUrl == null) {
            response.sendError(404, "url parameter missing");
            return;
        }
        try {
            proxyurl = new DigestURL(strUrl);
        }
        catch (MalformedURLException e) {
            proxyurl = new DigestURL(URLDecoder.decode(strUrl, StandardCharsets.UTF_8.name()));
        }
        Object hostwithport = proxyurl.getHost();
        if (proxyurl.getPort() != -1) {
            hostwithport = (String)hostwithport + ":" + proxyurl.getPort();
        }
        RequestHeader yacyRequestHeader = ProxyHandler.convertHeaderFromJetty(request);
        yacyRequestHeader.remove("Keep-Alive");
        yacyRequestHeader.remove("Content-Length");
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("HTTP", "HTTP/1.1");
        prop.put("URL", proxyurl);
        prop.put("CLIENTIP", "localhost");
        prop.put("CLIENT_HTTPSERVLETREQUEST", request);
        ByteArrayOutputStream tmpproxyout = new ByteArrayOutputStream();
        HTTPDProxyHandler.doGet(prop, yacyRequestHeader, tmpproxyout, ClientIdentification.yacyProxyAgent);
        ResponseHeader proxyResponseHeader = new ResponseHeader(200);
        InputStream proxyout = new ByteArrayInputStream(tmpproxyout.toByteArray());
        String line = this.readLine(proxyout);
        while (line != null && !line.equals("")) {
            int p = line.indexOf(58);
            if (p >= 0) {
                proxyResponseHeader.put(line.substring(0, p).trim(), line.substring(p + 1).trim());
            }
            line = this.readLine(proxyout);
        }
        if (line == null) {
            response.sendError(500, "Proxy Header missing");
            return;
        }
        if (proxyResponseHeader.containsKey("Location")) {
            Object location = (String)proxyResponseHeader.get("Location");
            location = ((String)location).startsWith("http") ? request.getServletPath() + "?url=" + (String)location : request.getServletPath() + "?url=" + proxyurl.getProtocol() + "://" + (String)hostwithport + "/" + (String)location;
            response.addHeader("Location", (String)location);
        }
        int httpStatus = proxyResponseHeader.getStatusCode();
        String mimeType = proxyResponseHeader.getContentType();
        response.setStatus(httpStatus);
        response.setContentType(mimeType);
        if (httpStatus < 400 && mimeType != null && mimeType.startsWith("text")) {
            byte[] sbb;
            Elements basetags;
            Document doc;
            if (proxyResponseHeader.containsKey("Transfer-Encoding") && ((String)proxyResponseHeader.get("Transfer-Encoding")).contains("chunked")) {
                proxyout = new ChunkedInputStream(proxyout);
            }
            String servletstub = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath() + "?url=";
            try {
                doc = Jsoup.parse((InputStream)proxyout, (String)proxyResponseHeader.getCharacterEncoding(), (String)proxyurl.toString());
            }
            catch (IOException eio) {
                response.sendError(500, "Proxy: parser error on " + proxyurl.toString() + "\n\n" + eio.getMessage());
                return;
            }
            Element bde = doc.body();
            Elements taglist = bde.getElementsByAttribute("href");
            Switchboard sb = Switchboard.getSwitchboard();
            for (Element e : taglist) {
                String absurl;
                block34: {
                    if (!e.tagName().equals("a") || (absurl = e.absUrl("href")).startsWith("data:") || absurl.startsWith("#") || absurl.startsWith("mailto:") || absurl.startsWith("javascript:")) continue;
                    if (sb.getConfig("proxyURL.rewriteURLs", "all").equals("domainlist")) {
                        try {
                            if (sb.crawlStacker.urlInAcceptedDomain(new DigestURL(absurl)) != null) {
                            }
                            break block34;
                        }
                        catch (MalformedURLException ex) {
                            ConcurrentLog.fine("PROXY", "ProxyServlet: malformed url for url-rewirte " + absurl);
                        }
                        continue;
                    }
                }
                e.attr("href", servletstub + absurl);
            }
            Element hd = doc.head();
            if (hd != null && (basetags = hd.getElementsByTag("base")).isEmpty()) {
                Element newbasetag = hd.prependElement("base");
                String basestr = proxyurl.getProtocol() + "://" + (String)hostwithport + proxyurl.getPath();
                newbasetag.attr("href", basestr);
            }
            if (this._stopProxyText != null) {
                String httpsAlertMsg = "";
                if (proxyurl.getProtocol().equalsIgnoreCase("https") && !request.getScheme().equalsIgnoreCase("https")) {
                    httpsAlertMsg = " &nbsp;  - <span style='color:red'>(Warning: secure target viewed over normal http)</span>";
                }
                String hdrtemplate = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/proxymsg/urlproxyheader.html?url=" + proxyurl.toString();
                hdrtemplate = "<iframe src='" + hdrtemplate + "' width='98%' height='50px' ><div width='100%' style='padding:5px; background:white; border-bottom: medium solid lightgrey;'><div align='center' style='font-size:11px;'><a style='font-size:11px; color:black;' href='" + proxyurl + "'>" + this._stopProxyText + "</a> " + httpsAlertMsg + "</div></div></iframe>";
                bde.prepend(hdrtemplate);
            }
            if (doc.charset() == null) {
                sbb = UTF8.getBytes(doc.toString());
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            } else {
                sbb = doc.toString().getBytes(doc.charset());
                response.setCharacterEncoding(doc.charset().name());
            }
            if (proxyResponseHeader.containsKey("Server")) {
                response.setHeader("Server", (String)proxyResponseHeader.get("Server"));
            }
            if (proxyResponseHeader.containsKey("Date")) {
                response.setHeader("Date", (String)proxyResponseHeader.get("Date"));
            }
            if (proxyResponseHeader.containsKey("Last-Modified")) {
                response.setHeader("Last-Modified", (String)proxyResponseHeader.get("Last-Modified"));
            }
            if (proxyResponseHeader.containsKey("Expires")) {
                response.setHeader("Expires", (String)proxyResponseHeader.get("Expires"));
            }
            response.setIntHeader("Content-Length", sbb.length);
            response.getOutputStream().write(sbb);
        } else {
            if (httpStatus >= 400) {
                if (HeaderFramework.http1_1.containsKey(Integer.toString(httpStatus))) {
                    String httpStatusText = HeaderFramework.http1_1.get(Integer.toString(httpStatus));
                    response.sendError(httpStatus, "Site " + proxyurl + " returned with status " + httpStatus + " (" + httpStatusText + ")");
                } else {
                    response.sendError(httpStatus, "Site " + proxyurl + " returned with status " + httpStatus);
                }
                return;
            }
            if (response.getHeader("Content-Length") == null && prop.containsKey("PROXY_REQUEST_SIZE")) {
                response.setHeader("Content-Length", (String)prop.get("PROXY_REQUEST_SIZE"));
            }
            FileUtils.copy(proxyout, (OutputStream)response.getOutputStream());
        }
    }

    private String readLine(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((b = in.read()) != 13 && b != -1) {
            buf.write(b);
        }
        if (b == -1) {
            return null;
        }
        b = in.read();
        if (b == -1) {
            return null;
        }
        return buf.toString(StandardCharsets.UTF_8.name());
    }

    private boolean proxyippatternmatch(String key) {
        String[] cfgippattern = Switchboard.getSwitchboard().getConfigArray("proxyURL.access", "*");
        if (cfgippattern[0].equals("*")) {
            return true;
        }
        for (String pattern : cfgippattern) {
            try {
                if (!key.matches(pattern)) continue;
                return true;
            }
            catch (PatternSyntaxException ex) {
                ConcurrentLog.warn("PROXY", "wrong ip pattern in url proxy config " + ex.getMessage());
            }
        }
        return false;
    }

    public String getServletInfo() {
        return "YaCy Proxy Servlet";
    }
}

