/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.cora.federate.solr.responsewriter.EmbeddedSolrResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.EnhancedXMLResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.GrepHTMLResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.HTMLResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.OpensearchResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.SnapshotImagesReponseWriter;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.YJsonResponseWriter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.UserDB;
import net.yacy.search.Switchboard;
import net.yacy.search.query.AccessTracker;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XSLTResponseWriter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;

public class SolrSelectServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public final Map<String, QueryResponseWriter> RESPONSE_WRITER = new HashMap<String, QueryResponseWriter>();

    public void init() {
        this.RESPONSE_WRITER.putAll(SolrCore.DEFAULT_RESPONSE_WRITERS);
        XSLTResponseWriter xsltWriter = new XSLTResponseWriter();
        OpensearchResponseWriter opensearchResponseWriter = new OpensearchResponseWriter();
        NamedList initArgs = new NamedList();
        xsltWriter.init(initArgs);
        this.RESPONSE_WRITER.put("xslt", (QueryResponseWriter)xsltWriter);
        this.RESPONSE_WRITER.put("exml", new EnhancedXMLResponseWriter());
        this.RESPONSE_WRITER.put("html", new HTMLResponseWriter());
        this.RESPONSE_WRITER.put("snapshots", new SnapshotImagesReponseWriter());
        this.RESPONSE_WRITER.put("grephtml", new GrepHTMLResponseWriter());
        this.RESPONSE_WRITER.put("rss", opensearchResponseWriter);
        this.RESPONSE_WRITER.put("opensearch", opensearchResponseWriter);
        this.RESPONSE_WRITER.put("yjson", new YJsonResponseWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        block75: {
            block76: {
                block77: {
                    block73: {
                        block74: {
                            block71: {
                                block72: {
                                    hrequest = (HttpServletRequest)request;
                                    hresponse = (HttpServletResponse)response;
                                    req /* !! */  = null;
                                    reqMethod = Method.getMethod((String)hrequest.getMethod());
                                    out = null;
                                    mmsp = SolrRequestParsers.parseQueryString((String)hrequest.getQueryString());
                                    sb = Switchboard.getSwitchboard();
                                    authenticated = hrequest.isUserInRole(UserDB.AccessRight.ADMIN_RIGHT.toString());
                                    if (mmsp.getMap().containsKey("partitions")) {
                                        partitions = mmsp.getInt("partitions", 30);
                                        sb.searchQueriesGlobal += 1.0f / (float)partitions;
                                    }
                                    profileNr = mmsp.getInt("profileNr", 0);
                                    querystring = "";
                                    if (!mmsp.getMap().containsKey("q") && mmsp.getMap().containsKey("query")) {
                                        querystring = mmsp.get("query", "");
                                        mmsp.getMap().remove("query");
                                        modifier = new QueryModifier(0);
                                        querystring = modifier.parse(querystring);
                                        modifier.apply(mmsp);
                                        qg = new QueryGoal(querystring);
                                        solrQ = qg.collectionTextQuery();
                                        mmsp.getMap().put("q", new String[]{solrQ.toString()});
                                    }
                                    q = mmsp.get("q", "");
                                    ConcurrentLog.info("SolrSelect", "client=" + RequestHeader.client(request) + " q=" + q);
                                    if (querystring.length() == 0) {
                                        querystring = q;
                                    }
                                    if (!mmsp.getMap().containsKey("start")) {
                                        startRecord = mmsp.getFieldInt("startRecord", null, 0);
                                        mmsp.getMap().remove("startRecord");
                                        mmsp.getMap().put("start", new String[]{Integer.toString(startRecord)});
                                    }
                                    if (!mmsp.getMap().containsKey("rows")) {
                                        maximumRecords = mmsp.getFieldInt("maximumRecords", null, 10);
                                        mmsp.getMap().remove("maximumRecords");
                                        mmsp.getMap().put("rows", new String[]{Integer.toString(maximumRecords)});
                                    }
                                    mmsp.getMap().put("rows", new String[]{Integer.toString(Math.min(mmsp.getInt("rows", 10), authenticated != false ? 100000000 : 100))});
                                    zeroDoc = mmsp.getInt("rows", 10) < 1;
                                    multiDoc = mmsp.getInt("rows", 10) > 1;
                                    ranking = sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr);
                                    if (!(!multiDoc || mmsp.getMap().containsKey("sort") || mmsp.getMap().containsKey("bq") || mmsp.getMap().containsKey("bf") || mmsp.getMap().containsKey("boost"))) {
                                        if (!mmsp.getMap().containsKey("defType")) {
                                            mmsp.getMap().put("defType", new String[]{"edismax"});
                                        }
                                        fq = ranking.getFilterQuery();
                                        bq = ranking.getBoostQuery();
                                        bf = ranking.getBoostFunction();
                                        if (fq.length() > 0) {
                                            mmsp.getMap().put("fq", new String[]{fq});
                                        }
                                        if (bq.length() > 0) {
                                            mmsp.getMap().put("bq", StringUtils.split((String)bq, (String)"\t\n\r\f"));
                                        }
                                        if (bf.length() > 0) {
                                            mmsp.getMap().put("boost", new String[]{bf});
                                        }
                                    }
                                    if ((responseWriter = this.RESPONSE_WRITER.get(wt = mmsp.get("wt", "xml"))) == null) {
                                        throw new ServletException("no response writer");
                                    }
                                    if (responseWriter instanceof OpensearchResponseWriter) {
                                        promoteSearchPageGreeting = sb.getConfigBool("promoteSearchPageGreeting.useNetworkName", false) != false ? sb.getConfig("network.unit.description", "") : sb.getConfig("promoteSearchPageGreeting", "");
                                        ((OpensearchResponseWriter)responseWriter).setTitle(promoteSearchPageGreeting);
                                    }
                                    if (!zeroDoc && (responseWriter instanceof YJsonResponseWriter || responseWriter instanceof OpensearchResponseWriter) && "true".equals(mmsp.get("hl", "true"))) {
                                        if (!mmsp.getMap().containsKey("hl.q")) {
                                            mmsp.getMap().put("hl.q", new String[]{q});
                                        }
                                        if (!mmsp.getMap().containsKey("hl.fl")) {
                                            mmsp.getMap().put("hl.fl", new String[]{CollectionSchema.description_txt.getSolrFieldName() + "," + CollectionSchema.h4_txt.getSolrFieldName() + "," + CollectionSchema.h3_txt.getSolrFieldName() + "," + CollectionSchema.h2_txt.getSolrFieldName() + "," + CollectionSchema.h1_txt.getSolrFieldName() + "," + CollectionSchema.text_t.getSolrFieldName()});
                                        }
                                        if (!mmsp.getMap().containsKey("hl.alternateField")) {
                                            mmsp.getMap().put("hl.alternateField", new String[]{CollectionSchema.description_txt.getSolrFieldName()});
                                        }
                                        if (!mmsp.getMap().containsKey("hl.simple.pre")) {
                                            mmsp.getMap().put("hl.simple.pre", new String[]{"<b>"});
                                        }
                                        if (!mmsp.getMap().containsKey("hl.simple.post")) {
                                            mmsp.getMap().put("hl.simple.post", new String[]{"</b>"});
                                        }
                                        if (!mmsp.getMap().containsKey("hl.fragsize")) {
                                            mmsp.getMap().put("hl.fragsize", new String[]{Integer.toString(220)});
                                        }
                                        if (!mmsp.getMap().containsKey("fl")) {
                                            mmsp.getMap().put("fl", new String[]{CollectionSchema.sku.getSolrFieldName() + "," + CollectionSchema.title.getSolrFieldName() + "," + CollectionSchema.description_txt.getSolrFieldName() + "," + CollectionSchema.id.getSolrFieldName() + "," + CollectionSchema.author.getSolrFieldName() + "," + CollectionSchema.publisher_t.getSolrFieldName() + "," + CollectionSchema.keywords.getSolrFieldName() + "," + CollectionSchema.url_paths_sxt.getSolrFieldName() + "," + CollectionSchema.last_modified.getSolrFieldName() + "," + CollectionSchema.size_i.getSolrFieldName() + "," + CollectionSchema.url_protocol_s.getSolrFieldName() + "," + CollectionSchema.url_file_ext_s.getSolrFieldName()});
                                        }
                                    }
                                    defaultConnector = (requestURI = hrequest.getRequestURI()).startsWith("/solr/webgraph") != false ? false : requestURI.startsWith("/solr/collection1") != false || mmsp.get("core", "collection1").equals("collection1") != false;
                                    mmsp.getMap().remove("core");
                                    v0 /* !! */  = connector = defaultConnector != false ? sb.index.fulltext().getDefaultEmbeddedConnector() : sb.index.fulltext().getEmbeddedConnector("webgraph");
                                    if (connector == null) {
                                        v1 = connector = defaultConnector != false ? sb.index.fulltext().getDefaultConnector() : sb.index.fulltext().getConnectorForRead("webgraph");
                                    }
                                    if (connector == null) {
                                        throw new ServletException("no core");
                                    }
                                    if (multiDoc) {
                                        if (ranking != null) {
                                            qf = ranking.getQueryFields();
                                            if (qf.length() > 4 && !mmsp.getMap().containsKey("qf")) {
                                                MultiMapSolrParams.addParam((String)"qf", (String)qf, (Map)mmsp.getMap());
                                            } else if (!mmsp.getMap().containsKey("df")) {
                                                mmsp.getMap().put("df", new String[]{CollectionSchema.text_t.getSolrFieldName()});
                                            }
                                        } else if (!mmsp.getMap().containsKey("df")) {
                                            mmsp.getMap().put("df", new String[]{CollectionSchema.text_t.getSolrFieldName()});
                                        }
                                    }
                                    if (!(connector instanceof EmbeddedSolrConnector)) ** GOTO lbl164
                                    req /* !! */  = connector.request((SolrParams)mmsp);
                                    req /* !! */ .getContext().put("requestURI", requestURI);
                                    rsp = ((EmbeddedSolrConnector)connector).query(req /* !! */ );
                                    hresponse.setHeader("Cache-Control", "no-cache, no-store");
                                    HttpCacheHeaderUtil.checkHttpCachingVeto((SolrQueryResponse)rsp, (HttpServletResponse)hresponse, (Method)reqMethod);
                                    if (rsp.getException() == null) break block71;
                                    AccessTracker.addToDump(querystring, 0L, new Date(), "sq");
                                    this.sendError(hresponse, rsp.getException());
                                    if (req /* !! */  == null) break block72;
                                    req /* !! */ .close();
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException e1) {
                                        ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
                                    }
                                }
                                return;
                            }
                            responseObj = rsp.getResponse();
                            if (responseObj instanceof ResultContext) {
                                r = ((ResultContext)responseObj).getDocList();
                                AccessTracker.addToDump(querystring, r.matches(), new Date(), "sq");
                            } else if (responseObj instanceof SolrDocumentList) {
                                r = (SolrDocumentList)responseObj;
                                AccessTracker.addToDump(querystring, r.getNumFound(), new Date(), "sq");
                            }
                            contentType = responseWriter.getContentType(req /* !! */ , rsp);
                            if (null != contentType) {
                                response.setContentType(contentType);
                            }
                            if (Method.HEAD != reqMethod) break block73;
                            if (req /* !! */  == null) break block74;
                            req /* !! */ .close();
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e1) {
                                ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
                            }
                        }
                        return;
                    }
                    if (responseWriter instanceof BinaryResponseWriter) {
                        ((BinaryResponseWriter)responseWriter).write((OutputStream)response.getOutputStream(), req /* !! */ , rsp);
                    } else {
                        osw = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
                        responseWriter.write((Writer)osw, req /* !! */ , rsp);
                        osw.close();
                    }
                    break block75;
lbl164:
                    // 1 sources

                    if (responseWriter instanceof EmbeddedSolrResponseWriter || responseWriter instanceof CSVResponseWriter || responseWriter instanceof XSLTResponseWriter || responseWriter instanceof RawResponseWriter) {
                        throw new ServletException("The writer " + responseWriter.getClass().getSimpleName() + " can only process responses from an embedded Solr server.");
                    }
                    queryRsp = connector.getResponseByParams(ModifiableSolrParams.of((SolrParams)mmsp));
                    req /* !! */  = new SolrQueryRequestBase(null, (SolrParams)mmsp){};
                    req /* !! */ .getContext().put("requestURI", requestURI);
                    rsp = new SolrQueryResponse();
                    rsp.setHttpCaching(false);
                    rsp.setAllValues(queryRsp.getResponse());
                    if (!mmsp.getBool("omitHeader", false)) {
                        responseHeader = rsp.getResponseHeader();
                        if (responseHeader == null) {
                            responseHeader = new SimpleOrderedMap();
                            responseHeader.add("params", (Object)mmsp.toNamedList());
                            rsp.addResponseHeader(responseHeader);
                        } else {
                            paramsIndex = responseHeader.indexOf("params", 0);
                            if (paramsIndex >= 0) {
                                responseHeader.setVal(paramsIndex, (Object)mmsp.toNamedList());
                            } else {
                                responseHeader.add("params", (Object)mmsp.toNamedList());
                            }
                        }
                    }
                    hresponse.setHeader("Cache-Control", "no-cache, no-store");
                    documentsList = queryRsp.getResults();
                    numFound = documentsList.getNumFound();
                    AccessTracker.addToDump(querystring, numFound, new Date(), "sq");
                    contentType = responseWriter.getContentType(req /* !! */ , rsp);
                    if (null != contentType) {
                        response.setContentType(contentType);
                    }
                    if (Method.HEAD != reqMethod) break block76;
                    if (req /* !! */  == null) break block77;
                    req /* !! */ .close();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
                    }
                }
                return;
            }
            try {
                if (responseWriter instanceof SolrjResponseWriter) {
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
                    ((SolrjResponseWriter)responseWriter).write(out, req /* !! */ , defaultConnector != false ? "collection1" : "webgraph", queryRsp);
                    break block75;
                }
                if (responseWriter instanceof BinaryResponseWriter) {
                    ((BinaryResponseWriter)responseWriter).write((OutputStream)response.getOutputStream(), req /* !! */ , rsp);
                    break block75;
                }
                osw = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
                responseWriter.write((Writer)osw, req /* !! */ , rsp);
                osw.close();
            }
            catch (Throwable ex) {
                block78: {
                    try {
                        this.sendError(hresponse, ex);
                        if (req /* !! */  == null) break block78;
                    }
                    catch (Throwable var29_42) {
                        if (req /* !! */  != null) {
                            req /* !! */ .close();
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e1) {
                                ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
                            }
                        }
                        throw var29_42;
                    }
                    req /* !! */ .close();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
                    }
                } else {
                    ** GOTO lbl249
                }
            }
        }
        if (req /* !! */  != null) {
            req /* !! */ .close();
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e1) {
                ConcurrentLog.info("SolrSelect", "Could not close output writer." + (String)(e1.getMessage() != null ? "Cause : " + e1.getMessage() : ""));
            }
        }
    }

    private void sendError(HttpServletResponse hresponse, Throwable ex) throws IOException {
        int code = ex instanceof SolrException ? ((SolrException)ex).code() : 500;
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        hresponse.sendError(code < 100 ? 500 : code, ex.getMessage() + "\n\n" + sw.toString());
    }
}

