/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.gui.Audio;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public final class transferURL {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        long start = System.currentTimeMillis();
        long freshdate = 0L;
        try {
            freshdate = GenericFormatter.SHORT_DAY_FORMATTER.parse("20061101", 0).getTime().getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post == null || env == null) {
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            return prop;
        }
        String iam = post.get("iam", "");
        String youare = post.get("youare", "");
        int urlc = post.getInt("urlc", 0);
        boolean granted = sb.getConfigBool("allowReceiveIndex", false);
        boolean blockBlacklist = sb.getConfigBool("indexReceiveBlockBlacklist", false);
        String result = "";
        String doublevalues = "0";
        Seed otherPeer = sb.peers.get(iam);
        String otherPeerName = iam + ":" + (String)(otherPeer == null ? "NULL" : otherPeer.getName() + "/" + otherPeer.getVersion());
        if (youare == null || !youare.equals(sb.peers.mySeed().hash)) {
            Network.log.info("Rejecting URLs from peer " + otherPeerName + ". Wrong target. Wanted peer=" + youare + ", iam=" + sb.peers.mySeed().hash);
            result = "wrong_target";
        } else if (!granted || sb.isRobinsonMode()) {
            Network.log.info("Rejecting URLs from peer " + otherPeerName + ". Not granted.");
            result = "error_not_granted";
        } else {
            URIMetadataNode lEntry;
            int received = 0;
            int blocked = 0;
            int doublecheck = 0;
            HashMap<String, URIMetadataNode> lEm = new HashMap<String, URIMetadataNode>();
            for (int i = 0; i < urlc; ++i) {
                String urls2 = post.get("url" + i);
                if (urls2 == null) {
                    if (Network.log.isFine()) {
                        Network.log.fine("transferURL: got null URL-string from peer " + otherPeerName);
                    }
                    ++blocked;
                    continue;
                }
                lEntry = URIMetadataNode.importEntry(urls2, "dht");
                if (lEntry == null) {
                    if (Network.log.isWarn()) {
                        Network.log.warn("transferURL: received invalid URL (entry null) from peer " + otherPeerName + "\n\tURL Property: " + urls2);
                    }
                    ++blocked;
                    continue;
                }
                if (lEntry.url() == null) {
                    if (Network.log.isWarn()) {
                        Network.log.warn("transferURL: received invalid URL from peer " + otherPeerName + "\n\tURL Property: " + urls2);
                    }
                    ++blocked;
                    continue;
                }
                if (lEntry.freshdate().getTime() <= freshdate) {
                    if (Network.log.isFine()) {
                        Network.log.fine("transerURL: received too old URL from peer " + otherPeerName + ": " + lEntry.freshdate());
                    }
                    ++blocked;
                    continue;
                }
                if (blockBlacklist && Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.DHT, lEntry.url())) {
                    if (Network.log.isFine()) {
                        Network.log.fine("transferURL: blocked blacklisted URL '" + lEntry.url().toNormalform(false) + "' from peer " + otherPeerName);
                    }
                    lEntry = null;
                    ++blocked;
                    continue;
                }
                String urlRejectReason = sb.crawlStacker.urlInAcceptedDomain(lEntry.url());
                if (urlRejectReason != null) {
                    if (Network.log.isFine()) {
                        Network.log.fine("transferURL: blocked URL '" + lEntry.url() + "' (" + urlRejectReason + ") from peer " + otherPeerName);
                    }
                    lEntry = null;
                    ++blocked;
                    continue;
                }
                lEm.put(ASCII.String(lEntry.hash()), lEntry);
            }
            doublecheck = 0;
            for (String id : lEm.keySet()) {
                if (sb.index.exists(id)) {
                    ++doublecheck;
                    continue;
                }
                lEntry = (URIMetadataNode)((Object)lEm.get(id));
                if (Network.log.isFine()) {
                    Network.log.fine("Accepting URL from peer " + otherPeerName + ": " + lEntry.url().toNormalform(true));
                }
                try {
                    sb.index.fulltext().putMetadata(lEntry);
                    ResultURLs.stack(ASCII.String(lEntry.url().hash()), lEntry.url().getHost(), iam.getBytes(), iam.getBytes(), ResultURLs.EventOrigin.DHT_TRANSFER);
                    if (Network.log.isFine()) {
                        Network.log.fine("transferURL: received URL '" + lEntry.url().toNormalform(false) + "' from peer " + otherPeerName);
                    }
                    ++received;
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            sb.peers.mySeed().incRU(received);
            Network.log.info("Received " + received + " URLs from peer " + otherPeerName + " in " + (System.currentTimeMillis() - start) + " ms, blocked " + blocked + " URLs");
            EventChannel.channels(EventChannel.DHTRECEIVE).addMessage(new RSSMessage("Received " + received + ", blocked " + blocked + " URLs from peer " + otherPeerName, "", otherPeer.hash));
            if (sb.getConfigBool("decoration.audio", false)) {
                Audio.Soundclip.dhtin.play(-10.0f);
            }
            if (doublecheck > 0) {
                Network.log.warn("Received " + doublecheck + "/" + urlc + " double URLs from peer " + otherPeerName);
                doublevalues = Integer.toString(doublecheck);
            }
            result = "ok";
        }
        prop.put("double", doublevalues);
        prop.put("result", result);
        return prop;
    }
}

