/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.rwi.IndexCell;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.OS;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.http.pool.PoolStats;

public class PerformanceQueues_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        boolean setDelay;
        BusyThread thread;
        String threadName;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        File defaultSettingsFile = new File(sb.getAppPath(), "defaults/yacy.init");
        try {
            prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        }
        catch (IllegalArgumentException e) {
            sb.log.fine("access by unauthorized or unknown user: no transaction token delivered");
        }
        Segment indexSegment = sb.index;
        if (post != null) {
            TransactionManager.checkPostTransaction(header, post);
            if (post.containsKey("resetObserver")) {
                MemoryControl.resetProperState();
            } else {
                File value;
                if (post.containsKey("defaultFile") && (value = new File(sb.getAppPath(), post.get("defaultFile", "defaults/yacy.init"))).exists() && value.isFile() && value.canRead()) {
                    defaultSettingsFile = value;
                }
                if (post.containsKey("Xmx")) {
                    int xmx = post.getInt("Xmx", 600);
                    if (OS.isWin32) {
                        xmx = Math.min(2000, xmx);
                    }
                    sb.setConfig("javastart_Xmx", "Xmx" + xmx + "m");
                    prop.put("setStartupCommit", "1");
                    prop.put("setStartupCommit_transactionToken", TransactionManager.getTransactionToken(header, "/Steering.html"));
                }
                if (post.containsKey("diskFree")) {
                    sb.setConfig("resource.disk.free.min.steadystate", post.getLong("diskFree", 2048L));
                }
                if (post.containsKey("diskFreeHardlimit")) {
                    sb.setConfig("resource.disk.free.min.undershot", post.getLong("diskFreeHardlimit", 1024L));
                    sb.setConfig("resource.disk.free.autoregulate", post.getBoolean("diskFreeAutoregulate"));
                }
                if (post.containsKey("diskUsed")) {
                    sb.setConfig("resource.disk.used.max.steadystate", post.getLong("diskUsed", 524288L));
                }
                if (post.containsKey("diskUsedHardlimit")) {
                    sb.setConfig("resource.disk.used.max.overshot", post.getLong("diskUsedHardlimit", 0x100000L));
                    sb.setConfig("resource.disk.used.autoregulate", post.getBoolean("diskUsedAutoregulate"));
                }
                if (post.containsKey("memoryAcceptDHT")) {
                    sb.setConfig("memory.acceptDHTabove", post.getInt("memoryAcceptDHT", 50));
                }
            }
        }
        ConcurrentHashMap<String, String> defaultSettings = post == null || !post.containsKey("submitdefault") ? null : FileUtils.loadMap(defaultSettingsFile);
        Iterator<String> threads = sb.threadNames();
        boolean xml = header.getPathInfo().endsWith(".xml");
        prop.setLocalized(!xml);
        long blocktime_total = 0L;
        long sleeptime_total = 0L;
        long exectime_total = 0L;
        while (threads.hasNext()) {
            threadName = threads.next();
            thread = sb.getThread(threadName);
            blocktime_total += thread.getBlockTime();
            sleeptime_total += thread.getSleepTime();
            exectime_total += thread.getExecTime();
        }
        if (blocktime_total == 0L) {
            blocktime_total = 1L;
        }
        if (sleeptime_total == 0L) {
            sleeptime_total = 1L;
        }
        if (exectime_total == 0L) {
            exectime_total = 1L;
        }
        threads = sb.threadNames();
        int c = 0;
        boolean setProfile = post != null && post.containsKey("submitdefault");
        boolean bl = setDelay = post != null && post.containsKey("submitdelay");
        if (setProfile && post != null) {
            sb.setConfig("performanceSpeed", post.getInt("profileSpeed", 100));
        }
        IndexCell<WordReference> rwi = indexSegment.termIndex();
        while (threads.hasNext()) {
            threadName = threads.next();
            thread = sb.getThread(threadName);
            prop.put("table_" + c + "_threadname", threadName);
            prop.putHTML("table_" + c + "_hasurl_shortdescr", thread.getShortDescription());
            if (thread.getMonitorURL() == null) {
                prop.put("table_" + c + "_hasurl", "0");
            } else {
                prop.put("table_" + c + "_hasurl", "1");
                prop.put("table_" + c + "_hasurl_url", thread.getMonitorURL());
            }
            prop.putHTML("table_" + c + "_longdescr", thread.getLongDescription());
            int queuesize = thread.getJobCount();
            prop.put("table_" + c + "_queuesize", queuesize == Integer.MAX_VALUE ? "unlimited" : Formatter.number(queuesize, !xml));
            long blocktime = thread.getBlockTime();
            long sleeptime = thread.getSleepTime();
            long exectime = thread.getExecTime();
            long memuse = thread.getMemoryUse();
            long idleCycles = thread.getIdleCycles();
            long busyCycles = thread.getBusyCycles();
            long memshortageCycles = thread.getOutOfMemoryCycles();
            long highCPUCycles = thread.getHighCPUCycles();
            prop.putNum("table_" + c + "_blocktime", blocktime / 1000L);
            prop.putNum("table_" + c + "_blockpercent", 100L * blocktime / blocktime_total);
            prop.putNum("table_" + c + "_sleeptime", sleeptime / 1000L);
            prop.putNum("table_" + c + "_sleeppercent", 100L * sleeptime / sleeptime_total);
            prop.putNum("table_" + c + "_exectime", exectime / 1000L);
            prop.putNum("table_" + c + "_execpercent", 100L * exectime / exectime_total);
            prop.putNum("table_" + c + "_totalcycles", idleCycles + busyCycles + memshortageCycles + highCPUCycles);
            prop.putNum("table_" + c + "_idlecycles", idleCycles);
            prop.putNum("table_" + c + "_busycycles", busyCycles);
            prop.putNum("table_" + c + "_memscycles", memshortageCycles);
            prop.putNum("table_" + c + "_highcpucycles", highCPUCycles);
            prop.putNum("table_" + c + "_sleeppercycle", idleCycles + busyCycles == 0L ? -1L : sleeptime / (idleCycles + busyCycles));
            prop.putNum("table_" + c + "_execpercycle", busyCycles == 0L ? -1L : exectime / busyCycles);
            prop.putNum("table_" + c + "_memusepercycle", busyCycles == 0L ? -1L : memuse / busyCycles / 1024L);
            long idlesleep = sb.getConfigLong(threadName + "_idlesleep", 1000L);
            long busysleep = sb.getConfigLong(threadName + "_busysleep", 100L);
            long memprereq = sb.getConfigLong(threadName + "_memprereq", 0L);
            double loadprereq = sb.getConfigFloat(threadName + "_loadprereq", 9.0f);
            if (setDelay && post != null) {
                idlesleep = post.getLong(threadName + "_idlesleep", idlesleep);
                busysleep = post.getLong(threadName + "_busysleep", busysleep);
                memprereq = post.getLong(threadName + "_memprereq", memprereq) * 1024L;
                if (memprereq == 0L) {
                    memprereq = sb.getConfigLong(threadName + "_memprereq", 0L);
                }
                if ((loadprereq = post.getDouble(threadName + "_loadprereq", loadprereq)) == 0.0) {
                    loadprereq = sb.getConfigFloat(threadName + "_loadprereq", 9.0f);
                }
                if (idlesleep < 1000L) {
                    idlesleep = 1000L;
                }
                sb.setThreadPerformance(threadName, idlesleep, busysleep, memprereq, loadprereq);
                idlesleep = sb.getConfigLong(threadName + "_idlesleep", idlesleep);
                busysleep = sb.getConfigLong(threadName + "_busysleep", busysleep);
            }
            if (setProfile) {
                idlesleep = Long.parseLong(PerformanceQueues_p.d((String)defaultSettings.get(threadName + "_idlesleep"), String.valueOf(idlesleep)));
                busysleep = Long.parseLong(PerformanceQueues_p.d((String)defaultSettings.get(threadName + "_busysleep"), String.valueOf(busysleep)));
                memprereq = Long.parseLong(PerformanceQueues_p.d((String)defaultSettings.get(threadName + "_memprereq"), String.valueOf(memprereq)));
                loadprereq = Double.parseDouble(PerformanceQueues_p.d((String)defaultSettings.get(threadName + "_loadprereq"), String.valueOf(loadprereq)));
                if (idlesleep < 1000L) {
                    idlesleep = 1000L;
                }
                sb.setThreadPerformance(threadName, idlesleep, busysleep, memprereq, loadprereq);
            }
            prop.put("table_" + c + "_idlesleep", idlesleep);
            prop.put("table_" + c + "_busysleep", busysleep);
            prop.put("table_" + c + "_memprereq", memprereq / 1024L);
            prop.put("table_" + c + "_loadprereq", loadprereq);
            prop.put("table_" + c + "_recommendation", threadName.endsWith("_indexing") ? "1" : "0");
            prop.putNum("table_" + c + "_recommendation_value", rwi == null ? 0L : (threadName.endsWith("_indexing") ? (long)(rwi.minMem() / 1024) : 0L));
            ++c;
        }
        prop.put("table", c);
        c = 0;
        int[] speedValues = new int[]{200, 150, 100, 50, 25, 10};
        int usedspeed = sb.getConfigInt("performanceSpeed", 100);
        for (int speed : speedValues) {
            prop.put("speed_" + c + "_value", speed);
            prop.put("speed_" + c + "_label", speed + " %");
            prop.put("speed_" + c + "_used", speed == usedspeed ? "1" : "0");
            ++c;
        }
        prop.put("speed", c);
        if (post != null && post.containsKey("cacheSizeSubmit")) {
            int wordCacheMaxCount = post.getInt("wordCacheMaxCount", 20000);
            sb.setConfig("wordCacheMaxCount", Integer.toString(wordCacheMaxCount));
            if (rwi != null) {
                rwi.setBufferMaxWordCount(wordCacheMaxCount);
            }
        }
        if (post != null) {
            if (post.containsKey("setRemoteSearchLoads")) {
                float loadValue = post.getFloat("remoteSearchRWIMaxLoad", sb.getConfigFloat("remotesearch.maxload.rwi", 8.0f));
                sb.setConfig("remotesearch.maxload.rwi", loadValue);
                loadValue = post.getFloat("remoteSearchSolrMaxLoad", sb.getConfigFloat("remotesearch.maxload.solr", 4.0f));
                sb.setConfig("remotesearch.maxload.solr", loadValue);
            } else if (post.containsKey("defaultRemoteSearchLoads")) {
                sb.setConfig("remotesearch.maxload.rwi", 8.0f);
                sb.setConfig("remotesearch.maxload.solr", 4.0f);
            }
        }
        if (post != null && post.containsKey("poolConfig")) {
            int maxBusy = post.getInt("Crawler Pool_maxActive", 8);
            sb.setConfig("crawler.MaxActiveThreads", maxBusy);
            maxBusy = post.getInt("Robots.txt Pool_maxActive", 200);
            sb.setConfig("robots.txt.MaxActiveThreads", maxBusy);
            try {
                maxBusy = post.getInt("httpd Session Pool_maxActive", 8);
            }
            catch (NumberFormatException e) {
                maxBusy = 8;
            }
            ConnectionInfo.setServerMaxcount(maxBusy);
            sb.setConfig("httpdMaxBusySessions", maxBusy);
        }
        if (post != null && post.containsKey("connectionPoolConfig")) {
            int maxTotal = post.getInt("http.outgoing.pool.general.maxTotal", 200);
            if (maxTotal > 0) {
                sb.setConfig("http.outgoing.pool.general.maxTotal", maxTotal);
                HTTPClient.initPoolMaxConnections(HTTPClient.CONNECTION_MANAGER, maxTotal);
            }
            if ((maxTotal = post.getInt("http.outgoing.pool.remoteSolr.maxTotal", 100)) > 0) {
                sb.setConfig("http.outgoing.pool.remoteSolr.maxTotal", maxTotal);
                RemoteInstance.initPoolMaxConnections(RemoteInstance.CONNECTION_MANAGER, maxTotal);
            }
        }
        if (post != null && post.containsKey("onlineCautionSubmit")) {
            sb.setConfig("crawlPause.proxy", Integer.toString(post.getInt("crawlPauseProxy", 30000)));
            sb.setConfig("crawlPause.localsearch", Integer.toString(post.getInt("crawlPauseLocalsearch", 30000)));
            sb.setConfig("crawlPause.remotesearch", Integer.toString(post.getInt("crawlPauseRemotesearch", 30000)));
        }
        prop.putNum("wordCacheSize", indexSegment.RWIBufferCount());
        prop.putNum("wordCacheSizeKBytes", rwi == null ? 0L : rwi.getBufferSizeBytes() / 1024L);
        prop.putNum("maxURLinCache", rwi == null ? 0L : (long)rwi.getBufferMaxReferences());
        prop.putNum("maxAgeOfCache", rwi == null ? 0L : rwi.getBufferMaxAge() / 1000L / 60L);
        prop.putNum("minAgeOfCache", rwi == null ? 0L : rwi.getBufferMinAge() / 1000L / 60L);
        prop.putNum("maxWaitingWordFlush", sb.getConfigLong("maxWaitingWordFlush", 180L));
        prop.put("wordCacheMaxCount", sb.getConfigLong("wordCacheMaxCount", 20000L));
        prop.put("crawlPauseProxy", sb.getConfigLong("crawlPause.proxy", 30000L));
        prop.put("crawlPauseLocalsearch", sb.getConfigLong("crawlPause.localsearch", 30000L));
        prop.put("crawlPauseRemotesearch", sb.getConfigLong("crawlPause.remotesearch", 30000L));
        prop.putNum("crawlPauseProxyCurrent", (System.currentTimeMillis() - sb.proxyLastAccess) / 1000L);
        prop.putNum("crawlPauseLocalsearchCurrent", (System.currentTimeMillis() - sb.localSearchLastAccess) / 1000L);
        prop.putNum("crawlPauseRemotesearchCurrent", (System.currentTimeMillis() - sb.remoteSearchLastAccess) / 1000L);
        prop.put("pool_0_name", "Crawler Pool");
        prop.put("pool_0_maxActive", sb.getConfigLong("crawler.MaxActiveThreads", 0L));
        prop.put("pool_0_numActive", sb.crawlQueues.activeWorkerEntries().size());
        prop.put("pool_1_name", "Robots.txt Pool");
        prop.put("pool_1_maxActive", sb.getConfigInt("robots.txt.MaxActiveThreads", 200));
        prop.put("pool_1_numActive", sb.crawlQueues.activeWorkerEntries().size());
        prop.put("pool_2_name", "httpd Session Pool");
        prop.put("pool_2_maxActive", ConnectionInfo.getServerMaxcount());
        prop.put("pool_2_numActive", ConnectionInfo.getServerCount());
        prop.put("pool", "3");
        prop.put("http.outgoing.pool.general.maxTotal", sb.getConfigInt("http.outgoing.pool.general.maxTotal", 200));
        prop.put("http.outgoing.pool.remoteSolr.maxTotal", sb.getConfigInt("http.outgoing.pool.remoteSolr.maxTotal", 100));
        PoolStats stats = HTTPClient.CONNECTION_MANAGER.getTotalStats();
        prop.put("pool.general.leased", stats.getLeased());
        prop.put("pool.general.available", stats.getAvailable());
        prop.put("pool.general.pending", stats.getPending());
        stats = RemoteInstance.CONNECTION_MANAGER.getTotalStats();
        prop.put("pool.remoteSolr.leased", stats.getLeased());
        prop.put("pool.remoteSolr.available", stats.getAvailable());
        prop.put("pool.remoteSolr.pending", stats.getPending());
        prop.put("remoteSearchRWIMaxLoad", sb.getConfigFloat("remotesearch.maxload.rwi", 8.0f));
        prop.put("remoteSearchSolrMaxLoad", sb.getConfigFloat("remotesearch.maxload.solr", 4.0f));
        String Xmx = sb.getConfig("javastart_Xmx", "Xmx600m").substring(3);
        prop.put("Xmx", Xmx.substring(0, Xmx.length() - 1));
        long diskFree = sb.getConfigLong("resource.disk.free.min.steadystate", 3000L);
        long diskFreeHardlimit = sb.getConfigLong("resource.disk.free.min.undershot", 1000L);
        long memoryAcceptDHT = sb.getConfigLong("memory.acceptDHTabove", 50L);
        boolean observerTrigger = !MemoryControl.properState();
        prop.put("diskFree", diskFree);
        prop.put("diskFreeHardlimit", diskFreeHardlimit);
        prop.put("diskFreeAutoregulate", sb.getConfigBool("resource.disk.free.autoregulate", false) ? 1L : 0L);
        prop.put("diskUsed", sb.getConfigLong("resource.disk.used.max.steadystate", 524288L));
        prop.put("diskUsedHardlimit", sb.getConfigLong("resource.disk.used.max.overshot", 0x100000L));
        prop.put("diskUsedAutoregulate", sb.getConfigBool("resource.disk.used.autoregulate", false) ? 1L : 0L);
        prop.put("memoryAcceptDHT", memoryAcceptDHT);
        if (observerTrigger) {
            prop.put("observerTrigger", "1");
        }
        return prop;
    }

    private static String d(String a, String b) {
        return a == null ? b : a;
    }
}

