/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.RecrawlBusyThread;
import net.yacy.data.TransactionManager;
import net.yacy.data.WorkTables;
import net.yacy.kelondro.blob.Tables;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.migration;
import net.yacy.search.Switchboard;
import net.yacy.search.index.ReindexSolrBusyThread;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexReIndexMonitor_p {
    private static final String SERVLET_NAME = IndexReIndexMonitor_p.class.getSimpleName() + ".html";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String nextTransactionToken = TransactionManager.getTransactionToken(header);
        prop.put("transactionToken", nextTransactionToken);
        prop.put("docsprocessed", "0");
        prop.put("currentselectquery", "");
        BusyThread reidxbt = sb.getThread("reindexSolr");
        if (reidxbt == null && post != null && post.containsKey("reindexnow") && sb.index.fulltext().connectedLocalSolr()) {
            TransactionManager.checkPostTransaction(header, post);
            migration.reindexToschema(sb);
            prop.put("querysize", "0");
            prop.put("infomessage", "reindex job started");
            reidxbt = sb.getThread("reindexSolr");
        }
        if (reidxbt != null) {
            prop.put("reindexjobrunning", 1L);
            prop.put("querysize", reidxbt.getJobCount());
            if (reidxbt instanceof ReindexSolrBusyThread) {
                prop.put("docsprocessed", ((ReindexSolrBusyThread)reidxbt).getProcessed());
                prop.put("currentselectquery", "q=" + ((ReindexSolrBusyThread)reidxbt).getCurrentQuery());
                OrderedScoreMap<String> querylist = ((ReindexSolrBusyThread)reidxbt).getQueryList();
                if (querylist != null) {
                    int i = 0;
                    for (String oneqs : querylist) {
                        prop.put("reindexjobrunning_fieldlist_" + i + "_fieldname", oneqs.substring(0, oneqs.indexOf(58)));
                        prop.put("reindexjobrunning_fieldlist_" + i + "_fieldscore", querylist.get(oneqs));
                        ++i;
                    }
                    prop.put("reindexjobrunning_fieldlist", querylist.size());
                } else {
                    prop.put("reindexjobrunning_fieldlist", 0L);
                }
            }
            if (post != null && post.containsKey("stopreindex")) {
                TransactionManager.checkPostTransaction(header, post);
                sb.terminateThread("reindexSolr", false);
                prop.put("infomessage", "reindex job stopped");
                prop.put("reindexjobrunning", 0L);
            } else {
                prop.put("infomessage", "reindex is running");
            }
        } else {
            prop.put("reindexjobrunning", 0L);
            if (sb.index.fulltext().connectedLocalSolr()) {
                prop.put("querysize", "is empty");
                prop.put("infomessage", "no reindex job running");
            } else {
                prop.put("querysize", "");
                prop.putHTML("infomessage", "! reindex works only with embedded Solr index !");
            }
        }
        IndexReIndexMonitor_p.processReindexReport(header, sb, prop, reidxbt instanceof ReindexSolrBusyThread ? (ReindexSolrBusyThread)reidxbt : null);
        BusyThread recrawlbt = sb.getThread("recrawlindex");
        String recrawlQuery = RecrawlBusyThread.DEFAULT_QUERY;
        boolean inclerrdoc = false;
        boolean deleteOnRecrawl = false;
        if (post != null && "recrawljob".equals(post.get("setup"))) {
            TransactionManager.checkPostTransaction(header, post);
            if (post.containsKey("recrawlquerytext")) {
                recrawlQuery = post.get("recrawlquerytext");
            }
            if (post.containsKey("includefailedurls")) {
                inclerrdoc = post.getBoolean("includefailedurls");
            }
            if (post.containsKey("deleteOnRecrawl")) {
                deleteOnRecrawl = post.getBoolean("deleteOnRecrawl");
            }
            if (recrawlbt == null || recrawlbt.shutdownInProgress()) {
                block34: {
                    prop.put("recrawljobrunning_simulationResult", 0L);
                    prop.put("recrawljobrunning_error", 0L);
                    if (post.containsKey("recrawlnow")) {
                        sb.deployThread("recrawlindex", "ReCrawl", "recrawl existing documents", null, new RecrawlBusyThread(Switchboard.getSwitchboard(), recrawlQuery, inclerrdoc, deleteOnRecrawl), 1000L);
                        recrawlbt = sb.getThread("recrawlindex");
                        if (sb.tables != null) {
                            byte[] lastExecutedCallPk;
                            Tables.Row lastExecutedCall = WorkTables.selectLastExecutedApiCall(SERVLET_NAME, post, sb);
                            if (lastExecutedCall != null && !post.containsKey("apicall_pk") && (lastExecutedCallPk = lastExecutedCall.getPK()) != null) {
                                post.add("apicall_pk", UTF8.String(lastExecutedCallPk));
                            }
                            sb.tables.recordAPICall(post, SERVLET_NAME, "crawler", "Recrawl documents matching selection query : " + recrawlQuery);
                        }
                    } else if (post.containsKey("simulateRecrawl")) {
                        SolrConnector solrConnector = sb.index.fulltext().getDefaultConnector();
                        if (solrConnector != null && !solrConnector.isClosed()) {
                            try {
                                solrConnector.commit(true);
                                String finalQuery = RecrawlBusyThread.buildSelectionQuery(recrawlQuery, inclerrdoc);
                                long count = solrConnector.getCountByQuery(finalQuery);
                                prop.put("recrawljobrunning_simulationResult", 1L);
                                prop.put("recrawljobrunning_simulationResult_docCount", count);
                                if (count > 0L) {
                                    int maxRows = 10;
                                    String solrSelectUrl = IndexReIndexMonitor_p.genLocalSolrSelectUrl(finalQuery, 10);
                                    prop.put("recrawljobrunning_simulationResult_showSelectLink", 1L);
                                    prop.put("recrawljobrunning_simulationResult_showSelectLink_rows", 10L);
                                    prop.put("recrawljobrunning_simulationResult_showSelectLink_browseSelectedUrl", solrSelectUrl);
                                    break block34;
                                }
                                prop.put("recrawljobrunning_simulationResult_showSelectLink", 0L);
                            }
                            catch (IOException e) {
                                prop.put("recrawljobrunning_simulationResult", 2L);
                                ConcurrentLog.logException(e);
                            }
                        } else {
                            prop.put("recrawljobrunning_simulationResult", 3L);
                        }
                    }
                }
                if (post.containsKey("recrawlDefaults")) {
                    recrawlQuery = RecrawlBusyThread.DEFAULT_QUERY;
                    inclerrdoc = false;
                    deleteOnRecrawl = false;
                }
            } else if (post.containsKey("stoprecrawl")) {
                recrawlbt.terminate(false);
                prop.put("recrawljobrunning", 0L);
            }
            if (recrawlbt != null && !recrawlbt.shutdownInProgress()) {
                if (post.containsKey("updquery") && post.containsKey("recrawlquerytext")) {
                    ((RecrawlBusyThread)recrawlbt).setQuery(recrawlQuery, inclerrdoc, deleteOnRecrawl);
                } else {
                    ((RecrawlBusyThread)recrawlbt).setIncludeFailed(inclerrdoc);
                    ((RecrawlBusyThread)recrawlbt).setDeleteOnRecrawl(deleteOnRecrawl);
                }
            }
        }
        IndexReIndexMonitor_p.processRecrawlReport(header, sb, prop, (RecrawlBusyThread)recrawlbt);
        if (recrawlbt != null && !recrawlbt.shutdownInProgress()) {
            prop.put("recrawljobrunning", 1L);
            prop.put("recrawljobrunning_docCount", ((RecrawlBusyThread)recrawlbt).getUrlsToRecrawl());
            prop.put("recrawljobrunning_recrawlquerytext", ((RecrawlBusyThread)recrawlbt).getQuery());
            prop.put("recrawljobrunning_includefailedurls", ((RecrawlBusyThread)recrawlbt).getIncludeFailed());
            prop.put("recrawljobrunning_deleteOnRecrawl", ((RecrawlBusyThread)recrawlbt).getDeleteOnRecrawl());
        } else {
            prop.put("recrawljobrunning", 0L);
            prop.put("recrawljobrunning_recrawlquerytext", recrawlQuery);
            prop.put("recrawljobrunning_includefailedurls", inclerrdoc);
            prop.put("recrawljobrunning_deleteOnRecrawl", deleteOnRecrawl);
        }
        return prop;
    }

    private static void processReindexReport(RequestHeader header, Switchboard sb, serverObjects prop, ReindexSolrBusyThread recrawlbt) {
        if (recrawlbt != null) {
            prop.put("reindexReport", 1L);
            prop.put("reindexReport_currentQuery", recrawlbt.getCurrentQuery());
            prop.put("reindexReport_currentQuerySize", recrawlbt.getQueryList() != null ? (long)recrawlbt.getQueryList().size() : 0L);
            prop.put("reindexReport_processedCount", recrawlbt.getProcessed());
        } else {
            prop.put("reindexReport", 0L);
        }
    }

    protected static String genLocalSolrSelectUrl(String query2, int maxRows) {
        String urlEncodedQUery;
        try {
            urlEncodedQUery = URLEncoder.encode(query2, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            urlEncodedQUery = query2;
        }
        return "solr/select?core=collection1&wt=html&start=0&rows=" + maxRows + "&q=" + urlEncodedQUery;
    }

    private static void processRecrawlReport(RequestHeader header, Switchboard sb, serverObjects prop, RecrawlBusyThread recrawlbt) {
        if (recrawlbt != null) {
            String lng;
            prop.put("recrawlReport", 1L);
            prop.put("recrawlReport_error", recrawlbt.isTerminatedBySolrFailure());
            int jobStatus = recrawlbt.isAlive() ? (recrawlbt.shutdownInProgress() ? 1 : 0) : 2;
            prop.put("recrawlReport_jobStatus", jobStatus);
            prop.put("recrawlReport_recrawlquerytext", recrawlbt.getQuery());
            Locale formatLocale = sb != null ? ("browser".equals(lng = sb.getConfig("locale.language", Locale.ENGLISH.getLanguage())) ? header.getLocale() : Locale.forLanguageTag(lng)) : Locale.ENGLISH;
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(formatLocale);
            prop.put("recrawlReport_startTime", IndexReIndexMonitor_p.formatDateTime(formatter, recrawlbt.getStartTime()));
            prop.put("recrawlReport_endTime", IndexReIndexMonitor_p.formatDateTime(formatter, recrawlbt.getEndTime()));
            prop.put("recrawlReport_urlsToRecrawlCount", recrawlbt.getUrlsToRecrawl());
            prop.put("recrawlReport_recrawledUrlsCount", recrawlbt.getRecrawledUrlsCount());
            prop.put("recrawlReport_rejectedUrlsCount", recrawlbt.getRejectedUrlsCount());
            prop.put("recrawlReport_malformedUrlsCount", recrawlbt.getMalformedUrlsCount());
            prop.put("recrawlReport_malformedUrlsDeletedCount", recrawlbt.getMalformedUrlsDeletedCount());
        } else {
            prop.put("recrawlReport", 0L);
        }
    }

    protected static String formatDateTime(DateTimeFormatter formatter, LocalDateTime time) {
        String formattedTime;
        if (time != null) {
            try {
                formattedTime = time.format(formatter);
            }
            catch (DateTimeException e) {
                formattedTime = time.toString();
            }
        } else {
            formattedTime = "";
        }
        return formattedTime;
    }
}

