/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrException;

public class IndexExport_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        File dump;
        long ucount;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        long ucount200 = ucount = segment.fulltext().collectionSize();
        try {
            ucount200 = segment.fulltext().getDefaultConnector().getCountByQuery(CollectionSchema.httpstatus_i.getSolrFieldName() + ":200");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        prop.put("otherHosts", "");
        prop.put("reload", 0L);
        prop.put("indexdump", 0L);
        prop.put("indexRestore", 0L);
        prop.put("lurlexport", 0L);
        prop.put("reload", 0L);
        prop.put("dumprestore", 1L);
        prop.put("dumprestore_dumpRestoreEnabled", sb.getConfigBool("core.service.fulltext", true));
        List<File> dumpFiles = segment.fulltext().dumpFiles();
        prop.put("dumprestore_dumpfile", dumpFiles.size() == 0 ? "" : dumpFiles.get(dumpFiles.size() - 1).getAbsolutePath());
        prop.put("dumprestore_optimizemax", 10L);
        prop.putNum("ucount", ucount);
        prop.putNum("ucount200", ucount200);
        Fulltext.Export export = segment.fulltext().export();
        if (export != null && export.isAlive()) {
            prop.put("lurlexport", 2L);
            prop.put("lurlexportfinished", 0L);
            prop.put("lurlexporterror", 0L);
            prop.put("lurlexport_exportfile", export.file().toString());
            prop.put("lurlexport_urlcount", export.docCount());
            prop.put("reload", 1L);
        } else {
            prop.put("lurlexport", 1L);
            prop.put("lurlexport_exportfilepath", sb.getDataPath() + "/DATA/EXPORT/");
            if (export == null) {
                prop.put("lurlexportfinished", 0L);
                prop.put("lurlexporterror", 0L);
            } else {
                prop.put("lurlexportfinished", 1L);
                prop.put("lurlexportfinished_exportfile", export.file().toString());
                prop.put("lurlexportfinished_urlcount", export.docCount());
                if (export.failed() == null) {
                    prop.put("lurlexporterror", 0L);
                } else {
                    prop.put("lurlexporterror", 1L);
                    prop.put("lurlexporterror_exportfile", export.file().toString());
                    prop.put("lurlexporterror_exportfailmsg", export.failed());
                }
            }
        }
        if (post == null || env == null) {
            return prop;
        }
        if (post.containsKey("lurlexport")) {
            Fulltext.ExportFormat format = Fulltext.ExportFormat.text;
            String fname = post.get("format", "url-text");
            boolean dom = fname.startsWith("dom");
            boolean text = fname.startsWith("text");
            if (fname.endsWith("text")) {
                format = Fulltext.ExportFormat.text;
            }
            if (fname.endsWith("html")) {
                format = Fulltext.ExportFormat.html;
            }
            if (fname.endsWith("rss")) {
                format = Fulltext.ExportFormat.rss;
            }
            if (fname.endsWith("solr")) {
                format = Fulltext.ExportFormat.solr;
            }
            if (fname.endsWith("elasticsearch")) {
                format = Fulltext.ExportFormat.elasticsearch;
            }
            String filter = post.get("exportfilter", ".*");
            String query2 = post.get("exportquery", "*:*");
            int maxseconds = post.getInt("exportmaxseconds", -1);
            long maxChunkSize = post.getLong("maxchunksize", Long.MAX_VALUE);
            if (maxChunkSize <= 0L) {
                maxChunkSize = Long.MAX_VALUE;
            }
            String path = post.get("exportfilepath", "");
            boolean minified = post.get("minified", "no").equals("yes");
            if (maxseconds != -1) {
                sb.tables.recordAPICall(post, "IndexExport_p.html", "dump", format + "-dump, q=" + query2 + ", maxseconds=" + maxseconds);
            }
            try {
                export = sb.index.fulltext().export(format, filter, query2, maxseconds, new File(path), dom, text, maxChunkSize, minified);
            }
            catch (IOException e) {
                prop.put("lurlexporterror", 1L);
                prop.put("lurlexporterror_exportfile", "-no export-");
                prop.put("lurlexporterror_exportfailmsg", e.getMessage());
                return prop;
            }
            prop.put("lurlexport_exportfile", export.file().toString());
            prop.put("lurlexport_urlcount", export.docCount());
            if (export != null && export.failed() == null) {
                prop.put("lurlexport", 2L);
            }
            prop.put("reload", 1L);
        }
        if (post.containsKey("indexdump")) {
            try {
                dump = segment.fulltext().dumpEmbeddedSolr();
                prop.put("indexdump", 1L);
                prop.put("indexdump_dumpfile", dump.getAbsolutePath());
                dumpFiles = segment.fulltext().dumpFiles();
                prop.put("dumprestore_dumpfile", dumpFiles.size() == 0 ? "" : dumpFiles.get(dumpFiles.size() - 1).getAbsolutePath());
            }
            catch (SolrException e) {
                if (SolrException.ErrorCode.SERVICE_UNAVAILABLE.code == e.code()) {
                    prop.put("indexdump", 2L);
                }
                prop.put("indexdump", 3L);
            }
        }
        if (post.containsKey("indexrestore")) {
            try {
                dump = new File(post.get("dumpfile", ""));
                segment.fulltext().restoreEmbeddedSolr(dump);
                prop.put("indexRestore", 1L);
            }
            catch (SolrException e) {
                if (SolrException.ErrorCode.SERVICE_UNAVAILABLE.code == e.code()) {
                    prop.put("indexRestore", 2L);
                }
                prop.put("indexRestore", 3L);
            }
        }
        prop.putNum("ucount", ucount);
        return prop;
    }
}

