/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class opensearchdescriptionReader
extends DefaultHandler {
    private static final String[] tagsDef = new String[]{"ShortName", "LongName", "Language", "OutputEncoding", "InputEncoding", "AdultContent", "Description", "Url", "Developer", "Query", "Tags", "Contact", "Attribution", "SyndicationRight"};
    private static final HashSet<String> tags = new HashSet();
    private final StringBuilder buffer;
    private boolean parsingDescription = false;
    private boolean parsingTextValue = false;
    private final HashMap<String, String> items = new HashMap();
    private String rssurl = null;
    private String atomurl = null;
    private ClientIdentification.Agent agent;
    private static final ThreadLocal<SAXParser> tlSax;

    public opensearchdescriptionReader() {
        this.buffer = new StringBuilder();
        this.agent = ClientIdentification.yacyInternetCrawlerAgent;
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    public opensearchdescriptionReader(String path) {
        this();
        try {
            SAXParser saxParser = opensearchdescriptionReader.getParser();
            saxParser.parse(path, (DefaultHandler)this);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    public opensearchdescriptionReader(InputStream stream) {
        this();
        try {
            SAXParser saxParser = opensearchdescriptionReader.getParser();
            saxParser.parse(stream, (DefaultHandler)this);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    public opensearchdescriptionReader(String path, ClientIdentification.Agent agent) {
        this();
        this.agent = agent;
        try (HTTPClient www = new HTTPClient(agent);){
            www.GET(path, false);
            SAXParser saxParser = opensearchdescriptionReader.getParser();
            saxParser.parse(www.getContentstream(), (DefaultHandler)this);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean read(String path) {
        this.items.clear();
        this.buffer.setLength(0);
        this.parsingDescription = false;
        this.parsingTextValue = false;
        this.rssurl = null;
        this.atomurl = null;
        try {
            Throwable throwable2;
            HTTPClient www = new HTTPClient(this.agent);
            try {
                www.GET(path, false);
                SAXParser saxParser = opensearchdescriptionReader.getParser();
                try {
                    saxParser.parse(www.getContentstream(), (DefaultHandler)this);
                }
                catch (SAXException se) {
                    boolean bl = false;
                    www.close();
                    return bl;
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    www.close();
                    return bl;
                }
                boolean bl = true;
                return bl;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                try {
                    www.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
            }
        }
        catch (Exception e) {
            ConcurrentLog.warn("opensearchdescriptionReader", "parse exception: " + e);
            return false;
        }
    }

    @Override
    public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
        if ("OpenSearchDescription".equals(tag)) {
            this.parsingDescription = true;
        } else if (this.parsingDescription) {
            if ("Url".equals(tag)) {
                this.parsingTextValue = false;
                String type = atts.getValue("type");
                if ("application/rss+xml".equals(type)) {
                    this.rssurl = atts.getValue("template");
                } else if ("application/atom+xml".equals(type)) {
                    this.atomurl = atts.getValue("template");
                }
            } else {
                this.parsingTextValue = tags.contains(tag);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String tag) {
        if (tag == null) {
            return;
        }
        if (this.parsingDescription && "OpenSearchDescription".equals(tag)) {
            this.parsingDescription = false;
        } else if (this.parsingTextValue) {
            String value = this.buffer.toString().trim();
            this.buffer.setLength(0);
            if (tags.contains(tag)) {
                this.items.put(tag, value);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parsingTextValue) {
            this.buffer.append(ch, start, length);
        }
    }

    public String getRSSTemplate() {
        return this.rssurl;
    }

    public String getRSSorAtomUrl() {
        return this.rssurl == null ? this.atomurl : this.rssurl;
    }

    public String getShortName() {
        return this.items.get("ShortName");
    }

    public String getItem(String name) {
        return this.items.get(name);
    }

    public int items() {
        return this.items.size();
    }

    static {
        for (String element : tagsDef) {
            tags.add(element);
        }
        tlSax = new ThreadLocal();
    }
}

