/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpsf.SummaryInformation;

public class vsdParser
extends AbstractParser
implements Parser {
    public vsdParser() {
        super("Microsoft Visio Parser");
        this.SUPPORTED_EXTENSIONS.add("vsd");
        this.SUPPORTED_EXTENSIONS.add("vss");
        this.SUPPORTED_EXTENSIONS.add("vst");
        this.SUPPORTED_EXTENSIONS.add("vdx");
        this.SUPPORTED_EXTENSIONS.add("vtx");
        this.SUPPORTED_MIME_TYPES.add("application/visio");
        this.SUPPORTED_MIME_TYPES.add("application/x-visio");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.visio");
        this.SUPPORTED_MIME_TYPES.add("application/visio.drawing");
        this.SUPPORTED_MIME_TYPES.add("application/vsd");
        this.SUPPORTED_MIME_TYPES.add("application/x-vsd");
        this.SUPPORTED_MIME_TYPES.add("image/x-vsd");
        this.SUPPORTED_MIME_TYPES.add("zz-application/zz-winassoc-vsd");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            String contents = "";
            SummaryInformation summary = null;
            try {
                VisioTextExtractor extractor = new VisioTextExtractor(source);
                contents = extractor.getText();
                summary = extractor.getSummaryInformation();
                extractor.close();
            }
            catch (Exception e) {
                ConcurrentLog.warn("vsdParser", e.getMessage());
            }
            String author = null;
            String[] keywords = null;
            String title = null;
            ArrayList<String> descriptions = null;
            Date lastModified = null;
            if (summary != null) {
                author = summary.getAuthor();
                if (summary.getKeywords() != null) {
                    keywords = summary.getKeywords().split("[ ,;]");
                }
                title = summary.getTitle();
                String subject = summary.getSubject();
                if (subject != null && !subject.isEmpty()) {
                    descriptions = new ArrayList<String>();
                    descriptions.add(subject);
                }
                lastModified = summary.getLastSaveDateTime();
            }
            if (title == null) {
                title = location.toNormalform(true);
            }
            return new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, keywords, vsdParser.singleList(title), author, null, null, descriptions, 0.0, 0.0, contents, null, null, null, false, lastModified)};
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            String errorMsg = "Unable to parse the vsd document '" + location + "':" + e.getMessage();
            AbstractParser.log.severe(errorMsg);
            throw new Parser.Failure(errorMsg, location);
        }
    }
}

