/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.util.CommonPattern;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;

public class vcfParser
extends AbstractParser
implements Parser {
    public vcfParser() {
        super("vCard Parser");
        this.SUPPORTED_EXTENSIONS.add("vcf");
        this.SUPPORTED_MIME_TYPES.add("text/x-vcard");
        this.SUPPORTED_MIME_TYPES.add("application/vcard");
        this.SUPPORTED_MIME_TYPES.add("application/x-versit");
        this.SUPPORTED_MIME_TYPES.add("text/x-versit");
        this.SUPPORTED_MIME_TYPES.add("text/x-vcalendar");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            BufferedReader inputReader;
            StringBuilder parsedTitle = new StringBuilder();
            StringBuilder parsedDataText = new StringBuilder();
            HashMap<String, Object> parsedData = new HashMap<String, Object>();
            ArrayList<AnchorURL> anchors = new ArrayList<AnchorURL>();
            LinkedList<String> parsedNames = new LinkedList<String>();
            Date revDate = null;
            boolean useLastLine = false;
            int lineNr = 0;
            String line = null;
            BufferedReader bufferedReader = inputReader = charset != null ? new BufferedReader(new InputStreamReader(source, charset)) : new BufferedReader(new InputStreamReader(source));
            while (true) {
                if (!useLastLine) {
                    line = inputReader.readLine();
                } else {
                    useLastLine = false;
                }
                if (line == null) break;
                if (line.isEmpty()) continue;
                ++lineNr;
                int pos = line.indexOf(58, 0);
                if (pos != -1) {
                    String key = line.substring(0, pos).trim().toUpperCase();
                    Object value2 = line.substring(pos + 1).trim();
                    String encoding = null;
                    String[] keyParts = CommonPattern.SEMICOLON.split(key);
                    if (keyParts.length > 1) {
                        for (String keyPart : keyParts) {
                            if (keyPart.toUpperCase().startsWith("ENCODING")) {
                                encoding = keyPart.substring("ENCODING".length() + 1);
                                continue;
                            }
                            if (keyPart.toUpperCase().startsWith("QUOTED-PRINTABLE")) {
                                encoding = "QUOTED-PRINTABLE";
                                continue;
                            }
                            if (!keyPart.toUpperCase().startsWith("BASE64")) continue;
                            encoding = "BASE64";
                        }
                        if (encoding != null) {
                            try {
                                if (encoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
                                    if (line.endsWith("=")) {
                                        do {
                                            value2 = ((String)value2).substring(0, ((String)value2).length() - 1);
                                            line = inputReader.readLine();
                                            if (line == null) break;
                                            value2 = (String)value2 + line;
                                        } while (line.endsWith("="));
                                    }
                                    value2 = this.decodeQuotedPrintable((String)value2);
                                } else if (encoding.equalsIgnoreCase("base64")) {
                                    while ((line = inputReader.readLine()) != null) {
                                        if (line.indexOf(58, 0) != -1) {
                                            useLastLine = true;
                                        }
                                        if (useLastLine) break;
                                        value2 = (String)value2 + line.trim();
                                        if (line.length() != 0) continue;
                                    }
                                    value2 = Base64Order.standardCoder.decodeString((String)value2);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (key.equalsIgnoreCase("END")) {
                        String name = null;
                        String title = null;
                        if (parsedData.containsKey("FN")) {
                            name = (String)parsedData.get("FN");
                            parsedNames.add(name);
                        } else if (parsedData.containsKey("N")) {
                            name = (String)parsedData.get("N");
                            parsedNames.add(name);
                        } else {
                            name = "unknown name";
                            parsedNames.add("unknown name");
                        }
                        if (parsedData.containsKey("TITLE")) {
                            title = (String)parsedData.get("TITLE");
                            parsedNames.add(title);
                        }
                        if (parsedTitle.length() > 0) {
                            parsedTitle.append(", ");
                        }
                        parsedTitle.append((String)(title == null ? name : name + " - " + title));
                        for (Object value2 : parsedData.values()) {
                            parsedDataText.append((String)value2).append("\r\n");
                        }
                        parsedDataText.append("\r\n");
                        value2 = (String)parsedData.get("REV");
                        if (value2 != null && !((String)value2).isEmpty()) {
                            try {
                                revDate = ISO8601Formatter.FORMATTER.parse((String)value2, 0).getTime();
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        parsedData.clear();
                        continue;
                    }
                    if (key.toUpperCase().startsWith("URL")) {
                        try {
                            AnchorURL newURL = new AnchorURL((String)value2);
                            newURL.setNameProperty(newURL.toNormalform(false));
                            anchors.add(newURL);
                        }
                        catch (MalformedURLException malformedURLException) {}
                        continue;
                    }
                    if (key.equalsIgnoreCase("BEGIN") || key.equalsIgnoreCase("END") || key.equalsIgnoreCase("VERSION") || key.toUpperCase().startsWith("LOGO") || key.toUpperCase().startsWith("PHOTO") || key.toUpperCase().startsWith("SOUND") || key.toUpperCase().startsWith("KEY") || key.toUpperCase().startsWith("X-") || ((String)value2).length() <= 0) continue;
                    parsedData.put(key, value2);
                    continue;
                }
                if (!AbstractParser.log.isFinest()) continue;
                AbstractParser.log.finest("Invalid data in vcf file\n\tURL: " + location + "\n\tLine: " + line + "\n\tLine-Nr: " + lineNr);
            }
            try {
                inputReader.close();
            }
            catch (IOException pos) {
                // empty catch block
            }
            String[] sections = parsedNames.toArray(new String[parsedNames.size()]);
            byte[] text = UTF8.getBytes(parsedDataText.toString());
            ArrayList<String> descriptions = new ArrayList<String>(1);
            descriptions.add("vCard");
            return new Document[]{new Document(location, mimeType, null, this, null, null, vcfParser.singleList(parsedTitle.toString()), null, "", sections, descriptions, 0.0, 0.0, text, anchors, null, null, false, revDate)};
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing vcf resource. " + e.getMessage(), location);
        }
    }

    private String decodeQuotedPrintable(String s) {
        if (s == null) {
            return null;
        }
        byte[] b = UTF8.getBytes(s);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            byte c = b[i];
            if (c == 61) {
                try {
                    int u = Character.digit((char)b[++i], 16);
                    int l = Character.digit((char)b[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new RuntimeException("bad quoted-printable encoding");
                    }
                    sb.append((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("bad quoted-printable encoding");
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }
}

