/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.kelondro.util.FileUtils;

public class psParser
extends AbstractParser
implements Parser {
    private static final Object modeScan = new Object();
    private static boolean modeScanDone = false;
    private static String parserMode = "java";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public psParser() {
        super("PostScript Document Parser");
        this.SUPPORTED_EXTENSIONS.add("ps");
        this.SUPPORTED_MIME_TYPES.add("application/postscript");
        this.SUPPORTED_MIME_TYPES.add("application/ps");
        this.SUPPORTED_MIME_TYPES.add("application/x-postscript");
        this.SUPPORTED_MIME_TYPES.add("application/x-ps");
        this.SUPPORTED_MIME_TYPES.add("application/x-postscript-not-eps");
        if (!modeScanDone) {
            Object object = modeScan;
            synchronized (object) {
                parserMode = this.testForPs2Ascii() ? "ps2ascii" : "java";
                modeScanDone = true;
            }
        }
    }

    private boolean testForPs2Ascii() {
        try {
            String procOutputLine = null;
            StringBuilder procOutput = new StringBuilder(80);
            Process ps2asciiProc = Runtime.getRuntime().exec(new String[]{"ps2ascii", "--version"});
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(ps2asciiProc.getInputStream()));
            while ((procOutputLine = stdOut.readLine()) != null) {
                procOutput.append(procOutputLine).append(", ");
            }
            stdOut.close();
            int returnCode = ps2asciiProc.waitFor();
            return returnCode == 0;
        }
        catch (Exception e) {
            if (AbstractParser.log != null) {
                AbstractParser.log.info("ps2ascii not found. Switching to java parser mode.");
            }
            return false;
        }
    }

    private Document[] parse(DigestURL location, String mimeType, String charset, File sourceFile) throws Parser.Failure, InterruptedException {
        File outputFile = null;
        try {
            Document[] docs;
            outputFile = FileUtils.createTempFile(this.getClass(), "ascii.txt");
            if (parserMode.equals("ps2ascii")) {
                this.parseUsingPS2ascii(sourceFile, outputFile);
            } else {
                psParser.parseUsingJava(sourceFile, outputFile);
            }
            Document[] documentArray = docs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, null, null, null, "", null, null, 0.0, 0.0, outputFile, null, null, null, false, new Date())};
            return documentArray;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing ps file. " + e.getMessage(), location);
        }
        finally {
            if (outputFile != null) {
                FileUtils.deletedelete(outputFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseUsingJava(File inputFile, File outputFile) throws Exception {
        block33: {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(inputFile));
                writer = new BufferedWriter(new FileWriter(outputFile));
                String versionInfoLine = reader.readLine();
                String version2 = versionInfoLine == null ? "" : versionInfoLine.substring(versionInfoLine.length() - 3);
                int ichar = 0;
                boolean isComment = false;
                boolean isText = false;
                if (version2.length() > 0 && version2.charAt(0) == '2') {
                    boolean isConnector = false;
                    while ((ichar = reader.read()) > 0) {
                        if (isConnector) {
                            if (ichar < 108) {
                                writer.write(32);
                            }
                            isConnector = false;
                            continue;
                        }
                        if (ichar == 37) {
                            isComment = true;
                            continue;
                        }
                        if (ichar == 10 && isComment) {
                            isComment = false;
                            continue;
                        }
                        if (ichar == 41 && isText) {
                            isConnector = true;
                            isText = false;
                            continue;
                        }
                        if (isText) {
                            writer.write((char)ichar);
                            continue;
                        }
                        if (ichar != 40 || isComment) continue;
                        isText = true;
                    }
                    break block33;
                }
                if (version2.length() > 0 && version2.charAt(0) == '3') {
                    StringBuilder stmt = new StringBuilder();
                    boolean isBMP = false;
                    boolean isStore = false;
                    int store = 0;
                    while ((ichar = reader.read()) > 0) {
                        if (ichar == 37) {
                            isComment = true;
                            continue;
                        }
                        if (ichar == 10 && isComment) {
                            isComment = false;
                            continue;
                        }
                        if (ichar == 41 && isText) {
                            isText = false;
                            continue;
                        }
                        if (isText && !isBMP) {
                            writer.write((char)ichar);
                            continue;
                        }
                        if (ichar == 40 && !isComment && !isBMP) {
                            isText = true;
                            continue;
                        }
                        if (isStore) {
                            if (store == 9 || ichar == 32 || ichar == 10) {
                                isStore = false;
                                store = 0;
                                if (stmt.toString().equals("BEGINBITM")) {
                                    isText = false;
                                    isBMP = true;
                                } else if (stmt.toString().equals("ENDBITMAP")) {
                                    isBMP = false;
                                }
                                stmt.delete(0, stmt.length());
                                continue;
                            }
                            stmt.append((char)ichar);
                            ++store;
                            continue;
                        }
                        if (isComment || isStore || ichar != 66 && ichar != 69) continue;
                        isStore = true;
                        stmt.append((char)ichar);
                        ++store;
                    }
                    break block33;
                }
                throw new Exception("Unsupported Postscript version '" + version2 + "'.");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void parseUsingPS2ascii(File inputFile, File outputFile) throws Exception {
        int execCode = 0;
        StringBuilder procErr = null;
        try {
            String procOutputLine;
            StringBuilder procOut = new StringBuilder();
            procErr = new StringBuilder();
            Process ps2asciiProc = Runtime.getRuntime().exec(new String[]{"ps2ascii", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()});
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(ps2asciiProc.getInputStream()));
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(ps2asciiProc.getErrorStream()));
            while ((procOutputLine = stdOut.readLine()) != null) {
                procOut.append(procOutputLine);
            }
            stdOut.close();
            while ((procOutputLine = stdErr.readLine()) != null) {
                procErr.append(procOutputLine);
            }
            stdErr.close();
            execCode = ps2asciiProc.waitFor();
        }
        catch (Exception e) {
            String errorMsg = "Unable to convert ps to ascii. " + e.getMessage();
            AbstractParser.log.severe(errorMsg);
            throw new Exception(errorMsg);
        }
        if (execCode != 0) {
            throw new Exception("Unable to convert ps to ascii. ps2ascii returned statuscode " + execCode + "\n" + procErr.toString());
        }
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        File tempFile = null;
        try {
            tempFile = FileUtils.createTempFile(this.getClass(), "temp.ps");
            FileUtils.copy(source, tempFile);
            Document[] documentArray = this.parse(location, mimeType, charset, tempFile);
            return documentArray;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unable to parse the ps file. " + e.getMessage(), location);
        }
        finally {
            if (tempFile != null) {
                FileUtils.deletedelete(tempFile);
            }
        }
    }
}

