/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.naming.SizeLimitExceededException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.StreamLimitException;
import net.yacy.cora.util.StrictLimitInputStream;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.xml.GenericXMLContentHandler;
import net.yacy.kelondro.io.CharBuffer;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryControl;
import org.apache.commons.io.input.XmlStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericXMLParser
extends AbstractParser
implements Parser {
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    public GenericXMLParser() {
        super("XML Parser");
        this.SUPPORTED_EXTENSIONS.add("xml");
        this.SUPPORTED_MIME_TYPES.add("application/xml");
        this.SUPPORTED_MIME_TYPES.add("text/xml");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure {
        long availableMemory = MemoryControl.available();
        long maxBytes = (long)((double)availableMemory * 0.25);
        int maxChars = maxBytes / 2L > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxBytes / 2;
        CharBuffer writer = new CharBuffer(maxChars);
        try {
            XmlStreamReader reader = new XmlStreamReader(source, mimeType, true, charset);
            InputSource saxSource = new InputSource((Reader)reader);
            String detectedCharset = reader.getEncoding();
            ArrayList<AnchorURL> detectedURLs = new ArrayList<AnchorURL>();
            GenericXMLContentHandler saxHandler = new GenericXMLContentHandler(writer, detectedURLs);
            SAXParser saxParser = GenericXMLParser.getParser();
            saxParser.parse(saxSource, (DefaultHandler)saxHandler);
            if (writer.isOverflow()) {
                throw new Parser.Failure("Not enough Memory available for generic the XML parser : " + Formatter.bytesToString(availableMemory), location);
            }
            Document[] docs = null;
            byte[] contentBytes = UTF8.getBytes(writer.toString());
            Document[] documentArray = docs = new Document[]{new Document(location, mimeType, detectedCharset, this, null, null, null, null, "", null, null, 0.0, 0.0, contentBytes, detectedURLs, null, null, false, new Date())};
            writer.close();
            return documentArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Parser.Failure e) {
                throw e;
            }
            catch (Exception e) {
                throw new Parser.Failure("Unexpected error while parsing XML file. " + e.getMessage(), location);
            }
        }
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charsetName, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws Parser.Failure, InterruptedException, UnsupportedOperationException {
        long availableMemory = MemoryControl.available();
        long maxTextBytes = (long)((double)availableMemory * 0.25);
        int maxChars = maxTextBytes / 2L > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxTextBytes / 2;
        CharBuffer writer = new CharBuffer(maxChars);
        try {
            HashSet<AnchorURL> detectedURLs = new HashSet<AnchorURL>();
            GenericXMLContentHandler saxHandler = new GenericXMLContentHandler(writer, detectedURLs, maxLinks);
            StrictLimitInputStream limitedSource = new StrictLimitInputStream(source, maxBytes);
            XmlStreamReader reader = new XmlStreamReader((InputStream)limitedSource, mimeType, true, charsetName);
            InputSource saxSource = new InputSource((Reader)reader);
            String detectedCharset = reader.getEncoding();
            SAXParser saxParser = GenericXMLParser.getParser();
            boolean limitExceeded = false;
            try {
                saxParser.parse(saxSource, (DefaultHandler)saxHandler);
            }
            catch (SAXException e) {
                if (!(e.getCause() instanceof SizeLimitExceededException)) {
                    throw e;
                }
                limitExceeded = true;
            }
            catch (StreamLimitException e) {
                limitExceeded = true;
            }
            if (writer.isOverflow()) {
                throw new Parser.Failure("Not enough Memory available for generic the XML parser : " + Formatter.bytesToString(availableMemory), location);
            }
            byte[] contentBytes = UTF8.getBytes(writer.toString());
            Document[] docs = new Document[]{new Document(location, mimeType, detectedCharset, this, null, null, null, null, "", null, null, 0.0, 0.0, contentBytes, detectedURLs, null, null, false, new Date())};
            docs[0].setPartiallyParsed(limitExceeded);
            Document[] documentArray = docs;
            writer.close();
            return documentArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new Parser.Failure("Unexpected error while parsing XML file. " + e.getMessage(), location);
            }
        }
    }
}

