/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.yacy.document.WordTokenizer;

public class SnippetExtractor {
    private String snippetString;
    private Set<String> remainingTerms;

    public SnippetExtractor(Iterable<StringBuilder> sentences, Set<String> queryTerms, int maxLength) throws UnsupportedOperationException {
        if (sentences == null) {
            throw new UnsupportedOperationException("sentences == null");
        }
        if (queryTerms == null || queryTerms.isEmpty()) {
            throw new UnsupportedOperationException("queryTerms == null");
        }
        TreeMap<Long, StringBuilder> order = new TreeMap<Long, StringBuilder>();
        long uniqCounter = 999L;
        int linenumber = 0;
        int fullmatchcounter = 0;
        for (StringBuilder sentence : sentences) {
            int worddistance;
            SortedMap<String, Integer> hs = WordTokenizer.tokenizeSentence(sentence.toString(), 100);
            TreeSet<Integer> positions = new TreeSet<Integer>();
            for (String word : queryTerms) {
                Integer pos = (Integer)hs.get(word);
                if (pos == null) continue;
                positions.add(pos);
            }
            int n = worddistance = positions.size() > 1 ? (Integer)positions.last() - (Integer)positions.first() : 0;
            if (!positions.isEmpty()) {
                order.put(-100000000L * (long)(linenumber == 0 ? 1 : 0) + 10000000L * (long)positions.size() + 1000000L * (long)worddistance + 100000L * (long)SnippetExtractor.linelengthKey(sentence.length(), maxLength) - 10000L * (long)linenumber + uniqCounter--, sentence);
                if (order.size() > 5) {
                    order.remove(order.firstEntry().getKey());
                }
                if (positions.size() == queryTerms.size()) {
                    ++fullmatchcounter;
                }
                if (fullmatchcounter >= 3) break;
            }
            ++linenumber;
        }
        while (!order.isEmpty()) {
            SnippetExtractor tsr;
            StringBuilder sentence = (StringBuilder)order.remove(order.lastKey());
            try {
                tsr = new SnippetExtractor(sentence.toString(), queryTerms, maxLength);
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            this.snippetString = tsr.snippetString;
            if (this.snippetString == null || this.snippetString.length() <= 0) continue;
            this.remainingTerms = tsr.remainingTerms;
            if (this.remainingTerms.isEmpty()) {
                return;
            }
            if (this.remainingTerms.size() >= queryTerms.size()) continue;
            if ((maxLength -= this.snippetString.length()) < 20) {
                maxLength = 20;
            }
            tsr = new SnippetExtractor(order.values(), this.remainingTerms, maxLength);
            String nextSnippet = tsr.snippetString;
            if (nextSnippet == null) {
                return;
            }
            this.snippetString = this.snippetString + " / " + nextSnippet;
            this.remainingTerms = tsr.remainingTerms;
            return;
        }
        throw new UnsupportedOperationException("no snippet computed");
    }

    private static int linelengthKey(int givenlength, int maxlength) {
        if (givenlength > maxlength) {
            return 1;
        }
        if (givenlength >= maxlength / 2 && givenlength < maxlength) {
            return 7;
        }
        if (givenlength >= maxlength / 4 && givenlength < maxlength / 2) {
            return 5;
        }
        if (givenlength >= maxlength / 8 && givenlength < maxlength / 4) {
            return 3;
        }
        return 0;
    }

    private SnippetExtractor(String sentence, Set<String> queryTerms, int maxLength) throws UnsupportedOperationException {
        try {
            if (sentence == null) {
                throw new UnsupportedOperationException("no sentence given");
            }
            if (queryTerms == null || queryTerms.isEmpty()) {
                throw new UnsupportedOperationException("queryTerms == null");
            }
            SortedMap<String, Integer> hs = WordTokenizer.tokenizeSentence((String)sentence, 100);
            Iterator<String> j = queryTerms.iterator();
            int minpos = ((String)sentence).length();
            int maxpos = -1;
            HashSet<String> remainingTerms = new HashSet<String>();
            while (j.hasNext()) {
                String term = j.next();
                Integer pos = (Integer)hs.get(term);
                if (pos == null) {
                    remainingTerms.add(term);
                    continue;
                }
                int p = pos;
                if (p > maxpos) {
                    maxpos = p;
                }
                if (p >= minpos) continue;
                minpos = p;
            }
            if ((maxpos += 10) > ((String)sentence).length()) {
                maxpos = ((String)sentence).length();
            }
            if (minpos < 0) {
                minpos = 0;
            }
            if (maxpos - minpos + 10 > maxLength) {
                int lenb = ((String)sentence).length();
                sentence = ((String)sentence).substring(0, minpos + 20 > ((String)sentence).length() ? ((String)sentence).length() : minpos + 20).trim() + " [..] " + ((String)sentence).substring(maxpos + 26 > ((String)sentence).length() ? ((String)sentence).length() : maxpos + 26).trim();
                maxpos = maxpos + lenb - ((String)sentence).length() + 6;
            } else if (maxpos > maxLength) {
                assert (maxpos >= minpos);
                int newlen = Math.max(10, maxpos - minpos + 10);
                assert (maxLength >= newlen) : "maxLength = " + maxLength + ", newlen = " + newlen;
                int around = (maxLength - newlen) / 2;
                assert (minpos - around < ((String)sentence).length()) : "maxpos = " + maxpos + ", minpos = " + minpos + ", around = " + around + ", sentence.length() = " + ((String)sentence).length() + ", maxLength = " + maxLength + ", newlen = " + newlen;
                sentence = "[..] " + ((String)sentence).substring(minpos - around, maxpos + around > ((String)sentence).length() ? ((String)sentence).length() : maxpos + around).trim() + " [..]";
                minpos = around;
                maxpos = ((String)sentence).length() - around - 5;
            }
            if (((String)sentence).length() > maxLength) {
                sentence = ((String)sentence).substring(0, Math.min(maxpos + 20, ((String)sentence).length())).trim() + " [..]";
            }
            if (((String)sentence).length() > maxLength) {
                sentence = "[..] " + ((String)sentence).substring(Math.max(minpos - 20, 0)).trim();
            }
            if (((String)sentence).length() > maxLength) {
                sentence = ((String)sentence).substring(6, 20).trim() + " [..] " + ((String)sentence).substring(((String)sentence).length() - 26, ((String)sentence).length() - 6).trim();
            }
            this.snippetString = sentence;
            this.remainingTerms = remainingTerms;
        }
        catch (IndexOutOfBoundsException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public String getSnippet() {
        return this.snippetString;
    }

    public Set<String> getRemainingTerms() {
        return this.remainingTerms;
    }
}

