/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import net.yacy.document.parser.html.CharacterCoding;

public class Diff {
    private final ArrayList<Part> parts = new ArrayList();
    protected final Object[] original;
    protected final Object[] changed;

    public Diff(String original, String changed) {
        this(original, changed, 1);
    }

    public Diff(String original, String changed, int minConsecutive) {
        int i;
        if (original == null || changed == null) {
            throw new NullPointerException("input Strings must be null");
        }
        this.original = (Object[])Array.newInstance(Comparable.class, original.length());
        for (i = 0; i < original.length(); ++i) {
            this.original[i] = Character.valueOf(original.charAt(i));
        }
        this.changed = (Object[])Array.newInstance(Comparable.class, changed.length());
        for (i = 0; i < changed.length(); ++i) {
            this.changed[i] = Character.valueOf(changed.charAt(i));
        }
        this.parse(minConsecutive > 0 ? minConsecutive : 1);
    }

    public Diff(Object[] original, Object[] changed, int minConsecutive) {
        if (original == null || changed == null) {
            throw new NullPointerException("input Objects must be null");
        }
        this.original = original;
        this.changed = changed;
        this.parse(minConsecutive > 0 ? minConsecutive : 1);
    }

    private void parse(int minLength) {
        int[] tmp;
        boolean[][] matrix = new boolean[this.changed.length][this.original.length];
        for (int y = 0; y < this.changed.length; ++y) {
            for (int x = 0; x < this.original.length; ++x) {
                matrix[y][x] = this.original[x].equals(this.changed[y]);
            }
        }
        int s = 0;
        int t = 0;
        while ((tmp = Diff.findDiagonal(s, t, matrix, minLength)) != null) {
            this.addReplacementParts(s, t, tmp[0], tmp[1]);
            s = tmp[0] + tmp[2];
            this.parts.add(new Part(0, tmp[0], s));
            t = tmp[1] + tmp[2];
        }
        this.addReplacementParts(s, t, this.original.length, this.changed.length);
    }

    private void addReplacementParts(int startx, int starty, int endx, int endy) {
        if (startx < endx) {
            this.parts.add(new Part(2, startx, endx));
        }
        if (starty < endy) {
            this.parts.add(new Part(1, starty, endy));
        }
    }

    private static int[] findDiagonal(int x, int y, boolean[][] matrix, int minLength) {
        for (int yy = y; yy < matrix.length; ++yy) {
            for (int xx = x; xx < matrix[yy].length; ++xx) {
                if (!matrix[yy][xx]) continue;
                int rx = xx;
                int ry = yy;
                int i = 1;
                while (yy + i < matrix.length && xx + i < matrix[yy].length && matrix[yy + i][xx + i]) {
                    ++i;
                }
                if (i < minLength) continue;
                return new int[]{rx, ry, i};
            }
        }
        return null;
    }

    public Object[] getOriginal() {
        return this.original;
    }

    public Object[] getNew() {
        return this.changed;
    }

    public Part[] getParts() {
        return this.parts.toArray(new Part[this.parts.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.parts.size() * 20);
        for (Part part : this.parts) {
            sb.append(part.toString()).append("\n");
        }
        return sb.toString();
    }

    public static String toHTML(Diff[] diffs) {
        StringBuilder sb = new StringBuilder(diffs.length * 60);
        for (Diff d : diffs) {
            Part[] ps;
            sb.append("<p class=\"diff\">\n");
            for (Part part : ps = d.getParts()) {
                sb.append("<span\nclass=\"");
                switch (part.getAction()) {
                    case 0: {
                        sb.append("unchanged");
                        break;
                    }
                    case 1: {
                        sb.append("added");
                        break;
                    }
                    case 2: {
                        sb.append("deleted");
                    }
                }
                sb.append("\">").append(CharacterCoding.unicode2html(part.getString(), true).replaceAll("\n", "<br />"));
                sb.append("</span>");
            }
            sb.append("</p>");
        }
        return sb.toString();
    }

    public class Part {
        public static final int UNCHANGED = 0;
        public static final int ADDED = 1;
        public static final int DELETED = 2;
        private final int action;
        private final int posOld;
        private final int posNew;

        Part(int action, int posOld, int posNew) {
            this.action = action;
            this.posOld = posOld;
            this.posNew = posNew;
        }

        public int getAction() {
            return this.action;
        }

        public int getPosOld() {
            return this.posOld;
        }

        public int getPosNew() {
            return this.posNew;
        }

        public String getString() {
            StringBuilder sb = new StringBuilder(this.posNew - this.posOld);
            if (this.action == 1) {
                for (int i = this.posOld; i < this.posNew; ++i) {
                    sb.append(Diff.this.changed[i]);
                }
            } else {
                for (int i = this.posOld; i < this.posNew; ++i) {
                    sb.append(Diff.this.original[i]);
                }
            }
            return sb.toString();
        }

        public String toString() {
            return (this.action == 0 ? " " : (this.action == 1 ? "+" : "-")) + " " + this.getString();
        }
    }
}

