/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.ListManager;
import net.yacy.data.wiki.WikiBoard;
import net.yacy.kelondro.blob.MapHeap;
import net.yacy.kelondro.util.kelondroException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BlogBoard {
    private static final int KEY_LENGTH = 64;
    private MapHeap database = null;

    public BlogBoard(File actpath) throws IOException {
        new File(actpath.getParent()).mkdir();
        this.database = new MapHeap(actpath, 64, NaturalOrder.naturalOrder, 65536, 500, '_');
    }

    public int size() {
        return this.database.size();
    }

    public boolean contains(String key) {
        return this.database.containsKey(UTF8.getBytes(key));
    }

    public synchronized void close() {
        this.database.close();
    }

    private static String normalize(String key) {
        return key == null ? "null" : key.trim().toLowerCase();
    }

    public static String webalize(String key) {
        return key == null ? "null" : key.trim().toLowerCase().replaceAll(" ", "%20");
    }

    public String guessAuthor(String ip) {
        return WikiBoard.guessAuthor(ip);
    }

    public BlogEntry newEntry(String key, byte[] subject, byte[] author, String ip, Date date, byte[] page, List<String> comments, String commentMode) {
        return new BlogEntry(BlogBoard.normalize(key), subject, author, ip, date, page, comments, commentMode);
    }

    public String writeBlogEntry(BlogEntry page) {
        String ret = null;
        try {
            this.database.insert(UTF8.getBytes(page.key), page.record);
            ret = page.key;
        }
        catch (IOException ex) {
            ConcurrentLog.logException(ex);
        }
        catch (SpaceExceededException ex) {
            ConcurrentLog.logException(ex);
        }
        return ret;
    }

    public BlogEntry readBlogEntry(String key) {
        return this.readBlogEntry(key, this.database);
    }

    private BlogEntry readBlogEntry(String key, MapHeap base) {
        Map<String, String> record;
        String normalized = BlogBoard.normalize(key);
        try {
            record = base.get(UTF8.getBytes(normalized.substring(0, Math.min(normalized.length(), 64))));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            record = null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            record = null;
        }
        return record == null ? this.newEntry(key, new byte[0], UTF8.getBytes("anonymous"), "localhost", new Date(), new byte[0], null, null) : new BlogEntry(key, record);
    }

    public boolean importXML(String input) {
        if (input != null && !input.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                return this.parseXMLimport(builder.parse(new ByteArrayInputStream(UTF8.getBytes(input))));
            }
            catch (ParserConfigurationException ex) {
                ConcurrentLog.logException(ex);
            }
            catch (SAXException ex) {
                ConcurrentLog.logException(ex);
            }
            catch (IOException ex) {
                ConcurrentLog.logException(ex);
            }
        }
        return false;
    }

    private boolean parseXMLimport(Document doc) {
        if (!"blog".equals(doc.getDocumentElement().getTagName())) {
            return false;
        }
        NodeList items = doc.getDocumentElement().getElementsByTagName("item");
        if (items.getLength() == 0) {
            return false;
        }
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            String key = null;
            String ip = null;
            String StrSubject = null;
            String StrAuthor = null;
            String StrPage = null;
            String StrDate = null;
            Date date = null;
            if (!"item".equals(items.item(i).getNodeName())) continue;
            NodeList currentNodeChildren = items.item(i).getChildNodes();
            int m = currentNodeChildren.getLength();
            for (int j = 0; j < m; ++j) {
                Node currentNode = currentNodeChildren.item(j);
                if ("id".equals(currentNode.getNodeName())) {
                    key = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("ip".equals(currentNode.getNodeName())) {
                    ip = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("timestamp".equals(currentNode.getNodeName())) {
                    StrDate = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("subject".equals(currentNode.getNodeName())) {
                    StrSubject = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if ("author".equals(currentNode.getNodeName())) {
                    StrAuthor = currentNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (!"content".equals(currentNode.getNodeName())) continue;
                StrPage = currentNode.getFirstChild().getNodeValue();
            }
            try {
                date = GenericFormatter.SHORT_SECOND_FORMATTER.parse(StrDate, 0).getTime();
            }
            catch (ParseException e1) {
                date = new Date();
            }
            if (key == null || ip == null || StrSubject == null || StrAuthor == null || StrPage == null || date == null) {
                return false;
            }
            byte[] subject = UTF8.getBytes(StrSubject);
            byte[] author = UTF8.getBytes(StrAuthor);
            byte[] page = UTF8.getBytes(StrPage);
            this.writeBlogEntry(this.newEntry(key, subject, author, ip, date, page, null, null));
        }
        return true;
    }

    public void deleteBlogEntry(String key) {
        try {
            this.database.delete(UTF8.getBytes(BlogBoard.normalize(key)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterator<byte[]> keys(boolean up) throws IOException {
        return this.database.keys(up, false);
    }

    public Iterator<String> getBlogIterator(boolean priv) {
        TreeSet<String> set = new TreeSet<String>(new BlogComparator(true));
        Iterator<BlogEntry> iterator = this.blogIterator(true);
        while (iterator.hasNext()) {
            BlogEntry blogEntry = iterator.next();
            if (!priv && !blogEntry.isPublic()) continue;
            set.add(blogEntry.getKey());
        }
        return set.iterator();
    }

    public Iterator<BlogEntry> blogIterator(boolean up) {
        try {
            return new BlogIterator(up);
        }
        catch (IOException e) {
            return new HashSet().iterator();
        }
    }

    public class BlogEntry {
        String key;
        Map<String, String> record;

        public BlogEntry(String nkey, byte[] subject, byte[] author, String ip, Date date, byte[] page, List<String> comments, String commentMode) {
            this.record = new HashMap<String, String>();
            this.setKey(nkey);
            this.setDate(date);
            this.setSubject(subject);
            this.setAuthor(author);
            this.setIp(ip);
            this.setPage(page);
            this.setComments(comments);
            this.setCommentMode(commentMode);
            this.record.put("privacy", "public");
            WikiBoard.setAuthor(ip, UTF8.String(author));
        }

        BlogEntry(String key, Map<String, String> record) {
            this.key = key;
            this.record = record;
            if (this.record.get("comments") == null) {
                this.record.put("comments", ListManager.collection2string(new ArrayList<String>()));
            }
            if (this.record.get("commentMode") == null || this.record.get("commentMode").length() < 1) {
                this.record.put("commentMode", "2");
            }
        }

        private void setKey(String key) {
            this.key = key.substring(0, Math.min(key.length(), 64));
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getSubject() {
            String m = this.record.get("subject");
            if (m == null) {
                return new byte[0];
            }
            byte[] b = Base64Order.enhancedCoder.decode(m);
            return b == null ? new byte[]{} : b;
        }

        private void setSubject(byte[] subject) {
            if (subject == null) {
                this.record.put("subject", "");
            } else {
                this.record.put("subject", Base64Order.enhancedCoder.encode(subject));
            }
        }

        public Date getDate() {
            try {
                String date = this.record.get("date");
                if (date == null) {
                    if (ConcurrentLog.isFinest("Blog")) {
                        ConcurrentLog.finest("Blog", "ERROR: date field missing in blogBoard");
                    }
                    return new Date();
                }
                return GenericFormatter.SHORT_SECOND_FORMATTER.parse(date, 0).getTime();
            }
            catch (ParseException ex) {
                return new Date();
            }
        }

        private void setDate(Date date) {
            Date ret = date;
            if (ret == null) {
                ret = new Date();
            }
            this.record.put("date", GenericFormatter.SHORT_SECOND_FORMATTER.format(ret));
        }

        public String getTimestamp() {
            String timestamp = this.record.get("date");
            if (timestamp == null) {
                if (ConcurrentLog.isFinest("Blog")) {
                    ConcurrentLog.finest("Blog", "ERROR: date field missing in blogBoard");
                }
                return GenericFormatter.SHORT_SECOND_FORMATTER.format();
            }
            return timestamp;
        }

        public byte[] getAuthor() {
            String author = this.record.get("author");
            if (author == null) {
                return new byte[0];
            }
            byte[] b = Base64Order.enhancedCoder.decode(author);
            return b == null ? new byte[]{} : b;
        }

        private void setAuthor(byte[] author) {
            if (author == null) {
                this.record.put("author", "");
            } else {
                this.record.put("author", Base64Order.enhancedCoder.encode(author));
            }
        }

        public int getCommentsSize() {
            if (this.record.get("comments").startsWith(",")) {
                this.record.put("comments", this.record.get("comments").substring(1));
                BlogBoard.this.writeBlogEntry(this);
            }
            ArrayList<String> commentsize = ListManager.string2arraylist(this.record.get("comments"));
            return commentsize.size();
        }

        public List<String> getComments() {
            return ListManager.string2arraylist(this.record.get("comments"));
        }

        private void setComments(List<String> comments) {
            if (comments == null) {
                this.record.put("comments", ListManager.collection2string(new ArrayList<String>()));
            } else {
                this.record.put("comments", ListManager.collection2string(comments));
            }
        }

        public String getIp() {
            String ip = this.record.get("ip");
            return ip == null ? "localhost" : ip;
        }

        private void setIp(String ip) {
            String ret = ip;
            if (ret == null || ret.isEmpty()) {
                ret = "";
            }
            this.record.put("ip", ret);
        }

        public byte[] getPage() {
            String page = this.record.get("page");
            if (page == null) {
                return new byte[0];
            }
            byte[] page_as_byte = Base64Order.enhancedCoder.decode(page);
            return page_as_byte == null ? new byte[]{} : page_as_byte;
        }

        private void setPage(byte[] page) {
            if (page == null) {
                this.record.put("page", "");
            } else {
                this.record.put("page", Base64Order.enhancedCoder.encode(page));
            }
        }

        public void addComment(String commentID) {
            ArrayList<String> comments = ListManager.string2arraylist(this.record.get("comments"));
            comments.add(commentID);
            this.record.put("comments", ListManager.collection2string(comments));
        }

        public boolean removeComment(String commentID) {
            ArrayList<String> comments = ListManager.string2arraylist(this.record.get("comments"));
            boolean success = comments.remove(commentID);
            this.record.put("comments", ListManager.collection2string(comments));
            return success;
        }

        public int getCommentMode() {
            return Integer.parseInt(this.record.get("commentMode"));
        }

        private void setCommentMode(String mode) {
            if (mode == null) {
                this.record.put("commentMode", "2");
            } else {
                this.record.put("commentMode", mode);
            }
        }

        public boolean isPublic() {
            String privacy = this.record.get("privacy");
            return privacy == null || privacy.equalsIgnoreCase("public");
        }
    }

    public class BlogComparator
    implements Comparator<String> {
        private final boolean newestFirst;

        public BlogComparator(boolean newestFirst) {
            this.newestFirst = newestFirst;
        }

        @Override
        public int compare(String obj1, String obj2) {
            BlogEntry blogEntry1 = BlogBoard.this.readBlogEntry(obj1);
            BlogEntry blogEntry2 = BlogBoard.this.readBlogEntry(obj2);
            if (blogEntry1 == null || blogEntry2 == null) {
                return 0;
            }
            if (this.newestFirst) {
                if (Long.parseLong(blogEntry2.getTimestamp()) - Long.parseLong(blogEntry1.getTimestamp()) > 0L) {
                    return 1;
                }
                return -1;
            }
            if (Long.parseLong(blogEntry1.getTimestamp()) - Long.parseLong(blogEntry2.getTimestamp()) > 0L) {
                return 1;
            }
            return -1;
        }
    }

    public class BlogIterator
    implements Iterator<BlogEntry> {
        Iterator<byte[]> blogIter;

        public BlogIterator(boolean up) throws IOException {
            this.blogIter = BlogBoard.this.database.keys(up, false);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.blogIter.hasNext();
            }
            catch (kelondroException e) {
                return false;
            }
        }

        @Override
        public BlogEntry next() {
            try {
                return BlogBoard.this.readBlogEntry(UTF8.String(this.blogIter.next()));
            }
            catch (kelondroException e) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method not implemented yet.");
        }
    }
}

