/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.responsewriter.EnhancedXMLResponseWriter;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Html2Image;
import net.yacy.crawler.data.Snapshots;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.SolrInputDocument;

public class Transactions {
    private static final String XML_PREFIX = "<response>\n<!--\n";
    private static final char[] WHITESPACE = new char[132];
    private static File transactionDir = null;
    private static File inventoryDir = null;
    private static File archiveDir = null;
    private static Snapshots inventory = null;
    private static Snapshots archive = null;
    private static ExecutorService executor = Executors.newCachedThreadPool();
    private static AtomicInteger executorRunning = new AtomicInteger(0);
    private static long wkhtmltopdfTimeout = 30L;

    public static void init(File dir, long wkhtmltopdfSecondsTimeout) {
        transactionDir = dir;
        transactionDir.mkdirs();
        inventoryDir = new File(transactionDir, State.INVENTORY.dirname);
        inventory = new Snapshots(inventoryDir);
        archiveDir = new File(transactionDir, State.ARCHIVE.dirname);
        archive = new Snapshots(archiveDir);
        wkhtmltopdfTimeout = wkhtmltopdfSecondsTimeout;
    }

    public static synchronized void migrateIPV6Snapshots() {
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static Map<String, Integer> sizes() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put(State.INVENTORY.name(), inventory.size());
        m.put(State.ARCHIVE.name(), archive.size());
        return m;
    }

    public static Snapshots.Revisions getRevisions(State state, String urlhash) {
        switch (state) {
            case INVENTORY: {
                return inventory.getRevisions(urlhash);
            }
            case ARCHIVE: {
                return archive.getRevisions(urlhash);
            }
        }
        Snapshots.Revisions a = inventory.getRevisions(urlhash);
        return a == null ? archive.getRevisions(urlhash) : a;
    }

    public static Set<String> listHosts(State state) {
        switch (state) {
            case INVENTORY: {
                return inventory.listHosts();
            }
            case ARCHIVE: {
                return archive.listHosts();
            }
        }
        Set<String> a = inventory.listHosts();
        a.addAll(archive.listHosts());
        return a;
    }

    public static TreeMap<Integer, Collection<Snapshots.Revisions>> listIDs(String hostport, int depth, State state) {
        switch (state) {
            case INVENTORY: {
                return inventory.listIDs(hostport, depth);
            }
            case ARCHIVE: {
                return archive.listIDs(hostport, depth);
            }
        }
        TreeMap<Integer, Collection<Snapshots.Revisions>> a = inventory.listIDs(hostport, depth);
        a.putAll(archive.listIDs(hostport, depth));
        return a;
    }

    public static int listIDsSize(String hostport, int depth, State state) {
        switch (state) {
            case INVENTORY: {
                return inventory.listIDsSize(hostport, depth);
            }
            case ARCHIVE: {
                return archive.listIDsSize(hostport, depth);
            }
        }
        return inventory.listIDsSize(hostport, depth) + archive.listIDsSize(hostport, depth);
    }

    public static boolean store(SolrInputDocument doc, boolean concurrency, boolean loadImage, boolean replaceOld, String proxy, String acceptLanguage) {
        boolean success;
        DigestURL url;
        String urls2 = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
        Date date = (Date)doc.getFieldValue(CollectionSchema.load_date_dt.getSolrFieldName());
        Integer o_depth = (Integer)doc.getFieldValue(CollectionSchema.crawldepth_i.getSolrFieldName());
        int depth = o_depth == null ? 0 : o_depth;
        try {
            url = new DigestURL(urls2);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
            return false;
        }
        boolean bl = success = loadImage ? Transactions.store(url, date, depth, concurrency, replaceOld, proxy, acceptLanguage) : true;
        if (success) {
            File metadataPath = Transactions.definePath(url, depth, date, "xml", State.INVENTORY);
            metadataPath.getParentFile().mkdirs();
            if (doc != null) {
                try (FileOutputStream fos = new FileOutputStream(metadataPath);
                     OutputStreamWriter osw = new OutputStreamWriter(fos);){
                    osw.write(XML_PREFIX);
                    osw.write(WHITESPACE);
                    osw.write("\n-->\n");
                    osw.write("<result name=\"response\" numFound=\"1\" start=\"0\">\n");
                    EnhancedXMLResponseWriter.writeDoc((Writer)osw, doc);
                    osw.write("</result>\n");
                    osw.write("</response>\n");
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    success = false;
                }
                if (success) {
                    Transactions.announceStorage(url, depth, date, State.INVENTORY);
                }
            }
        }
        return success;
    }

    public static boolean store(DigestURL url, Date date, int depth, boolean concurrency, boolean replaceOld, final String proxy, final String acceptLanguage) {
        Collection<File> oldPaths = Transactions.findPaths(url, depth, null, State.INVENTORY);
        if (replaceOld && oldPaths != null) {
            for (File oldPath : oldPaths) {
                oldPath.delete();
            }
        }
        File metadataPath = Transactions.definePath(url, depth, date, "xml", State.INVENTORY);
        metadataPath.getParentFile().mkdirs();
        boolean success = true;
        final String urls2 = url.toNormalform(true);
        final File pdfPath = Transactions.definePath(url, depth, date, "pdf", State.INVENTORY);
        if (concurrency && executorRunning.intValue() < Runtime.getRuntime().availableProcessors()) {
            Thread t = new Thread("Transactions.store"){

                @Override
                public void run() {
                    executorRunning.incrementAndGet();
                    try {
                        Html2Image.writeWkhtmltopdf(urls2, proxy, ClientIdentification.browserAgent.userAgent, acceptLanguage, pdfPath, wkhtmltopdfTimeout);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        executorRunning.decrementAndGet();
                    }
                }
            };
            executor.execute(t);
        } else {
            success = Html2Image.writeWkhtmltopdf(urls2, proxy, ClientIdentification.browserAgent.userAgent, acceptLanguage, pdfPath, wkhtmltopdfTimeout);
        }
        return success;
    }

    public static Snapshots.Revisions commit(String urlhash) {
        return Transactions.transact(urlhash, State.INVENTORY, State.ARCHIVE);
    }

    public static Snapshots.Revisions rollback(String urlhash) {
        return Transactions.transact(urlhash, State.ARCHIVE, State.INVENTORY);
    }

    private static Snapshots.Revisions transact(String urlhash, State from, State to) {
        Snapshots.Revisions r = Transactions.getRevisions(from, urlhash);
        if (r == null) {
            return null;
        }
        for (File f : r.pathtoxml) {
            String name = f.getName();
            String nameStub = name.substring(0, name.length() - 4);
            File sourceParent = f.getParentFile();
            File targetParent = new File(sourceParent.getAbsolutePath().replace("/" + from.dirname + "/", "/" + to.dirname + "/"));
            targetParent.mkdirs();
            for (String a : sourceParent.list()) {
                if (!a.startsWith(nameStub)) continue;
                new File(sourceParent, a).renameTo(new File(targetParent, a));
            }
            while (sourceParent.list().length == 0) {
                sourceParent.delete();
                sourceParent = sourceParent.getParentFile();
            }
        }
        try {
            DigestURL durl = new DigestURL(r.url);
            Transactions.announceDeletion(durl, r.depth, from);
            Transactions.announceStorage(durl, r.depth, r.dates[0], to);
            return r;
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public static LinkedHashMap<String, Snapshots.Revisions> select(String host, Integer depth, Snapshots.Order order, int maxcount, State state) {
        LinkedHashMap<String, Snapshots.Revisions> result = new LinkedHashMap<String, Snapshots.Revisions>();
        if (state == State.INVENTORY || state == State.ANY) {
            result.putAll(inventory.select(host, depth, order, maxcount));
        }
        if (state == State.ARCHIVE || state == State.ANY) {
            result.putAll(archive.select(host, depth, order, maxcount));
        }
        return result;
    }

    public static File definePath(DigestURL url, int depth, Date date, String ext, State state) {
        if (state == State.ANY) {
            throw new RuntimeException("definePath must be selected with INVENTORY or ARCHIVE state");
        }
        if (state == State.INVENTORY) {
            return inventory.definePath(url, depth, date, ext);
        }
        if (state == State.ARCHIVE) {
            return archive.definePath(url, depth, date, ext);
        }
        return null;
    }

    public static void announceStorage(DigestURL url, int depth, Date date, State state) {
        if (state == State.INVENTORY || state == State.ANY) {
            inventory.announceStorage(url, depth, date);
        }
        if (state == State.ARCHIVE || state == State.ANY) {
            archive.announceStorage(url, depth, date);
        }
    }

    public static void announceDeletion(DigestURL url, int depth, State state) {
        if (state == State.INVENTORY || state == State.ANY) {
            inventory.announceDeletion(url, depth);
        }
        if (state == State.ARCHIVE || state == State.ANY) {
            archive.announceDeletion(url, depth);
        }
    }

    public static Collection<File> findPaths(DigestURL url, String ext, State state) {
        ArrayList<File> result = new ArrayList<File>();
        if (state == State.INVENTORY || state == State.ANY) {
            result.addAll(inventory.findPaths(url, ext));
        }
        if (state == State.ARCHIVE || state == State.ANY) {
            result.addAll(archive.findPaths(url, ext));
        }
        return result;
    }

    public static Collection<File> findPaths(DigestURL url, int depth, String ext, State state) {
        ArrayList<File> result = new ArrayList<File>();
        if (state == State.INVENTORY || state == State.ANY) {
            result.addAll(inventory.findPaths(url, depth, ext));
        }
        if (state == State.ARCHIVE || state == State.ANY) {
            result.addAll(archive.findPaths(url, depth, ext));
        }
        return result;
    }

    static {
        for (int i = 0; i < WHITESPACE.length; ++i) {
            Transactions.WHITESPACE[i] = 32;
        }
    }

    public static enum State {
        INVENTORY("inventory"),
        ARCHIVE("archive"),
        ANY(null);

        public String dirname;

        private State(String dirname) {
            this.dirname = dirname;
        }
    }
}

