/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.HarvestProcess;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.NoticedURL;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.robots.RobotsTxtEntry;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.IndexingQueueEntry;
import net.yacy.search.Switchboard;
import net.yacy.search.index.ErrorCache;
import net.yacy.search.index.ErrorCacheFiller;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;

public class CrawlQueues {
    private static final Request POISON_REQUEST = new Request();
    private static final ConcurrentLog log = new ConcurrentLog("CRAWLER");
    private final Switchboard sb;
    private final Loader[] worker;
    private final ArrayBlockingQueue<Request> workerQueue;
    private ArrayList<String> remoteCrawlProviderHashes;
    public NoticedURL noticeURL;
    public ErrorCache errorURL;
    public Map<String, DigestURL> delegatedURL;

    public CrawlQueues(Switchboard sb, File queuePath) {
        this.sb = sb;
        int maxWorkers = (int)sb.getConfigLong("crawler.MaxActiveThreads", 10L);
        this.worker = new Loader[maxWorkers];
        this.workerQueue = new ArrayBlockingQueue(maxWorkers);
        this.remoteCrawlProviderHashes = null;
        log.config("Starting Crawling Management");
        log.config("Opening noticeURL..");
        this.noticeURL = new NoticedURL(queuePath, sb.getConfigInt("crawler.onDemandLimit", 1000), sb.exceed134217727);
        log.config("Opening errorURL..");
        this.errorURL = new ErrorCache(sb);
        log.config("Opening delegatedURL..");
        this.delegatedURL = null;
    }

    public void initRemoteCrawlQueues() {
        if (this.remoteCrawlProviderHashes == null) {
            this.remoteCrawlProviderHashes = new ArrayList();
        }
        if (this.delegatedURL == null) {
            this.delegatedURL = new ConcurrentHashMap<String, DigestURL>();
            log.config("Finished Startup of Crawling Management");
        }
    }

    public void relocate(File newQueuePath) {
        this.workerQueue.clear();
        this.errorURL.clearCache();
        new ErrorCacheFiller(this.sb, this.errorURL).start();
        if (this.remoteCrawlProviderHashes != null) {
            this.remoteCrawlProviderHashes.clear();
        }
        this.noticeURL.close();
        this.noticeURL = new NoticedURL(newQueuePath, this.sb.getConfigInt("crawler.onDemandLimit", 1000), this.sb.exceed134217727);
        if (this.delegatedURL != null) {
            this.delegatedURL.clear();
        }
    }

    public synchronized void close() {
        this.noticeURL.close();
        this.workerQueue.clear();
        for (int i = 0; i < this.workerQueue.remainingCapacity(); ++i) {
            try {
                this.workerQueue.offer(POISON_REQUEST, 1L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while adding POISON_REQUEST to the workerQueue");
            }
        }
        for (Loader w : this.worker) {
            if (w == null || !w.isAlive()) continue;
            try {
                w.join(1000L);
                if (!w.isAlive()) continue;
                w.interrupt();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for worker termination.");
            }
        }
        if (this.delegatedURL != null) {
            this.delegatedURL.clear();
        }
    }

    public void clear() {
        this.workerQueue.clear();
        for (Loader w : this.worker) {
            if (w == null) continue;
            w.interrupt();
        }
        if (this.remoteCrawlProviderHashes != null) {
            this.remoteCrawlProviderHashes.clear();
        }
        this.noticeURL.clear();
        if (this.delegatedURL != null) {
            this.delegatedURL.clear();
        }
    }

    public HarvestProcess exists(byte[] hash) {
        if (this.delegatedURL != null && this.delegatedURL.containsKey(ASCII.String(hash))) {
            return HarvestProcess.DELEGATED;
        }
        for (Request request : this.activeWorkerEntries().values()) {
            if (!Base64Order.enhancedCoder.equal(request.url().hash(), hash)) continue;
            return HarvestProcess.WORKER;
        }
        return null;
    }

    public int hostcount(String host) {
        if (host == null || host.length() == 0) {
            return 0;
        }
        int c = 0;
        for (DigestURL url : this.activeWorkerEntries().keySet()) {
            if (!host.equals(url.getHost())) continue;
            ++c;
        }
        return c;
    }

    public void removeURL(byte[] hash) {
        assert (hash != null && hash.length == 12);
        this.noticeURL.removeByURLHash(hash);
        if (this.delegatedURL != null) {
            this.delegatedURL.remove(ASCII.String(hash));
        }
    }

    public int removeHosts(Set<String> hosthashes) {
        return this.noticeURL.removeByHostHash(hosthashes);
    }

    public DigestURL getURL(byte[] urlhash) {
        Object u;
        assert (urlhash != null);
        if (urlhash == null || urlhash.length == 0) {
            return null;
        }
        if (this.delegatedURL != null && (u = this.delegatedURL.get(ASCII.String(urlhash))) != null) {
            return u;
        }
        for (DigestURL url : this.activeWorkerEntries().keySet()) {
            if (!Base64Order.enhancedCoder.equal(url.hash(), urlhash)) continue;
            return url;
        }
        Request ne = this.noticeURL.get(urlhash);
        if (ne != null) {
            return ne.url();
        }
        return null;
    }

    public void freemem() {
        if (this.errorURL.stackSize() > 1) {
            log.warn("freemem: Cleaning Error-URLs report stack, " + this.errorURL.stackSize() + " entries on stack");
            this.errorURL.clearStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DigestURL, Request> activeWorkerEntries() {
        Loader[] loaderArray = this.worker;
        synchronized (this.worker) {
            HashMap<DigestURL, Request> map = new HashMap<DigestURL, Request>();
            for (Loader w : this.worker) {
                Request r;
                if (w == null || (r = w.loading()) == null) continue;
                map.put(r.url(), r);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    public int coreCrawlJobSize() {
        return this.noticeURL.stackSize(NoticedURL.StackType.LOCAL) + this.noticeURL.stackSize(NoticedURL.StackType.NOLOAD);
    }

    public boolean coreCrawlJob() {
        boolean robinsonPrivateCase;
        boolean bl = robinsonPrivateCase = this.sb.isRobinsonMode() && !this.sb.getConfig("cluster.mode", "").equals("publiccluster");
        if ((robinsonPrivateCase || this.coreCrawlJobSize() <= 20) && this.limitCrawlJobSize() > 0) {
            int toshift = Math.min(10, this.limitCrawlJobSize());
            for (int i = 0; i < toshift; ++i) {
                this.noticeURL.shift(NoticedURL.StackType.GLOBAL, NoticedURL.StackType.LOCAL, this.sb.crawler, this.sb.robots);
            }
            log.info("shifted " + toshift + " jobs from global crawl to local crawl (coreCrawlJobSize()=" + this.coreCrawlJobSize() + ", limitCrawlJobSize()=" + this.limitCrawlJobSize() + ", cluster.mode=" + this.sb.getConfig("cluster.mode", "") + ", robinsonMode=" + (this.sb.isRobinsonMode() ? "on" : "off"));
        }
        String queueCheckCore = this.loadIsPossible(NoticedURL.StackType.LOCAL);
        String queueCheckNoload = this.loadIsPossible(NoticedURL.StackType.NOLOAD);
        if (queueCheckCore != null && queueCheckNoload != null) {
            if (log.isFine()) {
                log.fine("omitting de-queue/local: " + queueCheckCore + ":" + queueCheckNoload);
            }
            return false;
        }
        if (this.isPaused("50_localcrawl")) {
            if (log.isFine()) {
                log.fine("omitting de-queue/local: paused");
            }
            return false;
        }
        while (!this.noticeURL.isEmpty(NoticedURL.StackType.LOCAL) || !this.noticeURL.isEmpty(NoticedURL.StackType.NOLOAD)) {
            String stats = "LOCALCRAWL[" + this.noticeURL.stackSize(NoticedURL.StackType.NOLOAD) + ", " + this.noticeURL.stackSize(NoticedURL.StackType.LOCAL) + ", " + this.noticeURL.stackSize(NoticedURL.StackType.GLOBAL) + ", " + this.noticeURL.stackSize(NoticedURL.StackType.REMOTE) + "]";
            try {
                Request urlEntry;
                if (!this.noticeURL.isEmpty(NoticedURL.StackType.NOLOAD)) {
                    urlEntry = this.noticeURL.pop(NoticedURL.StackType.NOLOAD, true, this.sb.crawler, this.sb.robots);
                    if (urlEntry == null) continue;
                    String profileHandle = urlEntry.profileHandle();
                    if (profileHandle == null) {
                        log.severe(stats + ": NULL PROFILE HANDLE '" + urlEntry.profileHandle() + "' for URL " + urlEntry.url());
                        return true;
                    }
                    CrawlProfile profile2 = this.sb.crawler.get(ASCII.getBytes(profileHandle));
                    if (profile2 == null) {
                        log.severe(stats + ": NULL PROFILE HANDLE '" + urlEntry.profileHandle() + "' for URL " + urlEntry.url());
                        return true;
                    }
                    this.sb.indexingDocumentProcessor.enQueue(new IndexingQueueEntry(new Response(urlEntry, profile2), null, null));
                    ConcurrentLog.info("CrawlQueues", "placed NOLOAD URL on indexing queue: " + urlEntry.url().toNormalform(true));
                    return true;
                }
                urlEntry = this.noticeURL.pop(NoticedURL.StackType.LOCAL, true, this.sb.crawler, this.sb.robots);
                if (urlEntry == null) continue;
                if (urlEntry.profileHandle() == null) {
                    log.severe(stats + ": NULL PROFILE HANDLE '" + urlEntry.profileHandle() + "' for URL " + urlEntry.url());
                    return true;
                }
                this.load(urlEntry, stats);
                return true;
            }
            catch (IOException e) {
                log.severe(stats + ": CANNOT FETCH ENTRY: " + e.getMessage(), e);
                if (e.getMessage() == null || e.getMessage().indexOf("hash is null", 0) <= 0) continue;
                this.noticeURL.clear(NoticedURL.StackType.LOCAL);
            }
        }
        return true;
    }

    private void load(Request urlEntry, String stats) {
        CrawlProfile profile2 = this.sb.crawler.get(UTF8.getBytes(urlEntry.profileHandle()));
        if (profile2 != null) {
            DigestURL url = urlEntry.url();
            String urlProtocol = url.getProtocol();
            if (this.sb.loader.isSupportedProtocol(urlProtocol)) {
                if (log.isFine()) {
                    log.fine(stats + ": URL=" + urlEntry.url() + ", initiator=" + (urlEntry.initiator() == null ? "" : ASCII.String(urlEntry.initiator())) + ", crawlOrder=" + (profile2.remoteIndexing() ? "true" : "false") + ", depth=" + urlEntry.depth() + ", crawlDepth=" + profile2.depth() + ", must-match=" + profile2.formattedUrlMustMatchPattern() + ", must-not-match=" + profile2.urlMustNotMatchPattern().toString() + ", permission=" + (this.sb.peers == null ? "undefined" : (this.sb.peers.mySeed().isSenior() || this.sb.peers.mySeed().isPrincipal() ? "true" : "false")));
                }
                if (urlEntry == null || urlEntry.url() == null) {
                    log.info(stats + ": urlEntry = null");
                } else if (!this.activeWorkerEntries().containsKey(urlEntry.url())) {
                    try {
                        this.ensureLoaderRunning();
                        this.workerQueue.put(urlEntry);
                    }
                    catch (InterruptedException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            } else {
                log.severe("Unsupported protocol in URL '" + url.toNormalform(false));
            }
        } else if (log.isFine()) {
            log.fine(stats + ": LOST PROFILE HANDLE '" + urlEntry.profileHandle() + "' for URL " + urlEntry.url());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPaused(String crawljob) {
        Object[] status = this.sb.crawlJobsStatus.get(crawljob);
        boolean pauseEnded = false;
        Object object = status[0];
        synchronized (object) {
            if (((Boolean)status[1]).booleanValue()) {
                try {
                    status[0].wait();
                }
                catch (InterruptedException e) {
                    pauseEnded = true;
                }
            }
        }
        return pauseEnded;
    }

    private String loadIsPossible(NoticedURL.StackType stackType) {
        if (this.noticeURL.isEmpty(stackType)) {
            return "stack is empty";
        }
        if (this.workerQueue.remainingCapacity() == 0) {
            return "too many workers active: " + this.workerQueue.size();
        }
        String cautionCause = this.sb.onlineCaution();
        if (cautionCause != null) {
            return "online caution: " + cautionCause;
        }
        return null;
    }

    public boolean remoteCrawlLoaderJob() {
        Seed seed;
        if (!this.sb.peers.mySeed().getFlagAcceptRemoteCrawl()) {
            return false;
        }
        if (!this.sb.peers.mySeed().isActive()) {
            return false;
        }
        if (this.workerQueue.remainingCapacity() == 0) {
            if (log.isFine()) {
                log.fine("remoteCrawlLoaderJob: too many processes in loader queue, dismissed (workerQueue=" + this.workerQueue.size() + "), httpClients = " + ConnectionInfo.getCount());
            }
            return false;
        }
        String cautionCause = this.sb.onlineCaution();
        if (cautionCause != null) {
            if (log.isFine()) {
                log.fine("remoteCrawlLoaderJob: online caution for " + cautionCause + ", omitting processing");
            }
            return false;
        }
        if (this.remoteTriggeredCrawlJobSize() > 200) {
            if (log.isFine()) {
                log.fine("remoteCrawlLoaderJob: the remote-triggered crawl job queue is filled, omitting processing");
            }
            return false;
        }
        if (this.coreCrawlJobSize() > 0) {
            if (log.isFine()) {
                log.fine("remoteCrawlLoaderJob: a local crawl is running, omitting processing");
            }
            return false;
        }
        if (this.remoteCrawlProviderHashes != null && this.remoteCrawlProviderHashes.isEmpty() && this.sb.peers != null && this.sb.peers.sizeConnected() > 0) {
            Iterator<Seed> e = DHTSelection.getProvidesRemoteCrawlURLs(this.sb.peers);
            while (e.hasNext()) {
                seed = e.next();
                if (seed == null) continue;
                this.remoteCrawlProviderHashes.add(seed.hash);
            }
        }
        if (this.remoteCrawlProviderHashes == null || this.remoteCrawlProviderHashes.isEmpty()) {
            return false;
        }
        seed = null;
        String hash = null;
        while (seed == null && this.remoteCrawlProviderHashes != null && !this.remoteCrawlProviderHashes.isEmpty()) {
            hash = this.remoteCrawlProviderHashes.remove(this.remoteCrawlProviderHashes.size() - 1);
            if (hash == null || (seed = this.sb.peers.get(hash)) == null || !this.sb.isRobinsonMode() || this.sb.isInMyCluster(seed)) continue;
            seed = null;
        }
        if (seed == null) {
            return false;
        }
        boolean preferHttps = this.sb.getConfigBool("network.unit.protocol.https.preferred", false);
        RSSFeed feed2 = Protocol.queryRemoteCrawlURLs(this.sb.peers, seed, 60, 10000L, preferHttps);
        if (feed2 == null || feed2.isEmpty()) {
            return this.remoteCrawlLoaderJob();
        }
        for (Hit item : feed2) {
            DigestURL referrer;
            DigestURL url;
            try {
                url = new DigestURL(item.getLink());
            }
            catch (MalformedURLException e) {
                continue;
            }
            try {
                referrer = new DigestURL(item.getReferrer());
            }
            catch (MalformedURLException e) {
                referrer = null;
            }
            Date loaddate = item.getPubDate();
            String urlRejectReason = this.sb.crawlStacker.urlInAcceptedDomain(url);
            if (urlRejectReason == null) {
                if (this.sb.getLog().isFinest()) {
                    this.sb.getLog().finest("crawlOrder: stack: url='" + url + "'");
                }
                this.sb.crawlStacker.enqueueEntry(new Request(ASCII.getBytes(hash), url, referrer == null ? null : referrer.hash(), item.getDescriptions().size() > 0 ? item.getDescriptions().get(0) : "", loaddate, this.sb.crawler.defaultRemoteProfile.handle(), 0, this.sb.crawler.defaultRemoteProfile.timezoneOffset()));
                continue;
            }
            log.warn("crawlOrder: Rejected URL '" + CrawlQueues.urlToString(url) + "': " + urlRejectReason);
        }
        return true;
    }

    public boolean autocrawlJob() {
        if (!this.sb.getConfigBool("autocrawl", false)) {
            return false;
        }
        if (this.isPaused("50_localcrawl")) {
            return false;
        }
        if (this.coreCrawlJobSize() > 200) {
            return false;
        }
        String rows = this.sb.getConfig("autocrawl.rows", "100");
        String dateQuery = String.format("load_date_dt:[* TO NOW-%sDAY]", this.sb.getConfig("autocrawl.days", "1"));
        SolrQuery query2 = new SolrQuery();
        query2.add("group", new String[]{"true"});
        query2.add("group.field", new String[]{"host_s"});
        query2.add("group.limit", new String[]{"1"});
        query2.add("group.main", new String[]{"true"});
        query2.add("rows", new String[]{rows});
        query2.setQuery(this.sb.getConfig("autocrawl.query", "*:*"));
        query2.setFields(new String[]{"host_s,url_protocol_s"});
        query2.addSort("load_date_dt", SolrQuery.ORDER.asc);
        query2.addFilterQuery(new String[]{dateQuery});
        try {
            QueryResponse resp = this.sb.index.fulltext().getDefaultConnector().getResponseByParams((ModifiableSolrParams)query2);
            int i = 0;
            int deepRatio = Integer.parseInt(this.sb.getConfig("autocrawl.ratio", "50"));
            for (SolrDocument doc : resp.getResults()) {
                DigestURL url;
                boolean deep = false;
                if (++i % deepRatio == 0) {
                    deep = true;
                }
                String u = doc.getFieldValue("url_protocol_s").toString() + "://" + doc.getFieldValue("host_s").toString();
                try {
                    url = new DigestURL(u);
                }
                catch (MalformedURLException e) {
                    continue;
                }
                String urlRejectReason = this.sb.crawlStacker.urlInAcceptedDomain(url);
                if (urlRejectReason == null) {
                    this.sb.crawlStacker.enqueueEntry(new Request(ASCII.getBytes(this.sb.peers.mySeed().hash), url, null, "CRAWLING-ROOT", new Date(), deep ? this.sb.crawler.defaultAutocrawlDeepProfile.handle() : this.sb.crawler.defaultAutocrawlShallowProfile.handle(), 0, deep ? this.sb.crawler.defaultAutocrawlDeepProfile.timezoneOffset() : this.sb.crawler.defaultAutocrawlShallowProfile.timezoneOffset()));
                    continue;
                }
                log.warn("autocrawl: Rejected URL '" + CrawlQueues.urlToString(url) + "': " + urlRejectReason);
            }
        }
        catch (SolrException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static String urlToString(DigestURL url) {
        return url == null ? "null" : url.toNormalform(true);
    }

    public int limitCrawlJobSize() {
        return this.noticeURL.stackSize(NoticedURL.StackType.GLOBAL);
    }

    public int noloadCrawlJobSize() {
        return this.noticeURL.stackSize(NoticedURL.StackType.NOLOAD);
    }

    public int remoteTriggeredCrawlJobSize() {
        return this.noticeURL.stackSize(NoticedURL.StackType.REMOTE);
    }

    public boolean remoteTriggeredCrawlJob() {
        String queueCheck = this.loadIsPossible(NoticedURL.StackType.REMOTE);
        if (queueCheck != null) {
            if (log.isFinest()) {
                log.finest("omitting de-queue/remote: " + queueCheck);
            }
            return false;
        }
        if (this.isPaused("62_remotetriggeredcrawl")) {
            if (log.isFinest()) {
                log.finest("omitting de-queue/remote: paused");
            }
            return false;
        }
        String stats = "REMOTETRIGGEREDCRAWL[" + this.noticeURL.stackSize(NoticedURL.StackType.LOCAL) + ", " + this.noticeURL.stackSize(NoticedURL.StackType.GLOBAL) + ", " + this.noticeURL.stackSize(NoticedURL.StackType.REMOTE) + "]";
        try {
            Request urlEntry = this.noticeURL.pop(NoticedURL.StackType.REMOTE, true, this.sb.crawler, this.sb.robots);
            if (urlEntry == null) {
                return false;
            }
            this.load(urlEntry, stats);
            return true;
        }
        catch (IOException e) {
            log.severe(stats + ": CANNOT FETCH ENTRY: " + e.getMessage(), e);
            if (e.getMessage().indexOf("hash is null", 0) > 0) {
                this.noticeURL.clear(NoticedURL.StackType.REMOTE);
            }
            return true;
        }
    }

    private void ensureLoaderRunning() {
        for (int i = 0; i < this.worker.length; ++i) {
            if (this.worker[i] == null || !this.worker[i].isAlive()) {
                this.worker[i] = new Loader();
                this.worker[i].start();
                return;
            }
            if (this.worker[i].loading() != null) continue;
            return;
        }
    }

    private final class Loader
    extends Thread {
        private Request request = null;

        private Loader() {
        }

        public Request loading() {
            return this.request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            try {
                while ((this.request = CrawlQueues.this.workerQueue.poll(10L, TimeUnit.SECONDS)) != POISON_REQUEST && this.request != null) {
                    CrawlProfile profile2;
                    block19: {
                        this.request.setStatus("worker-initialized", 0);
                        this.setName("CrawlQueues.Loader(" + this.request.url().toNormalform(false) + ")");
                        profile2 = CrawlQueues.this.sb.crawler.get(UTF8.getBytes(this.request.profileHandle()));
                        try {
                            RobotsTxtEntry robotsEntry;
                            this.request.setStatus("worker-checkingrobots", 1);
                            if ((this.request.url().getProtocol().equals("http") || this.request.url().getProtocol().equals("https")) && (robotsEntry = CrawlQueues.this.sb.robots.getEntry(this.request.url(), profile2.getAgent())) != null && robotsEntry.isDisallowed(this.request.url())) {
                                CrawlQueues.this.errorURL.push(this.request.url(), this.request.depth(), profile2, FailCategory.FINAL_ROBOTS_RULE, "denied by robots.txt", -1);
                                this.request.setStatus("worker-disallowed", 3);
                                break block19;
                            }
                            this.request.setStatus("worker-loading", 2);
                            Object error = null;
                            try {
                                this.request.setStatus("loading", 2);
                                Response response = CrawlQueues.this.sb.loader.load(this.request, profile2 == null ? CacheStrategy.IFEXIST : profile2.cacheStrategy(), Blacklist.BlacklistType.CRAWLER, profile2.getAgent());
                                if (response == null) {
                                    this.request.setStatus("error", 3);
                                    if (log.isFine()) {
                                        log.fine("problem loading " + this.request.url().toString() + ": no content (possibly caused by cache policy)");
                                    }
                                    error = "no content (possibly caused by cache policy)";
                                } else {
                                    this.request.setStatus("loaded", 2);
                                    String storedFailMessage = CrawlQueues.this.sb.toIndexer(response);
                                    this.request.setStatus("enqueued-" + (storedFailMessage == null ? "ok" : "fail"), 3);
                                    error = storedFailMessage == null ? null : "not enqueued to indexer: " + storedFailMessage;
                                }
                            }
                            catch (IOException e) {
                                this.request.setStatus("error", 3);
                                if (log.isFine()) {
                                    log.fine("problem loading " + this.request.url().toString() + ": " + e.getMessage());
                                }
                                error = "load error - " + e.getMessage();
                            }
                            if (error != null) {
                                if (((String)error).endsWith("$")) {
                                    error = ((String)error).substring(0, ((String)error).length() - 1).trim();
                                } else {
                                    CrawlQueues.this.errorURL.push(this.request.url(), this.request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "cannot load: " + (String)error, -1);
                                }
                                this.request.setStatus("worker-error", 3);
                            } else {
                                this.request.setStatus("worker-processed", 3);
                            }
                        }
                        catch (Exception e) {
                            CrawlQueues.this.errorURL.push(this.request.url(), this.request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, e.getMessage() + " - in worker", -1);
                            this.request.setStatus("worker-exception", 3);
                        }
                        finally {
                            this.request = null;
                            this.setName("CrawlQueues.Loader(WAITING)");
                        }
                    }
                    profile2 = null;
                }
            }
            catch (InterruptedException e2) {
                ConcurrentLog.logException(e2);
            }
        }
    }
}

