/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.util.Random;

public class NumberTools {
    public static final long parseLongDecSubstring(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException(s);
        }
        return NumberTools.parseLongDecSubstring(s, 0, s.length());
    }

    public static final long parseLongDecSubstring(String s, int startPos) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException(s);
        }
        return NumberTools.parseLongDecSubstring(s, startPos, s.length());
    }

    public static final long parseLongDecSubstring(String s, int startPos, int endPos) throws NumberFormatException {
        char c;
        if (s == null || endPos > s.length() || endPos <= startPos) {
            throw new NumberFormatException(s);
        }
        long result = 0L;
        boolean negative = false;
        int i = startPos;
        long limit = -9223372036854775807L;
        while (s.charAt(i) == ' ') {
            ++i;
        }
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                throw new NumberFormatException(s);
            }
            if (endPos == ++i) {
                throw new NumberFormatException(s);
            }
        }
        long multmin = limit / 10L;
        while (i < endPos && (c = s.charAt(i++)) >= '0' && c <= '9') {
            int digit = c - 48;
            if (digit < 0 || digit > 9 || result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(s);
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static final int parseIntDecSubstring(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException(s);
        }
        return NumberTools.parseIntDecSubstring(s, 0, s.length());
    }

    public static final int parseIntDecSubstring(String s, int startPos) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException(s);
        }
        return NumberTools.parseIntDecSubstring(s, startPos, s.length());
    }

    public static final int parseIntDecSubstring(String s, int startPos, int endPos) throws NumberFormatException {
        char c;
        if (s == null || endPos > s.length() || endPos <= startPos) {
            throw new NumberFormatException(s);
        }
        int result = 0;
        boolean negative = false;
        int i = startPos;
        int limit = -2147483647;
        while (s.charAt(i) == ' ') {
            ++i;
        }
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                throw new NumberFormatException(s);
            }
            if (endPos == ++i) {
                throw new NumberFormatException(s);
            }
        }
        int multmin = limit / 10;
        while (i < endPos && (c = s.charAt(i++)) >= '0' && c <= '9') {
            int digit = c - 48;
            if (digit < 0 || digit > 9 || result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(s);
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static void main(String[] args) {
        System.out.println("the number is " + NumberTools.parseLongDecSubstring("number=78 ", 7));
        System.out.println("the number is " + NumberTools.parseIntDecSubstring("number=78x ", 7, 9));
        Random r = new Random(1L);
        String[] s = new String[1000000];
        for (int i = 0; i < s.length; ++i) {
            s[i] = "abc " + Integer.toString(r.nextInt()) + " ";
        }
        long d = 0L;
        long t0 = System.currentTimeMillis();
        for (String element : s) {
            d += (long)Integer.parseInt(element.substring(4).trim());
        }
        System.out.println("java: " + d + " - " + (System.currentTimeMillis() - t0) + " millis");
        d = 0L;
        t0 = System.currentTimeMillis();
        for (String element : s) {
            d += (long)NumberTools.parseIntDecSubstring(element, 4);
        }
        System.out.println("cora: " + d + " - " + (System.currentTimeMillis() - t0) + " millis");
        r = new Random(1L);
        for (int i = 0; i < s.length; ++i) {
            s[i] = Integer.toString(r.nextInt());
        }
        d = 0L;
        t0 = System.currentTimeMillis();
        for (String element : s) {
            d += (long)Integer.parseInt(element);
        }
        System.out.println("java: " + d + " - " + (System.currentTimeMillis() - t0) + " millis");
        d = 0L;
        t0 = System.currentTimeMillis();
        for (String element : s) {
            d += (long)NumberTools.parseIntDecSubstring(element);
        }
        System.out.println("cora: " + d + " - " + (System.currentTimeMillis() - t0) + " millis");
    }
}

