/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.ImageParser;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.OS;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class Html2Image {
    private static final File wkhtmltopdfMac = new File("/usr/local/bin/wkhtmltopdf");
    private static final File convertMac1 = new File("/opt/local/bin/convert");
    private static final File convertMac2 = new File("/opt/ImageMagick/bin/convert");
    private static final File wkhtmltopdfDebian = new File("/usr/bin/wkhtmltopdf");
    private static final File convertDebian = new File("/usr/bin/convert");
    private static final File WKHTMLTOPDF_WINDOWS = new File("C:\\Program Files\\wkhtmltopdf\\bin\\wkhtmltopdf.exe");
    private static final File WKHTMLTOPDF_WINDOWS_X86 = new File("C:\\Program Files (x86)\\wkhtmltopdf\\bin\\wkhtmltopdf.exe");
    private static final String WKHTMLTOPDF_COMMAND = "wkhtmltopdf";
    private static final String CONVERT_COMMAND = "convert";
    private static boolean usexvfb = false;

    public static boolean wkhtmltopdfAvailable() {
        return Html2Image.wkhtmltopdfExecutable() != null || Html2Image.wkhtmltopdfAvailableInPath();
    }

    private static File wkhtmltopdfExecutable() {
        File executable = null;
        if (OS.isWindows) {
            if (WKHTMLTOPDF_WINDOWS.exists()) {
                executable = WKHTMLTOPDF_WINDOWS;
            } else if (WKHTMLTOPDF_WINDOWS_X86.exists()) {
                executable = WKHTMLTOPDF_WINDOWS_X86;
            }
        } else if (wkhtmltopdfMac.exists()) {
            executable = wkhtmltopdfMac;
        } else if (wkhtmltopdfDebian.exists()) {
            executable = wkhtmltopdfDebian;
        }
        return executable;
    }

    private static boolean wkhtmltopdfAvailableInPath() {
        boolean available = false;
        try {
            Process p = Runtime.getRuntime().exec("wkhtmltopdf -V");
            available = p.waitFor(2L, TimeUnit.SECONDS) && p.exitValue() == 0;
        }
        catch (IOException e) {
            ConcurrentLog.fine("Html2Image", "wkhtmltopdf is not included in system path.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return available;
    }

    private static File convertExecutable() {
        File executable = null;
        if (!OS.isWindows) {
            if (convertMac1.exists()) {
                executable = convertMac1;
            } else if (convertMac2.exists()) {
                executable = convertMac2;
            } else if (convertDebian.exists()) {
                executable = convertDebian;
            }
        }
        return executable;
    }

    public static boolean convertAvailable() {
        return Html2Image.convertExecutable() != null || Html2Image.convertAvailableInPath();
    }

    private static boolean convertAvailableInPath() {
        boolean available = false;
        if (!OS.isWindows) {
            try {
                Process p = Runtime.getRuntime().exec("convert -version");
                available = p.waitFor(2L, TimeUnit.SECONDS) && p.exitValue() == 0;
            }
            catch (IOException e) {
                ConcurrentLog.fine("Html2Image", "convert is not included in system path.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return available;
    }

    public static boolean writeWkhtmltopdf(String url, String proxy, String userAgent, String acceptLanguage, File destination, long maxSeconds) {
        boolean ignoreErrors;
        boolean success = false;
        boolean[] blArray = new boolean[]{false, true};
        int n = blArray.length;
        for (int i = 0; i < n && !(success = Html2Image.writeWkhtmltopdfInternal(url, proxy, destination, userAgent, acceptLanguage, ignoreErrors = blArray[i], maxSeconds)); ++i) {
            if (success || proxy == null) continue;
            ConcurrentLog.warn("Html2Image", "trying to load without proxy: " + url);
            success = Html2Image.writeWkhtmltopdfInternal(url, null, destination, userAgent, acceptLanguage, ignoreErrors, maxSeconds);
            if (success) break;
        }
        if (success) {
            ConcurrentLog.info("Html2Image", "wrote " + destination.toString() + " for " + url);
        } else {
            ConcurrentLog.warn("Html2Image", "could not generate snapshot for " + url);
        }
        return success;
    }

    private static boolean writeWkhtmltopdfInternal(String url, String proxy, File destination, String userAgent, String acceptLanguage, boolean ignoreErrors, long maxSeconds) {
        String wkhtmltopdfCmd;
        File wkhtmltopdf = Html2Image.wkhtmltopdfExecutable();
        if (wkhtmltopdf != null) {
            wkhtmltopdfCmd = wkhtmltopdf.getAbsolutePath();
        } else if (Html2Image.wkhtmltopdfAvailableInPath()) {
            wkhtmltopdfCmd = WKHTMLTOPDF_COMMAND;
        } else {
            ConcurrentLog.warn("Html2Pdf", "Unable to locate wkhtmltopdf executable on this system!");
            return false;
        }
        String commandline = wkhtmltopdfCmd + " -q --title '" + url + "' " + (String)(proxy == null ? "" : "--proxy " + proxy + " ") + (ignoreErrors ? (OS.isMacArchitecture ? "--load-error-handling ignore " : "--ignore-load-errors ") : "") + "--footer-left [webpage] --footer-right '[date]/[time]([page]/[topage])' --footer-font-size 7 " + url + " " + destination.getAbsolutePath();
        try {
            ConcurrentLog.info("Html2Pdf", "creating pdf from url " + url + " with command: " + commandline);
            if (!usexvfb && Html2Image.execWkhtmlToPdf(proxy, destination, commandline, maxSeconds)) {
                return true;
            }
            commandline = "xvfb-run -a " + commandline;
            return Html2Image.execWkhtmlToPdf(proxy, destination, commandline, maxSeconds);
        }
        catch (IOException e) {
            ConcurrentLog.warn("Html2Pdf", "exception while creation of pdf with command: " + commandline, e);
            return false;
        }
    }

    private static boolean execWkhtmlToPdf(String proxy, File destination, String commandline, long maxSeconds) throws IOException {
        Process p = Runtime.getRuntime().exec(commandline);
        try {
            p.waitFor(maxSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            p.destroyForcibly();
            ConcurrentLog.warn("Html2Pdf", "Interrupted creation of pdf. Killing the process started with command : " + commandline);
            Thread.currentThread().interrupt();
            return false;
        }
        if (p.isAlive()) {
            ConcurrentLog.warn("Html2Pdf", "Creation of pdf did not terminate within " + maxSeconds + " seconds. Killing the process started with command : " + commandline);
            p.destroyForcibly();
            return false;
        }
        if (p.exitValue() == 0 && destination.exists()) {
            return true;
        }
        List<String> messages = OS.readStreams(p);
        ConcurrentLog.warn("Html2Image", "failed to create pdf " + (String)(proxy == null ? "" : "using proxy " + proxy) + " with command : " + commandline);
        for (String message2 : messages) {
            ConcurrentLog.warn("Html2Image", ">> " + message2);
        }
        return false;
    }

    public static boolean pdf2image(File pdf, File image, int width, int height, int density, int quality) {
        String imageFormat = MultiProtocolURL.getFileExtension(image.getName());
        if (imageFormat.isEmpty()) {
            imageFormat = "jpg";
        }
        String convertCmd = null;
        File convert = Html2Image.convertExecutable();
        if (convert != null) {
            convertCmd = convert.getAbsolutePath();
        } else if (Html2Image.convertAvailableInPath()) {
            convertCmd = CONVERT_COMMAND;
        } else {
            ConcurrentLog.info("Html2Image", "Unable to locate convert executable on this system!");
        }
        if (convertCmd == null) {
            boolean bl;
            block26: {
                PDDocument pdoc = Loader.loadPDF((File)pdf);
                try {
                    BufferedImage bi = new PDFRenderer(pdoc).renderImageWithDPI(0, (float)density, ImageType.RGB);
                    bl = ImageIO.write((RenderedImage)bi, imageFormat, image);
                    if (pdoc == null) break block26;
                }
                catch (Throwable bi) {
                    try {
                        if (pdoc != null) {
                            try {
                                pdoc.close();
                            }
                            catch (Throwable throwable) {
                                bi.addSuppressed(throwable);
                            }
                        }
                        throw bi;
                    }
                    catch (IOException ex) {
                        ConcurrentLog.warn("Html2Image", "Failed to create image with pdfbox" + (String)(ex.getMessage() != null ? " : " + ex.getMessage() : ""));
                        return false;
                    }
                }
                pdoc.close();
            }
            return bl;
        }
        String command = convertCmd + " -alpha remove -density " + density + " -trim " + pdf.getAbsolutePath() + "[0] -trim -resize " + width + "x -crop x" + height + "+0+0 -quality " + quality + "% " + image.getAbsolutePath();
        List<String> message2 = OS.execSynchronous(new String[]{convertCmd, "-alpha", "remove", "-density", Integer.toString(density), "-trim", pdf.getAbsolutePath() + "[0]", "-trim", "-resize" + Integer.toString(width) + "x", "-crop x" + Integer.toString(height) + "+0+0", "-quality", Integer.toString(quality) + "%", image.getAbsolutePath()});
        if (image.exists()) {
            return true;
        }
        ConcurrentLog.warn("Html2Image", "failed to create image with command: " + command);
        for (String m : message2) {
            ConcurrentLog.warn("Html2Image", ">> " + m);
        }
        if (!OS.isMacArchitecture) {
            return false;
        }
        File pngFile = new File(pdf.getAbsolutePath() + ".tmp.pdf");
        org.apache.commons.io.FileUtils.copyFile((File)pdf, (File)pngFile);
        String[] commandx = new String[]{"osascript", "-e", "set ImgFile to \"" + pngFile.getAbsolutePath() + "\"", "-e", "tell application \"Image Events\"", "-e", "set Img to open file ImgFile", "-e", "save Img as PNG", "-e", "end tell"};
        message2 = OS.execSynchronous(commandx);
        for (String m : message2) {
            ConcurrentLog.warn("Html2Image", ">> " + m);
        }
        try {
            File newPngFile = new File(pngFile.getAbsolutePath() + ".png");
            pngFile.renameTo(newPngFile);
            Image img = ImageParser.parse(pngFile.getAbsolutePath(), FileUtils.read(newPngFile));
            if (img == null) {
                return false;
            }
            Image scaled = img.getScaledInstance(width, height, 16);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(scaled, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BufferedImage bi = new BufferedImage(width, height, 1);
            bi.createGraphics().drawImage(scaled, 0, 0, width, height, null);
            ImageIO.write((RenderedImage)bi, imageFormat, image);
            newPngFile.delete();
            return image.exists();
        }
        catch (IOException e) {
            try {
                ConcurrentLog.logException(e);
                return false;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return false;
            }
        }
    }

    public static void writeSwingImage(String url, Dimension size, File destination) throws IOException {
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.setSize(size);
        htmlPane.setEditable(false);
        HTMLEditorKit kit = new HTMLEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public Document createDefaultDocument() {
                HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
                doc.setAsynchronousLoadPriority(-1);
                return doc;
            }

            @Override
            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element elem) {
                        View view = super.create(elem);
                        if (view instanceof ImageView) {
                            ((ImageView)view).setLoadsSynchronously(true);
                        }
                        return view;
                    }
                };
            }
        };
        htmlPane.setEditorKitForContentType("text/html", kit);
        htmlPane.setContentType("text/html");
        htmlPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        try {
            htmlPane.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Dimension prefSize = htmlPane.getPreferredSize();
        BufferedImage img = new BufferedImage(prefSize.width, htmlPane.getPreferredSize().height, 2);
        Graphics graphics = img.getGraphics();
        htmlPane.setSize(prefSize);
        htmlPane.paint(graphics);
        ImageIO.write((RenderedImage)img, destination.getName().endsWith("jpg") ? "jpg" : "png", destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block49: {
            String usageMessage = "Usage : java " + Html2Image.class.getName() + " <url> <target-file[.pdf|.jpg|.png]> [wkhtmltopdf|swing]";
            int exitStatus = 0;
            try {
                if (args.length < 2) {
                    System.out.println("Missing required parameter(s).");
                    System.out.println(usageMessage);
                    exitStatus = 1;
                    return;
                }
                String targetPath = args[1];
                if (args.length < 3 || WKHTMLTOPDF_COMMAND.equals(args[2])) {
                    if (Html2Image.wkhtmltopdfAvailable()) {
                        File targetPdfFile;
                        if (targetPath.endsWith(".jpg") || targetPath.endsWith(".png")) {
                            targetPdfFile = new File(targetPath.substring(0, targetPath.length() - 4) + ".pdf");
                        } else if (targetPath.endsWith(".pdf")) {
                            targetPdfFile = new File(targetPath);
                        } else {
                            System.out.println("Unsupported output format");
                            System.out.println(usageMessage);
                            exitStatus = 1;
                            return;
                        }
                        if (Html2Image.writeWkhtmltopdf(args[0], null, ClientIdentification.yacyInternetCrawlerAgent.userAgent, "en-us,en;q=0.5", targetPdfFile, 30L)) {
                            if (!targetPath.endsWith(".jpg") && !targetPath.endsWith(".png")) break block49;
                            if (Html2Image.pdf2image(targetPdfFile, new File(targetPath), 1024, 1024, 300, 75)) {
                                ConcurrentLog.info("Html2Image", "wrote " + targetPath + " converted from " + targetPdfFile);
                                break block49;
                            }
                            exitStatus = 1;
                            return;
                        }
                        exitStatus = 1;
                        return;
                    }
                    System.out.println("Unable to locate wkhtmltopdf executable on this system!");
                    exitStatus = 1;
                    return;
                }
                if ("swing".equals(args[2])) {
                    if (targetPath.endsWith(".pdf")) {
                        System.out.println("Pdf output format is not supported with swing method.");
                        exitStatus = 1;
                        return;
                    }
                    if (!targetPath.endsWith(".jpg") && !targetPath.endsWith(".png")) {
                        System.out.println("Unsupported output format");
                        System.out.println(usageMessage);
                        exitStatus = 1;
                        return;
                    }
                    try {
                        Html2Image.writeSwingImage(args[0], new Dimension(1200, 2000), new File(targetPath));
                        break block49;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        exitStatus = 1;
                        Domains.close();
                        try {
                            HTTPClient.closeConnectionManager();
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                        ConcurrentLog.shutdown();
                        if (exitStatus != 0) {
                            System.exit(exitStatus);
                        }
                        return;
                    }
                }
                System.out.println("Unknown method : please specify either wkhtmltopdf or swing.");
                exitStatus = 1;
                return;
            }
            finally {
                Domains.close();
                try {
                    HTTPClient.closeConnectionManager();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ConcurrentLog.shutdown();
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
        }
    }
}

