/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.yacy.cora.document.encoding.UTF8;

public final class ByteBuffer
extends OutputStream {
    private byte[] buffer;
    private int offset;
    private int length;

    public ByteBuffer() {
        this.buffer = new byte[10];
        this.length = 0;
        this.offset = 0;
    }

    public ByteBuffer(int initLength) {
        this.buffer = new byte[initLength];
        this.length = 0;
        this.offset = 0;
    }

    public ByteBuffer(byte[] bb) {
        this.buffer = bb;
        this.length = bb.length;
        this.offset = 0;
    }

    public ByteBuffer(String s) {
        this.buffer = UTF8.getBytes(s);
        this.length = this.buffer.length;
        this.offset = 0;
    }

    public void clear() {
        this.length = 0;
        this.offset = 0;
    }

    public int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    private void grow() {
        int newsize = this.buffer.length * 2 + 1;
        if (newsize < 256) {
            newsize = 256;
        }
        byte[] tmp = new byte[newsize];
        System.arraycopy(this.buffer, this.offset, tmp, 0, this.length);
        this.buffer = tmp;
        this.offset = 0;
    }

    @Override
    public void write(int b) {
        this.write((byte)(b & 0xFF));
    }

    public void write(char b) {
        this.write((byte)b);
    }

    private void write(byte b) {
        if (this.offset + this.length + 1 > this.buffer.length) {
            this.grow();
        }
        this.buffer[this.offset + this.length++] = b;
    }

    @Override
    public void write(byte[] bb) {
        this.write(bb, 0, bb.length);
    }

    @Override
    public void write(byte[] bb, int of, int le) {
        while (this.offset + this.length + le > this.buffer.length) {
            this.grow();
        }
        System.arraycopy(bb, of, this.buffer, this.offset + this.length, le);
        this.length += le;
    }

    public ByteBuffer append(byte b) {
        this.write(b);
        return this;
    }

    public ByteBuffer append(char b) {
        this.write(b);
        return this;
    }

    public ByteBuffer append(int i) {
        this.write((byte)(i & 0xFF));
        return this;
    }

    public ByteBuffer append(byte[] bb) {
        this.write(bb, 0, bb.length);
        return this;
    }

    public ByteBuffer append(byte[] bb, int of, int le) {
        this.write(bb, of, le);
        return this;
    }

    public ByteBuffer append(String s) {
        return this.append(UTF8.getBytes(s));
    }

    public byte byteAt(int pos) {
        if (pos > this.length) {
            return -1;
        }
        return this.buffer[this.offset + pos];
    }

    public int indexOf(byte[] bs, int start) {
        if (start + bs.length > this.length) {
            return -1;
        }
        block0: for (int i = start; i <= this.length - bs.length; ++i) {
            if (this.buffer[this.offset + i] != bs[0]) continue;
            for (int j = 1; j < bs.length; ++j) {
                if (this.buffer[this.offset + i + j] != bs[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public boolean startsWith(byte[] bs, int start) {
        if (this.length - start < bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (this.buffer[this.offset + i + start] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.getBytes(0);
    }

    private byte[] getBytes(int start) {
        return this.getBytes(start, this.length);
    }

    public byte[] getBytes(int start, int len) {
        if (len > this.length) {
            throw new IndexOutOfBoundsException("getBytes: len > length");
        }
        if (start > this.length) {
            throw new IndexOutOfBoundsException("getBytes: start > length");
        }
        if (start == 0 && len == this.length && len == this.buffer.length) {
            return this.buffer;
        }
        byte[] tmp = new byte[len];
        System.arraycopy(this.buffer, this.offset + start, tmp, 0, len);
        return tmp;
    }

    public void copyTo(byte[] otherArray, int offset) {
        System.arraycopy(this.buffer, 0, otherArray, offset, this.length);
    }

    public ByteBuffer trim(int start) {
        this.offset += start;
        this.length -= start;
        return this;
    }

    public ByteBuffer trim(int start, int len) {
        if (start + len > this.length) {
            throw new IndexOutOfBoundsException("trim: start + len > length; this.offset = " + this.offset + ", this.length = " + this.length + ", start = " + start + ", len = " + len);
        }
        this.offset += start;
        this.length = len;
        return this;
    }

    public String toString() {
        return UTF8.String(this.buffer, this.offset, this.length);
    }

    public String toString(int left, int length) {
        return UTF8.String(this.buffer, this.offset + left, length);
    }

    public StringBuilder toStringBuilder(int left, int length, int sblength) {
        assert (sblength >= length);
        StringBuilder sb = new StringBuilder(sblength);
        int i = 0;
        sb.setLength(length);
        for (int j = left; j < left + length; ++j) {
            sb.setCharAt(i++, (char)this.buffer[this.offset + j]);
        }
        return sb;
    }

    public static boolean startsWith(byte[] buffer, byte[] pattern) {
        if (buffer.length < pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (buffer[i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] b0, int off0, byte[] b1, int off1, int length) {
        if (b0.length - off0 < length || b1.length - off1 < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (b0[off0 + i] == b1[off1 + i]) continue;
            return false;
        }
        return true;
    }

    public void writeTo(OutputStream dest) throws IOException {
        dest.write(this.buffer, this.offset, this.length);
        dest.flush();
    }

    public static boolean contains(Collection<byte[]> collection, byte[] key) {
        for (byte[] v : collection) {
            if (!Arrays.equals(v, key)) continue;
            return true;
        }
        return false;
    }

    public static int remove(Collection<byte[]> collection, byte[] key) {
        Iterator<byte[]> i = collection.iterator();
        int c = 0;
        while (i.hasNext()) {
            byte[] v = i.next();
            if (!Arrays.equals(v, key)) continue;
            i.remove();
            ++c;
        }
        return c;
    }

    public static List<byte[]> split(byte[] b, byte s) {
        ArrayList<byte[]> a = new ArrayList<byte[]>();
        int c = 0;
        while (c < b.length) {
            byte[] bb;
            int i;
            for (i = c; i < b.length && b[i] != s; ++i) {
            }
            if (i >= b.length) {
                bb = new byte[b.length - c];
                System.arraycopy(b, c, bb, 0, bb.length);
                a.add(bb);
                break;
            }
            bb = new byte[i - c];
            System.arraycopy(b, c, bb, 0, bb.length);
            a.add(bb);
            c = i + 1;
        }
        return a;
    }
}

