/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.NamePrefixThreadFactory;

public class TimeoutRequest<E> {
    public static boolean enable = true;
    private final Callable<E> call;

    public TimeoutRequest(Callable<E> call) {
        this.call = call;
    }

    public E call(long timeout) throws ExecutionException {
        if (!enable) {
            try {
                return this.call.call();
            }
            catch (Exception e1) {
                throw new ExecutionException(e1);
            }
        }
        ExecutorService service = Executors.newSingleThreadExecutor(new NamePrefixThreadFactory("TimeoutRequest"));
        try {
            final Future<E> taskFuture = service.submit(this.call);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    taskFuture.cancel(true);
                }
            };
            service.execute(t);
            service.shutdown();
            try {
                return taskFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                throw new ExecutionException(e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e);
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.warn(TimeoutRequest.class.getName(), "OutOfMemoryError / retry follows", e);
            try {
                return this.call.call();
            }
            catch (Exception e1) {
                throw new ExecutionException(e1);
            }
        }
    }

    public static boolean ping(final String host, final int port, final int timeout) {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(host, port), timeout);
                        if (socket.isConnected()) {
                            socket.close();
                            return Boolean.TRUE;
                        }
                        socket.close();
                        return Boolean.FALSE;
                    }
                    catch (UnknownHostException e) {
                        return Boolean.FALSE;
                    }
                    catch (IOException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException ex) {
            return false;
        }
    }

    public static String getHostName(final InetAddress i, long timeout) throws ExecutionException {
        return new TimeoutRequest<String>(new Callable<String>(){

            @Override
            public String call() {
                return i.getHostName();
            }
        }).call(timeout);
    }

    public static boolean exists(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        return file.exists();
                    }
                    catch (SmbException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean canRead(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        return file.canRead();
                    }
                    catch (SmbException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean canWrite(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        return file.canWrite();
                    }
                    catch (SmbException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean isHidden(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        return file.isHidden();
                    }
                    catch (SmbException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean isDirectory(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        return file.isDirectory();
                    }
                    catch (SmbException e) {
                        return Boolean.FALSE;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static long length(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Long>(new Callable<Long>(){

                @Override
                public Long call() {
                    try {
                        return file.length();
                    }
                    catch (SmbException e) {
                        return 0L;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(file.toString() + ":" + e.getMessage());
        }
    }

    public static long lastModified(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<Long>(new Callable<Long>(){

                @Override
                public Long call() {
                    try {
                        return file.lastModified();
                    }
                    catch (SmbException e) {
                        return 0L;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String[] list(final SmbFile file, long timeout) throws IOException {
        try {
            return new TimeoutRequest<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() {
                    try {
                        return file.list();
                    }
                    catch (SmbException e) {
                        return null;
                    }
                }
            }).call(timeout);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage());
        }
    }
}

