/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.util.NumberTools;
import org.eclipse.jetty.server.CookieCutter;
import org.eclipse.jetty.util.URIUtil;

public class RequestHeader
extends HeaderFramework
implements HttpServletRequest {
    public static final String CONNECTION = "Connection";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String AUTHORIZATION = "Authorization";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String UPGRADE = "Upgrade";
    public static final String TE = "TE";
    public static final String X_CACHE = "X-Cache";
    public static final String X_CACHE_LOOKUP = "X-Cache-Lookup";
    public static final String X_Real_IP = "X-Real-IP";
    public static final String COOKIE = "Cookie";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_RANGE = "If-Range";
    public static final String REFERER = "Referer";
    private static final long serialVersionUID = 0L;
    private final HttpServletRequest _request;
    private Date date_cache_IfModifiedSince = null;

    public RequestHeader() {
        this._request = null;
    }

    public RequestHeader(HttpServletRequest request) {
        this._request = request;
    }

    public DigestURL referer() {
        String referer = this.get(REFERER);
        if (referer == null) {
            return null;
        }
        try {
            return new DigestURL(referer);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String refererHost() {
        DigestURL url = this.referer();
        if (url == null) {
            return null;
        }
        return url.getHost();
    }

    public Date ifModifiedSince() {
        if (this.date_cache_IfModifiedSince != null) {
            return this.date_cache_IfModifiedSince;
        }
        long time = this.getDateHeader(IF_MODIFIED_SINCE);
        if (time > 0L) {
            this.date_cache_IfModifiedSince = new Date(time);
        }
        return this.date_cache_IfModifiedSince;
    }

    public FileType fileType() {
        String path = this.getPathInfo();
        if (path == null) {
            return FileType.HTML;
        }
        if ((path = path.toLowerCase(Locale.ROOT)).endsWith(".json")) {
            return FileType.JSON;
        }
        if (path.endsWith(".xml")) {
            return FileType.XML;
        }
        if (path.endsWith(".rdf")) {
            return FileType.XML;
        }
        if (path.endsWith(".rss")) {
            return FileType.XML;
        }
        return FileType.HTML;
    }

    public boolean accessFromLocalhost() {
        String clientIP = this.getRemoteAddr();
        if (!Domains.isLocalhost(clientIP)) {
            return false;
        }
        String refererHost = this.refererHost();
        return refererHost == null || refererHost.isEmpty() || Domains.isLocalhost(refererHost);
    }

    @Deprecated
    public String getHeaderCookies() {
        String cookiestring = this.get(COOKIE);
        if (cookiestring == null) {
            return "";
        }
        return cookiestring;
    }

    @Override
    public String get(Object key) {
        String value = (String)super.get(key);
        if (value == null && this._request != null) {
            return this._request.getHeader((String)key);
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean val = super.containsKey(key);
        if (val) {
            return val;
        }
        if (this._request != null) {
            return this._request.getHeader((String)key) != null;
        }
        return val;
    }

    @Override
    public String mime() {
        if (super.containsKey("Content-Type")) {
            return super.mime();
        }
        if (this._request != null) {
            return this._request.getContentType();
        }
        return "application/octet-stream";
    }

    public String getAuthType() {
        if (this._request != null) {
            return this._request.getAuthType();
        }
        return null;
    }

    public Cookie[] getCookies() {
        if (this._request != null) {
            return this._request.getCookies();
        }
        String cstr = (String)super.get(COOKIE);
        if (cstr != null) {
            CookieCutter cc = new CookieCutter();
            cc.addCookieField(cstr);
            return cc.getCookies();
        }
        return null;
    }

    public long getDateHeader(String name) {
        Date d = super.headerDate(name);
        if (d != null) {
            return d.getTime();
        }
        if (this._request != null) {
            return this._request.getDateHeader(name);
        }
        return -1L;
    }

    public String getHeader(String name) {
        return this.get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this._request != null) {
            return this._request.getHeaders(name);
        }
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        if (this._request != null) {
            return this._request.getHeaderNames();
        }
        return null;
    }

    public int getIntHeader(String name) {
        if (super.containsKey(name)) {
            String val = (String)super.get(name);
            if (val != null) {
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (this._request != null) {
            return this._request.getIntHeader(name);
        }
        return -1;
    }

    public String getMethod() {
        if (this._request != null) {
            return this._request.getMethod();
        }
        return "POST";
    }

    public String getPathInfo() {
        if (super.containsKey("PATH")) {
            return (String)super.get("PATH");
        }
        if (this._request != null) {
            return this._request.getPathInfo();
        }
        return "";
    }

    public String getPathTranslated() {
        if (this._request != null) {
            return this._request.getPathTranslated();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getContextPath() {
        if (this._request != null) {
            return this._request.getContextPath();
        }
        return "";
    }

    public String getQueryString() {
        if (this._request != null) {
            return this._request.getQueryString();
        }
        return null;
    }

    public String getRemoteUser() {
        if (this._request != null) {
            return this._request.getRemoteUser();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        if (this._request != null) {
            return this._request.isUserInRole(role);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        if (this._request != null) {
            return this._request.getUserPrincipal();
        }
        return null;
    }

    public String getRequestedSessionId() {
        if (this._request != null) {
            return this._request.getRequestedSessionId();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRequestURI() {
        if (this._request != null) {
            return this._request.getRequestURI();
        }
        return super.get("PATH", "/");
    }

    public StringBuffer getRequestURL() {
        if (this._request != null) {
            return this._request.getRequestURL();
        }
        StringBuffer sbuf = new StringBuffer(32);
        URIUtil.appendSchemeHostPort((StringBuffer)sbuf, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        sbuf.append(this.getRequestURI());
        return sbuf;
    }

    public String getServletPath() {
        if (this._request != null) {
            return this._request.getServletPath();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HttpSession getSession(boolean create) {
        if (this._request != null) {
            return this._request.getSession(create);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HttpSession getSession() {
        if (this._request != null) {
            return this._request.getSession();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String changeSessionId() {
        if (this._request != null) {
            return this._request.changeSessionId();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRequestedSessionIdValid() {
        if (this._request != null) {
            return this._request.isRequestedSessionIdValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this._request != null) {
            return this._request.isRequestedSessionIdFromCookie();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this._request != null) {
            return this._request.isRequestedSessionIdFromURL();
        }
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        if (this._request != null) {
            return this._request.isRequestedSessionIdFromUrl();
        }
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this._request != null) {
            return this._request.authenticate(response);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void login(String username, String password) throws ServletException {
        if (this._request == null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this._request.login(username, password);
    }

    public void logout() throws ServletException {
        if (this._request != null) {
            this._request.logout();
        }
        super.remove(AUTHORIZATION);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this._request != null) {
            return this._request.getParts();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this._request != null) {
            return this._request.getPart(name);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        if (this._request != null) {
            return (T)this._request.upgrade(handlerClass);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getAttribute(String name) {
        if (this._request != null) {
            return this._request.getAttribute(name);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Enumeration<String> getAttributeNames() {
        if (this._request != null) {
            return this._request.getAttributeNames();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        if (enc == null && this._request != null) {
            return this._request.getCharacterEncoding();
        }
        return enc;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this._request != null) {
            this._request.setCharacterEncoding(env);
        } else {
            String mime = this.mime();
            super.put("Content-Type", mime + "; charset=" + env);
        }
    }

    @Override
    public int getContentLength() {
        int len = super.getContentLength();
        if (len < 0 && this._request != null) {
            return this._request.getContentLength();
        }
        return len;
    }

    @Override
    public long getContentLengthLong() {
        long len = super.getContentLengthLong();
        if (len < 0L && this._request != null) {
            return this._request.getContentLengthLong();
        }
        return len;
    }

    @Override
    public String getContentType() {
        if (super.containsKey("Content-Type")) {
            return super.mime();
        }
        if (this._request != null) {
            return this._request.getContentType();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._request != null) {
            return this._request.getInputStream();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getParameter(String name) {
        if (this._request != null) {
            return this._request.getParameter(name);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Enumeration<String> getParameterNames() {
        if (this._request != null) {
            return this._request.getParameterNames();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getParameterValues(String name) {
        if (this._request != null) {
            return this._request.getParameterValues(name);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, String[]> getParameterMap() {
        if (this._request != null) {
            return this._request.getParameterMap();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getProtocol() {
        if (this._request != null) {
            return this._request.getProtocol();
        }
        return super.get("HTTP", "HTTP/1.1");
    }

    public String getScheme() {
        if (this._request != null) {
            return this._request.getScheme();
        }
        if (super.containsKey("PROTOCOL")) {
            return (String)super.get("PROTOCOL");
        }
        return "http";
    }

    public String getServerName() {
        if (super.containsKey("Host")) {
            int pos;
            String hostport = (String)super.get("Host");
            if (hostport.contains("[")) {
                int pos2 = hostport.lastIndexOf(93);
                if (pos2 > 0) {
                    return hostport.substring(0, pos2 + 1);
                }
            } else if (hostport.contains(":") && (pos = hostport.indexOf(58)) > 0) {
                return hostport.substring(0, pos);
            }
            return hostport;
        }
        if (this._request != null) {
            return this._request.getServerName();
        }
        return "localhost";
    }

    public int getServerPort() {
        if (super.containsKey("Host")) {
            String hostport = (String)super.get("Host");
            int port = this.getScheme().equals("https") ? 443 : 80;
            int pos = hostport.lastIndexOf(58);
            if (pos > 0 && hostport.lastIndexOf(93) < pos) {
                port = NumberTools.parseIntDecSubstring(hostport, pos + 1);
            }
            return port;
        }
        if (this._request != null) {
            return this._request.getServerPort();
        }
        return 80;
    }

    public BufferedReader getReader() throws IOException {
        if (this._request != null) {
            return this._request.getReader();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRemoteAddr() {
        if (this._request != null) {
            return RequestHeader.client((ServletRequest)this._request);
        }
        return (String)super.get("CLIENTIP");
    }

    public static String client(ServletRequest request) {
        String XRealIP;
        String clientHost = request.getRemoteAddr();
        if (request instanceof HttpServletRequest && (XRealIP = ((HttpServletRequest)request).getHeader(X_Real_IP)) != null && XRealIP.length() > 0) {
            clientHost = XRealIP;
        }
        return clientHost;
    }

    public String getRemoteHost() {
        if (this._request != null) {
            return RequestHeader.host((ServletRequest)this._request);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static String host(ServletRequest request) {
        String XRealIP;
        String clientHost = request.getRemoteHost();
        if (request instanceof HttpServletRequest && (XRealIP = ((HttpServletRequest)request).getHeader(X_Real_IP)) != null && XRealIP.length() > 0) {
            clientHost = XRealIP;
        }
        return clientHost;
    }

    public void setAttribute(String name, Object o) {
        if (this._request == null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this._request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        if (this._request == null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this._request.removeAttribute(name);
    }

    public Locale getLocale() {
        if (this._request != null) {
            return this._request.getLocale();
        }
        if (super.containsKey("Accept-Language")) {
            String lng = (String)super.get("Accept-Language");
            return new Locale(lng);
        }
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        if (this._request != null) {
            return this._request.getLocales();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSecure() {
        if (this._request != null) {
            return this._request.isSecure();
        }
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this._request != null) {
            return this._request.getRequestDispatcher(path);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    public String getRealPath(String path) {
        if (this._request != null) {
            return this._request.getRealPath(path);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getRemotePort() {
        if (this._request != null) {
            return this._request.getRemotePort();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLocalName() {
        if (this._request != null) {
            return this._request.getLocalName();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLocalAddr() {
        if (this._request != null) {
            return this._request.getLocalAddr();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getLocalPort() {
        if (this._request != null) {
            return this._request.getLocalPort();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletContext getServletContext() {
        if (this._request != null) {
            return this._request.getServletContext();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (this._request != null) {
            return this._request.startAsync();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this._request != null) {
            return this._request.startAsync(servletRequest, servletResponse);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAsyncStarted() {
        if (this._request != null) {
            return this._request.isAsyncStarted();
        }
        return false;
    }

    public boolean isAsyncSupported() {
        if (this._request != null) {
            return this._request.isAsyncStarted();
        }
        return false;
    }

    public AsyncContext getAsyncContext() {
        if (this._request != null) {
            return this._request.getAsyncContext();
        }
        return null;
    }

    public DispatcherType getDispatcherType() {
        if (this._request != null) {
            return this._request.getDispatcherType();
        }
        return null;
    }

    public static enum FileType {
        HTML,
        JSON,
        XML;

    }
}

