/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;

public class HeaderFramework
extends TreeMap<String, String>
implements Map<String, String> {
    private static final long serialVersionUID = 18L;
    public static final String HTTP_VERSION_0_9 = "HTTP/0.9";
    public static final String HTTP_VERSION_1_0 = "HTTP/1.0";
    public static final String HTTP_VERSION_1_1 = "HTTP/1.1";
    public static final String HOST = "Host";
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String PRAGMA = "Pragma";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String DATE = "Date";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String SERVER = "Server";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String RANGE = "Range";
    public static final String LOCATION = "Location";
    public static final String ETAG = "ETag";
    public static final String VIA = "Via";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_ROBOTS_TAG = "X-Robots-Tag";
    public static final String X_ROBOTS = "X-Robots";
    public static final String X_YACY_INDEX_CONTROL = "X-YaCy-Index-Control";
    @Deprecated
    public static final String X_YACY_REQUEST_SCHEME = "X-YaCy-Request-Scheme";
    public static final String X_YACY_TRANSACTION_TOKEN = "X-YaCy-Transaction-Token";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String EXPIRES = "Expires";
    public static final String CORS_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String RESPONSE_TIME_MILLIS = "ResponseTimeMillis";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_CONNECT = "CONNECT";
    public static final String STATUS_CODE = "STATUS_CODE";
    public static final Map<String, String> http1_0 = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> http1_1;
    public static final String CONNECTION_PROP_HTTP_VER = "HTTP";
    @Deprecated
    public static final String CONNECTION_PROP_PROTOCOL = "PROTOCOL";
    public static final String CONNECTION_PROP_HOST = "HOST";
    public static final String CONNECTION_PROP_USER = "USER";
    public static final String CONNECTION_PROP_METHOD = "METHOD";
    public static final String CONNECTION_PROP_PATH = "PATH";
    public static final String CONNECTION_PROP_EXT = "EXT";
    public static final String CONNECTION_PROP_CLIENTIP = "CLIENTIP";
    public static final String CONNECTION_PROP_PERSISTENT = "PERSISTENT";
    public static final String CONNECTION_PROP_REQUEST_START = "REQUEST_START";
    public static final String CONNECTION_PROP_REQUEST_END = "REQUEST_END";
    public static final String CONNECTION_PROP_DIGESTURL = "URL";
    public static final String CONNECTION_PROP_CLIENT_HTTPSERVLETREQUEST = "CLIENT_HTTPSERVLETREQUEST";
    public static final String CONNECTION_PROP_PROXY_RESPOND_CODE = "PROXY_RESPOND_CODE";
    public static final String CONNECTION_PROP_PROXY_RESPOND_STATUS = "PROXY_RESPOND_STATUS";
    public static final String CONNECTION_PROP_PROXY_RESPOND_HEADER = "PROXY_RESPOND_HEADER";
    public static final String CONNECTION_PROP_PROXY_RESPOND_SIZE = "PROXY_REQUEST_SIZE";
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final SimpleDateFormat FORMAT_RFC1123;
    private static final TimeZone TZ_GMT;
    private static final Calendar CAL_GMT;
    public static final DateTimeFormatter RFC1123_FORMATTER;
    private static final SimpleDateFormat[] FORMATS_HTTP;
    private static long lastRFC1123long;
    private static String lastRFC1123string;

    public HeaderFramework() {
        super(ASCII.insensitiveASCIIComparator);
    }

    public HeaderFramework(Map<String, String> othermap) {
        super(ASCII.insensitiveASCIIComparator);
        if (othermap != null) {
            this.putAll(othermap);
        }
    }

    public static SimpleDateFormat newRfc1123Format() {
        return new SimpleDateFormat(PATTERN_RFC1123, Locale.US);
    }

    public static SimpleDateFormat newRfc1036Format() {
        return new SimpleDateFormat(PATTERN_RFC1036, Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatRFC1123(Date date) {
        if (date == null) {
            return "";
        }
        if (Math.abs(date.getTime() - lastRFC1123long) < 1000L) {
            return lastRFC1123string;
        }
        SimpleDateFormat simpleDateFormat = FORMAT_RFC1123;
        synchronized (simpleDateFormat) {
            String s = FORMAT_RFC1123.format(date);
            lastRFC1123long = date.getTime();
            lastRFC1123string = s;
            return s;
        }
    }

    public static final String formatRFC1123(long epochMilli) {
        try {
            return RFC1123_FORMATTER.format(Instant.ofEpochMilli(epochMilli));
        }
        catch (DateTimeException e) {
            return HeaderFramework.formatRFC1123(new Date(epochMilli));
        }
    }

    public static final String formatNowRFC1123() {
        return HeaderFramework.formatRFC1123(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseHTTPDate(String s) {
        if ((s = s.trim()) == null || s.length() < 9) {
            return null;
        }
        SimpleDateFormat[] simpleDateFormatArray = FORMATS_HTTP;
        int n = simpleDateFormatArray.length;
        for (int i = 0; i < n; ++i) {
            SimpleDateFormat format;
            SimpleDateFormat simpleDateFormat = format = simpleDateFormatArray[i];
            synchronized (simpleDateFormat) {
                try {
                    return format.parse(s);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
        }
        return null;
    }

    public String add(String key, String value) {
        int c = this.keyCount(key);
        if (c == 0) {
            return this.put(key, value);
        }
        return this.put("*" + key + "-" + Integer.toString(c), value);
    }

    public int keyCount(String key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        int c = 1;
        String h = "*" + key + "-";
        while (this.containsKey(h + Integer.toString(c))) {
            ++c;
        }
        return c;
    }

    public String get(String key, String dflt) {
        String result = (String)this.get(key);
        if (result == null) {
            return dflt;
        }
        return result;
    }

    public String getSingle(String key, int count) {
        if (count == 0) {
            return (String)this.get(key);
        }
        return (String)this.get("*" + key + "-" + count);
    }

    public String[] getMultiple(String key) {
        int count = this.keyCount(key);
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.getSingle(key, i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File f) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            for (Map.Entry entry2 : this.entrySet()) {
                fos.write(UTF8.getBytes((String)entry2.getKey() + "=" + (String)entry2.getValue() + "\r\n"));
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public String mime() {
        String tmpstr = this.get(CONTENT_TYPE, "application/octet-stream");
        int pos = tmpstr.indexOf(59);
        if (pos > 0) {
            return tmpstr.substring(0, pos).trim();
        }
        return tmpstr;
    }

    public String getCharacterEncoding() {
        return HeaderFramework.getCharacterEncoding(this.getContentType());
    }

    public static final String getCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        String[] parts = CommonPattern.SEMICOLON.split(contentType);
        if (parts == null || parts.length <= 1) {
            return null;
        }
        for (int i = 1; i < parts.length; ++i) {
            String param = parts[i].trim();
            if (!param.toLowerCase(Locale.ROOT).startsWith("charset=")) continue;
            String charset = param.substring("charset=".length()).trim();
            if (charset.length() > 0 && (charset.charAt(0) == '\"' || charset.charAt(0) == '\'')) {
                charset = charset.substring(1);
            }
            if (charset.endsWith("\"") || charset.endsWith("'")) {
                charset = charset.substring(0, charset.length() - 1);
            }
            return charset.trim();
        }
        return null;
    }

    public int getContentLength() {
        if (this.containsKey(CONTENT_LENGTH)) {
            try {
                return (int)Long.parseLong((String)this.get(CONTENT_LENGTH));
            }
            catch (NumberFormatException e) {
                ConcurrentLog.warn("HeaderFramework", "content-length cannot be parsed: " + (String)this.get(CONTENT_LENGTH));
                return -1;
            }
        }
        return -1;
    }

    public long getContentLengthLong() {
        if (this.containsKey(CONTENT_LENGTH)) {
            try {
                return Long.parseLong((String)this.get(CONTENT_LENGTH));
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public String getContentType() {
        return (String)this.get(CONTENT_TYPE);
    }

    protected Date headerDate(String kind) {
        if (this.containsKey(kind)) {
            Date parsedDate = HeaderFramework.parseHTTPDate((String)this.get(kind));
            if (parsedDate == null) {
                return null;
            }
            return parsedDate;
        }
        return null;
    }

    public StringBuilder toHeaderString(String httpVersion, int httpStatusCode, String httpStatusText) {
        StringBuilder theHeader = new StringBuilder(180);
        this.toHeaderString(httpVersion, httpStatusCode, httpStatusText, theHeader);
        return theHeader;
    }

    public void toHeaderString(String httpVersion, int httpStatusCode, String httpStatusText, StringBuilder theHeader) {
        if (theHeader == null) {
            throw new IllegalArgumentException();
        }
        if (httpVersion == null) {
            httpVersion = HTTP_VERSION_1_0;
        }
        if (httpStatusText == null || httpStatusText.length() == 0) {
            httpStatusText = http1_1.containsKey(Integer.toString(httpStatusCode)) ? http1_1.get(Integer.toString(httpStatusCode)) : "Unknown";
        }
        theHeader.append(httpVersion).append(" ").append(Integer.toString(httpStatusCode)).append(" ").append(httpStatusText).append("\r\n");
        for (String key : this.keySet()) {
            char tag = key.charAt(0);
            if (tag == '*' || tag == '#') continue;
            int count = this.keyCount(key);
            for (int j = 0; j < count; ++j) {
                theHeader.append(key).append(": ").append(this.getSingle(key, j)).append("\r\n");
            }
        }
        theHeader.append("\r\n");
    }

    public void readHttpHeader(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            int p = line.indexOf(58);
            if (p < 0) continue;
            this.add(line.substring(0, p).trim(), line.substring(p + 1).trim());
        }
    }

    static {
        http1_0.put("200", "OK");
        http1_0.put("201", "Created");
        http1_0.put("202", "Accepted");
        http1_0.put("204", "No Content");
        http1_0.put("300", "Multiple Choices");
        http1_0.put("301", "Moved Permanently");
        http1_0.put("302", "Moved Temporarily");
        http1_0.put("304", "Not Modified");
        http1_0.put("400", "Bad Request");
        http1_0.put("401", "Unauthorized");
        http1_0.put("403", "Forbidden");
        http1_0.put("404", "Not Found");
        http1_0.put("500", "Internal Server Error");
        http1_0.put("501", "Not Implemented");
        http1_0.put("502", "Bad Gateway");
        http1_0.put("503", "Service Unavailable");
        http1_1 = new ConcurrentHashMap<String, String>();
        http1_1.putAll(http1_0);
        http1_1.put("100", "Continue");
        http1_1.put("101", "Switching Protocols");
        http1_1.put("203", "Non-Authoritative Information");
        http1_1.put("205", "Reset Content");
        http1_1.put("206", "Partial Content");
        http1_1.put("300", "Multiple Choices");
        http1_1.put("303", "See Other");
        http1_1.put("305", "Use Proxy");
        http1_1.put("307", "Temporary Redirect");
        http1_1.put("402", "Payment Required");
        http1_1.put("405", "Method Not Allowed");
        http1_1.put("406", "Not Acceptable");
        http1_1.put("407", "Proxy Authentication Required");
        http1_1.put("408", "Request Time-out");
        http1_1.put("409", "Conflict");
        http1_1.put("410", "Gone");
        http1_1.put("411", "Length Required");
        http1_1.put("412", "Precondition Failed");
        http1_1.put("413", "Request Entity Too Large");
        http1_1.put("414", "Request-URI Too Large");
        http1_1.put("415", "Unsupported Media Type");
        http1_1.put("416", "Requested range not satisfiable");
        http1_1.put("417", "Expectation Failed");
        http1_1.put("504", "Gateway Time-out");
        http1_1.put("505", "HTTP Version not supported");
        FORMAT_RFC1123 = new SimpleDateFormat(PATTERN_RFC1123, Locale.US);
        TZ_GMT = TimeZone.getTimeZone("GMT");
        CAL_GMT = Calendar.getInstance(TZ_GMT, Locale.US);
        RFC1123_FORMATTER = DateTimeFormatter.ofPattern(PATTERN_RFC1123.replace("yyyy", "uuuu")).withLocale(Locale.US).withZone(ZoneOffset.UTC);
        FORMATS_HTTP = new SimpleDateFormat[]{HeaderFramework.newRfc1123Format(), HeaderFramework.newRfc1036Format(), GenericFormatter.newAnsicFormat()};
        lastRFC1123long = 0L;
        lastRFC1123string = "";
        CAL_GMT.setTimeInMillis(0L);
        for (SimpleDateFormat format : FORMATS_HTTP) {
            format.setTimeZone(TZ_GMT);
            format.set2DigitYearStart(CAL_GMT.getTime());
        }
        FORMAT_RFC1123.setTimeZone(TZ_GMT);
        FORMAT_RFC1123.set2DigitYearStart(CAL_GMT.getTime());
    }
}

