/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ClientIdentification {
    public static final int clientTimeoutInit = 10000;
    public static final int minimumLocalDeltaInit = 10;
    public static final int minimumGlobalDeltaInit = 250;
    private static final String[] browserAgents = new String[]{"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.95 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:22.0) Gecko/20100101 Firefox/22.0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.95 Safari/537.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/536.30.1 (KHTML, like Gecko) Version/6.0.5 Safari/536.30.1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.71 Safari/537.36", "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.95 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.95 Safari/537.36", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:22.0) Gecko/20100101 Firefox/22.0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:23.0) Gecko/20100101 Firefox/23.0", "Mozilla/5.0 (Windows NT 5.1; rv:22.0) Gecko/20100101 Firefox/22.0", "Mozilla/5.0 (Windows NT 6.1; rv:22.0) Gecko/20100101 Firefox/22.0", "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:21.0) Gecko/20100101 Firefox/21.0"};
    private static final Random random = new Random(System.currentTimeMillis());
    private static Map<String, Agent> agents = new ConcurrentHashMap<String, Agent>();
    public static final String yacyInternetCrawlerAgentName = "YaCy Internet (cautious)";
    public static Agent yacyInternetCrawlerAgent = null;
    public static final String yacyIntranetCrawlerAgentName = "YaCy Intranet (greedy)";
    public static Agent yacyIntranetCrawlerAgent = null;
    public static final String googleAgentName = "Googlebot";
    public static final Agent googleAgentAgent = new Agent("Googlebot/2.1 (+http://www.google.com/bot.html)", new String[]{"Googlebot", "Googlebot-Mobile"}, 25, 10000);
    public static final String yacyProxyAgentName = "YaCyProxy";
    public static final Agent yacyProxyAgent = new Agent("yacy - this is a proxy access through YaCy from a browser, not a robot (the yacy bot user agent is 'yacybot')", new String[]{"yacy"}, 250, 10000);
    public static final String customAgentName = "Custom Agent";
    public static final String browserAgentName = "Random Browser";
    public static Agent browserAgent;
    public static final String yacySystem;

    public static void generateYaCyBot(String addinfo) {
        String agentString = "yacybot (" + addinfo + "; " + yacySystem + ") http://yacy.net/bot.html";
        yacyInternetCrawlerAgent = new Agent(agentString, new String[]{"yacybot"}, 250, 10000);
        yacyIntranetCrawlerAgent = new Agent(agentString, new String[]{"yacybot"}, 10, 10000);
        agents.put(yacyInternetCrawlerAgentName, yacyInternetCrawlerAgent);
        agents.put(yacyIntranetCrawlerAgentName, yacyIntranetCrawlerAgent);
    }

    public static void generateCustomBot(String name, String string, int minimumdelta, int clienttimeout) {
        if (name.toLowerCase().indexOf("yacy") >= 0 || string.toLowerCase().indexOf("yacy") >= 0) {
            return;
        }
        String agentString = string.replace("$$SYSTEM$$", yacySystem.replace("java", "O"));
        agents.put(customAgentName, new Agent(agentString, new String[]{name}, minimumdelta, clienttimeout));
    }

    public static Agent getAgent(String agentName) {
        if (agentName == null || agentName.length() == 0) {
            return yacyInternetCrawlerAgent;
        }
        Agent agent = agents.get(agentName);
        return agent == null ? yacyInternetCrawlerAgent : agent;
    }

    public static String generateLocation() {
        Object loc = System.getProperty("user.timezone", "nowhere");
        int p = ((String)loc).indexOf(47);
        if (p > 0) {
            loc = ((String)loc).substring(0, p);
        }
        loc = (String)loc + "/" + System.getProperty("user.language", "dumb");
        return loc;
    }

    public static String parseLocationInUserAgent(String userAgent) {
        int firstClosedParenthesis;
        int firstOpenParenthesis = userAgent.indexOf(40);
        int lastSemicolon = userAgent.lastIndexOf(59);
        String location = lastSemicolon < (firstClosedParenthesis = userAgent.indexOf(41)) ? (firstClosedParenthesis > 0 ? userAgent.substring(lastSemicolon + 1, firstClosedParenthesis).trim() : userAgent.substring(lastSemicolon + 1).trim()) : (firstOpenParenthesis < userAgent.length() ? (firstClosedParenthesis > firstOpenParenthesis ? userAgent.substring(firstOpenParenthesis + 1, firstClosedParenthesis).trim() : userAgent.substring(firstOpenParenthesis + 1).trim()) : "");
        return location;
    }

    static {
        yacySystem = System.getProperty("os.arch", "no-os-arch") + " " + System.getProperty("os.name", "no-os-name") + " " + System.getProperty("os.version", "no-os-version") + "; java " + System.getProperty("java.version", "no-java-version") + "; " + ClientIdentification.generateLocation();
        ClientIdentification.generateYaCyBot("new");
        browserAgent = new Agent(browserAgents[random.nextInt(browserAgents.length)], new String[]{"Mozilla"}, 10, 10000);
        agents.put(googleAgentName, googleAgentAgent);
        agents.put(browserAgentName, browserAgent);
        agents.put(yacyProxyAgentName, yacyProxyAgent);
    }

    public static class Agent {
        public final String userAgent;
        public final String[] robotIDs;
        public final int minimumDelta;
        public final int clientTimeout;

        public Agent(String userAgent, String[] robotIDs, int minimumDelta, int clientTimeout) {
            this.userAgent = userAgent;
            this.robotIDs = robotIDs;
            this.minimumDelta = minimumDelta;
            this.clientTimeout = clientTimeout;
        }
    }
}

