/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassProvider {
    public static Class<?> load(String classname, File jarfile) {
        Class<?> c;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        if (c == null) {
            Object path = jarfile.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = ((String)path).replace(File.separatorChar, '/');
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            try {
                URL[] urls2 = new URL[]{new URL("file", "", (String)path)};
                URLClassLoader cl2 = new URLClassLoader(urls2);
                c = cl2.loadClass(classname);
                cl2.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return c;
    }

    public static Method getStaticMethod(Class<?> c, String methodName, Class<?>[] args) {
        if (c == null) {
            return null;
        }
        try {
            return c.getMethod(methodName, args);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

