/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.lod.vocabulary;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.geo.Locations;
import net.yacy.cora.lod.vocabulary.LocationTaggingEntry;
import net.yacy.cora.lod.vocabulary.SynonymTaggingEntry;
import net.yacy.cora.lod.vocabulary.TaggingEntry;
import net.yacy.cora.lod.vocabulary.TaggingEntryWithObjectLink;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;

public class Tagging {
    public static final String DEFAULT_NAMESPACE = "http://yacy.net/autotagging#";
    public static final String DEFAULT_PREFIX = "tags";
    public static final boolean DEFAULT_MATCH_FROM_LINKED_DATA = false;
    private final String navigatorName;
    private final Map<String, String> synonym2term;
    private final Map<String, TaggingEntry> term2entries;
    private File propFile;
    private boolean isFacet;
    private boolean matchFromLinkedData;
    private String predicate;
    private String namespace;
    private String objectspace;
    private static final Pattern PATTERN_SPACESLASHPLUS = Pattern.compile(" (/|\\+)");
    private static final Pattern PATTERN_SLASHPLUS = Pattern.compile("/|\\+");
    private static final Pattern PATTERN_SPACESPACE = Pattern.compile("  ");
    private static final Pattern PATTERN_AE = Pattern.compile("\u00e4");
    private static final Pattern PATTERN_OE = Pattern.compile("\u00f6");
    private static final Pattern PATTERN_UE = Pattern.compile("\u00fc");
    private static final Pattern PATTERN_SZ = Pattern.compile("\u00df");

    public Tagging(String name) {
        this.navigatorName = name;
        this.synonym2term = new ConcurrentHashMap<String, String>();
        this.term2entries = new ConcurrentHashMap<String, TaggingEntry>();
        this.namespace = DEFAULT_NAMESPACE;
        this.predicate = this.namespace + name;
        this.objectspace = null;
        this.propFile = null;
        this.isFacet = true;
        this.matchFromLinkedData = false;
    }

    public Tagging(String name, File propFile) throws IOException {
        this(name);
        this.propFile = propFile;
        this.init();
    }

    public Tagging(String name, File propFile, String objectspace, Map<String, SOTuple> table) throws IOException {
        this(name);
        this.propFile = propFile;
        this.objectspace = objectspace;
        if (propFile == null) {
            this.synonym2term.clear();
            this.term2entries.clear();
            this.namespace = DEFAULT_NAMESPACE;
            this.predicate = this.namespace + this.navigatorName;
            for (Map.Entry<String, SOTuple> e : table.entrySet()) {
                String term;
                if (e.getValue().getSynonymsCSV() == null || e.getValue().getSynonymsCSV().isEmpty()) {
                    term = this.normalizeKey(e.getKey());
                    String v = Tagging.normalizeTerm(e.getKey());
                    this.synonym2term.put(v, term);
                    if (e.getValue().getObjectlink() != null && e.getValue().getObjectlink().length() > 0) {
                        this.term2entries.put(term, new TaggingEntryWithObjectLink(v, e.getValue().getObjectlink()));
                        continue;
                    }
                    this.term2entries.put(term, new SynonymTaggingEntry(v));
                    continue;
                }
                term = this.normalizeKey(e.getKey());
                String[] tags = e.getValue().getSynonymsList();
                HashSet<String> synonyms = new HashSet<String>();
                synonyms.add(term);
                for (String synonym : tags) {
                    if (synonym.isEmpty()) continue;
                    synonyms.add(synonym);
                    synonym = Tagging.normalizeTerm(synonym);
                    if (synonym.isEmpty()) continue;
                    synonyms.add(synonym);
                    this.synonym2term.put(synonym, term);
                    this.term2entries.put(term, new SynonymTaggingEntry(synonym));
                }
                String synonym = Tagging.normalizeTerm(term);
                this.synonym2term.put(synonym, term);
                if (e.getValue().getObjectlink() != null && e.getValue().getObjectlink().length() > 0) {
                    this.term2entries.put(term, new TaggingEntryWithObjectLink(synonym, e.getValue().getObjectlink()));
                } else {
                    this.term2entries.put(term, new SynonymTaggingEntry(synonym));
                }
                synonyms.add(synonym);
            }
        } else {
            try (FileOutputStream outStream = new FileOutputStream(propFile);
                 BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8.name()));){
                if (objectspace != null && objectspace.length() > 0) {
                    w.write("#objectspace:" + objectspace + "\n");
                }
                for (Map.Entry<String, SOTuple> e : table.entrySet()) {
                    String s = e.getValue() == null ? "" : e.getValue().getSynonymsCSV();
                    String o = e.getValue() == null ? "" : e.getValue().getObjectlink();
                    w.write(e.getKey() + (String)(s == null || s.isEmpty() ? "" : ":" + e.getValue().getSynonymsCSV()) + (String)(o == null || o.isEmpty() || o.equals(objectspace + e.getKey()) ? "" : "#" + o) + "\n");
                }
            }
            this.init();
        }
    }

    public Tagging(String name, Locations location) {
        this(name);
        Set<String> locNames = location.locationNames();
        for (String loc : locNames) {
            String syn = Tagging.normalizeTerm(loc);
            this.synonym2term.put(syn, loc);
            TreeSet<GeoLocation> geo = location.find(loc, true);
            if (!geo.isEmpty()) {
                GeoLocation g = geo.iterator().next();
                this.term2entries.put(loc, new LocationTaggingEntry(syn, g));
                continue;
            }
            this.term2entries.put(loc, new SynonymTaggingEntry(syn));
        }
    }

    private void init() throws IOException {
        if (this.propFile == null) {
            return;
        }
        this.synonym2term.clear();
        this.term2entries.clear();
        this.namespace = DEFAULT_NAMESPACE;
        this.predicate = this.namespace + this.navigatorName;
        this.objectspace = null;
        ConcurrentLog.info("Tagging", "Started Vocabulary Initialization for " + this.propFile);
        long start = System.currentTimeMillis();
        long count = 0L;
        BlockingQueue<String> list2 = Files.concurentLineReader(this.propFile);
        try {
            String line;
            while ((line = list2.take()) != "__@POISON__") {
                String v;
                String term;
                String[] pl;
                ++count;
                int p = (line = line.trim()).indexOf(35);
                if (p >= 0) {
                    String comment = line.substring(p + 1).trim();
                    if (comment.startsWith("namespace:")) {
                        this.namespace = comment.substring(10).trim();
                        if (!this.namespace.endsWith("/") && !this.namespace.endsWith("#") && this.namespace.length() > 0) {
                            this.namespace = this.namespace + "#";
                        }
                        this.predicate = this.namespace + this.navigatorName;
                        continue;
                    }
                    if (comment.startsWith("objectspace:")) {
                        this.objectspace = comment.substring(12).trim();
                        if (this.objectspace.endsWith("/") || this.objectspace.endsWith("#") || this.objectspace.length() <= 0) continue;
                        this.objectspace = this.objectspace + "#";
                        continue;
                    }
                }
                if ((pl = Tagging.parseLine(line)) == null) continue;
                if (pl[1] == null) {
                    term = this.normalizeKey(pl[0]);
                    v = Tagging.normalizeTerm(pl[0]);
                    this.synonym2term.put(v, term);
                    if (pl[2] != null && pl[2].length() > 0) {
                        this.term2entries.put(term, new TaggingEntryWithObjectLink(v, pl[2]));
                        continue;
                    }
                    this.term2entries.put(term, new SynonymTaggingEntry(v));
                    continue;
                }
                term = this.normalizeKey(pl[0]);
                v = pl[1];
                String[] tags = CommonPattern.COMMA.split(v);
                HashSet<String> synonyms = new HashSet<String>();
                synonyms.add(term);
                for (String synonym : tags) {
                    if (synonym.isEmpty()) continue;
                    synonyms.add(synonym);
                    synonym = Tagging.normalizeTerm(synonym);
                    if (synonym.isEmpty()) continue;
                    synonyms.add(synonym);
                    this.synonym2term.put(synonym, term);
                    this.term2entries.put(term, new SynonymTaggingEntry(synonym));
                }
                String synonym = Tagging.normalizeTerm(term);
                this.synonym2term.put(synonym, term);
                if (pl[2] != null && pl[2].length() > 0) {
                    this.term2entries.put(term, new TaggingEntryWithObjectLink(synonym, pl[2]));
                } else {
                    this.term2entries.put(term, new SynonymTaggingEntry(synonym));
                }
                synonyms.add(synonym);
            }
        }
        catch (InterruptedException pl) {
            // empty catch block
        }
        long time = Math.max(1L, System.currentTimeMillis() - start);
        ConcurrentLog.info("Tagging", "Finished Vocabulary Initialization for " + this.propFile + "; " + count + " lines; " + time + " milliseconds; " + 1000L * count / time + " lines / second");
    }

    public boolean isFacet() {
        return this.isFacet;
    }

    public void setFacet(boolean isFacet) {
        this.isFacet = isFacet;
    }

    public boolean isMatchFromLinkedData() {
        return this.matchFromLinkedData;
    }

    public void setMatchFromLinkedData(boolean facetFromLinkedData) {
        this.matchFromLinkedData = facetFromLinkedData;
    }

    public int size() {
        return this.term2entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String term, String synonyms, String objectlink) throws IOException {
        if (this.propFile == null) {
            return;
        }
        Tagging tagging = this;
        synchronized (tagging) {
            TempFile tmp = new TempFile();
            BlockingQueue<String> list2 = Files.concurentLineReader(this.propFile);
            boolean written = false;
            try {
                String line;
                while ((line = list2.take()) != "__@POISON__") {
                    String[] pl = Tagging.parseLine(line);
                    if (pl == null) continue;
                    if (pl[0].equals(term)) {
                        tmp.writer.write(term + (String)(synonyms == null || synonyms.isEmpty() ? "" : ":" + synonyms) + (String)(objectlink == null || objectlink.isEmpty() || objectlink.equals(this.objectspace + term) ? "" : "#" + objectlink) + "\n");
                        written = true;
                        continue;
                    }
                    tmp.writer.write(pl[0] + (String)(pl[1] == null || pl[1].isEmpty() ? "" : ":" + pl[1]) + (String)(pl[2] == null || pl[2].isEmpty() || pl[2].equals(this.objectspace + pl[0]) ? "" : "#" + pl[2]) + "\n");
                }
                if (!written) {
                    tmp.writer.write(term + (String)(synonyms == null || synonyms.isEmpty() ? "" : ":" + synonyms) + (String)(objectlink == null || objectlink.isEmpty() || objectlink.equals(this.objectspace + term) ? "" : "#" + objectlink) + "\n");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tmp.writer.close();
            this.propFile.delete();
            tmp.file.renameTo(this.propFile);
            this.init();
        }
    }

    public void delete(String term) throws IOException {
        if (this.propFile == null) {
            return;
        }
        TempFile tmp = new TempFile();
        BlockingQueue<String> list2 = Files.concurentLineReader(this.propFile);
        try {
            String line;
            while ((line = list2.take()) != "__@POISON__") {
                String[] pl = Tagging.parseLine(line);
                if (pl == null || pl[0].equals(term)) continue;
                tmp.writer.write(pl[0] + (String)(pl[1] == null || pl[1].isEmpty() ? "" : ":" + pl[1]) + (String)(pl[2] == null || pl[2].isEmpty() || pl[2].equals(this.objectspace + pl[0]) ? "" : "#" + pl[2]) + "\n");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tmp.writer.close();
        this.propFile.delete();
        tmp.file.renameTo(this.propFile);
        this.init();
    }

    public void clear() throws IOException {
        if (this.propFile == null) {
            return;
        }
        TempFile tmp = new TempFile();
        tmp.writer.close();
        this.propFile.delete();
        tmp.file.renameTo(this.propFile);
        this.init();
    }

    public void setObjectspace(String os) throws IOException {
        if (this.propFile == null) {
            return;
        }
        if (os == null || os.length() == 0 || this.objectspace != null && this.objectspace.equals(os)) {
            return;
        }
        this.objectspace = os;
        TempFile tmp = new TempFile();
        BlockingQueue<String> list2 = Files.concurentLineReader(this.propFile);
        try {
            String line;
            while ((line = list2.take()) != "__@POISON__") {
                String[] pl = Tagging.parseLine(line);
                if (pl == null) continue;
                tmp.writer.write(pl[0] + (String)(pl[1] == null || pl[1].isEmpty() ? "" : ":" + pl[1]) + (String)(pl[2] == null || pl[2].isEmpty() || pl[2].equals(this.objectspace + pl[0]) ? "" : "#" + pl[2]) + "\n");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tmp.writer.close();
        this.propFile.delete();
        tmp.file.renameTo(this.propFile);
        this.init();
    }

    private Map<String, Set<String>> reconstructionSets() {
        Set<String> s;
        TreeMap<String, Set<String>> r = new TreeMap<String, Set<String>>();
        for (Map.Entry<String, TaggingEntry> entry2 : this.term2entries.entrySet()) {
            s = (TreeSet)r.get(entry2.getKey());
            if (s == null) {
                s = new TreeSet();
                r.put(entry2.getKey(), s);
            }
            if (entry2.getValue() == null || entry2.getValue().getSynonym() == null || entry2.getValue().getSynonym().length() == 0) continue;
            s.add(entry2.getValue().getSynonym());
        }
        for (Map.Entry<String, Object> entry3 : this.synonym2term.entrySet()) {
            s = (Set)r.get(entry3.getValue());
            if (s == null) {
                s = new TreeSet();
                r.put((String)entry3.getValue(), s);
            }
            s.add(entry3.getKey());
        }
        return r;
    }

    private Map<String, SOTuple> reconstructionLists() {
        Map<String, Set<String>> r = this.reconstructionSets();
        TreeMap<String, SOTuple> map = new TreeMap<String, SOTuple>();
        for (Map.Entry<String, Set<String>> e : r.entrySet()) {
            TaggingEntry entry2 = this.term2entries.get(e.getKey());
            String objectLink = null;
            if (entry2 != null) {
                objectLink = entry2.getObjectLink();
            }
            map.put(e.getKey(), new SOTuple(e.getValue().toArray(new String[e.getValue().size()]), objectLink == null ? "" : objectLink));
        }
        return map;
    }

    public String getObjectlink(String term) {
        TaggingEntry entry2 = this.term2entries.get(term);
        if (entry2 != null) {
            return entry2.getObjectLink();
        }
        return null;
    }

    public Map<String, SOTuple> list() {
        BlockingQueue<String> list2;
        if (this.propFile == null) {
            return this.reconstructionLists();
        }
        LinkedHashMap<String, SOTuple> map = new LinkedHashMap<String, SOTuple>();
        try {
            list2 = Files.concurentLineReader(this.propFile);
        }
        catch (IOException e1) {
            return map;
        }
        try {
            String line;
            while ((line = list2.take()) != "__@POISON__") {
                String[] pl = Tagging.parseLine(line);
                if (pl == null) continue;
                map.put(pl[0], new SOTuple(pl[1] == null || pl[1].isEmpty() ? "" : pl[1], pl[2] == null || pl[2].isEmpty() || pl[2].equals(this.objectspace + pl[0]) ? "" : pl[2]));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return map;
    }

    private static final String[] parseLine(String line) {
        line = line.trim();
        int p = line.indexOf(35);
        String c = "";
        if (p >= 0) {
            c = line.substring(p + 1);
            line = line.substring(0, p).trim();
        }
        if (line.isEmpty()) {
            return null;
        }
        p = line.indexOf(58);
        if (p < 0) {
            p = line.indexOf(61);
        }
        if (p < 0) {
            p = line.indexOf(9);
        }
        if (p < 0) {
            return new String[]{line, null, c};
        }
        return new String[]{line.substring(0, p), line.substring(p + 1), c};
    }

    public String getPredicate() {
        return this.predicate;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObjectspace() {
        return this.objectspace;
    }

    private final String normalizeKey(String k) {
        k = k.trim();
        k = PATTERN_SPACESLASHPLUS.matcher(k).replaceAll(", ");
        k = PATTERN_SLASHPLUS.matcher(k).replaceAll(",");
        k = PATTERN_SPACESPACE.matcher(k).replaceAll(" ");
        return k;
    }

    public String getName() {
        return this.navigatorName;
    }

    public File getFile() {
        return this.propFile;
    }

    public Metatag getMetatagFromSynonym(String word) {
        String printname = this.synonym2term.get(word);
        if (printname == null) {
            return null;
        }
        return new Metatag(printname);
    }

    public Metatag getMetatagFromTerm(String term) {
        TaggingEntry entry2 = this.term2entries.get(term);
        if (entry2 == null) {
            return null;
        }
        return new Metatag(term);
    }

    public Metatag buildMetatagFromTerm(String word) {
        return new Metatag(word);
    }

    public Set<String> tags() {
        return this.synonym2term.keySet();
    }

    public boolean equals(Object m) {
        Tagging m0 = (Tagging)m;
        return this.navigatorName.equals(m0.navigatorName);
    }

    public int hashCode() {
        return this.navigatorName.hashCode();
    }

    public String toString() {
        return this.term2entries.toString();
    }

    public static final String normalizeTerm(String term) {
        term = term.trim().toLowerCase();
        term = PATTERN_AE.matcher(term).replaceAll("ae");
        term = PATTERN_OE.matcher(term).replaceAll("oe");
        term = PATTERN_UE.matcher(term).replaceAll("ue");
        term = PATTERN_SZ.matcher(term).replaceAll("ss");
        term = CommonPattern.COMMA.matcher(term).replaceAll(" ");
        return term;
    }

    public static final String encodePrintname(String printname) {
        return CommonPattern.SPACE.matcher(printname).replaceAll("_");
    }

    public static final String decodeMaskname(String maskname) {
        return CommonPattern.UNDERSCORE.matcher(maskname).replaceAll(" ");
    }

    public static String cleanTagFromAutotagging(String tagString) {
        if (tagString == null || tagString.isEmpty()) {
            return "";
        }
        String[] tags = CommonPattern.SPACE.split(tagString);
        StringBuilder sb = new StringBuilder(tagString.length());
        for (String tag : tags) {
            if (tag.length() <= 0) continue;
            sb.append(tag).append(' ');
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static class SOTuple {
        private final String synonyms;
        private final String objectlink;

        public SOTuple(String synonyms, String objectlink) {
            this.synonyms = synonyms;
            this.objectlink = objectlink;
        }

        private SOTuple(String[] synonyms, String objectlink) {
            StringBuilder sb = new StringBuilder(synonyms.length * 10);
            for (String s : synonyms) {
                sb.append(',').append(s);
            }
            this.synonyms = sb.substring(1);
            this.objectlink = objectlink;
        }

        public String getSynonymsCSV() {
            return this.synonyms;
        }

        public String[] getSynonymsList() {
            return CommonPattern.COMMA.split(this.synonyms);
        }

        public String getObjectlink() {
            return this.objectlink;
        }
    }

    private class TempFile {
        public File file;
        public BufferedWriter writer;

        public TempFile() throws IOException {
            if (Tagging.this.propFile == null) {
                throw new IOException("propfile = null");
            }
            this.file = new File(Tagging.this.propFile.getAbsolutePath() + ".tmp");
            this.writer = new BufferedWriter(new FileWriter(this.file));
            if (Tagging.this.namespace != null && !Tagging.this.namespace.equals(Tagging.DEFAULT_NAMESPACE)) {
                this.writer.write("#namespace:" + Tagging.this.namespace + "\n");
            }
            if (Tagging.this.objectspace != null && Tagging.this.objectspace.length() > 0) {
                this.writer.write("#objectspace:" + Tagging.this.objectspace + "\n");
            }
        }
    }

    public class Metatag {
        private final String object;

        private Metatag(String object) {
            this.object = object;
        }

        public String getVocabularyName() {
            return Tagging.this.navigatorName;
        }

        public String getPredicate() {
            return Tagging.this.predicate;
        }

        public String getObject() {
            return this.object;
        }

        public String toString() {
            return Tagging.this.navigatorName + ":" + Tagging.encodePrintname(this.object);
        }

        public boolean equals(Object m) {
            Metatag m0 = (Metatag)m;
            return Tagging.this.navigatorName.equals(m0.getVocabularyName()) && this.object.equals(m0.object);
        }

        public int hashCode() {
            return Tagging.this.navigatorName.hashCode() + this.object.hashCode();
        }
    }
}

