/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import java.util.ArrayList;
import java.util.List;
import net.yacy.cora.federate.solr.logic.AbstractTerm;
import net.yacy.cora.federate.solr.logic.Operations;
import net.yacy.cora.federate.solr.logic.Term;

public abstract class AbstractOperations
extends AbstractTerm
implements Operations {
    protected final String operandName;
    protected final List<Term> terms;

    public AbstractOperations(String operandName) {
        this.operandName = operandName;
        this.terms = new ArrayList<Term>();
    }

    public int hashCode() {
        int h = this.operandName.hashCode();
        for (Term t : this.terms) {
            h += t.hashCode();
        }
        return h;
    }

    @Override
    public void addOperand(Term term) {
        if (!term.toString().isEmpty()) {
            this.terms.add(term);
        }
    }

    @Override
    public List<Term> getOperands() {
        return this.terms;
    }

    @Override
    public int weight() {
        return this.terms.size() * 2;
    }

    @Override
    public boolean isBinary() {
        return this.terms.size() == 2;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return this.isBinary();
    }

    @Override
    public boolean isDistributive() {
        return this.isBinary();
    }

    @Override
    public Term lightestRewrite() {
        return this;
    }

    @Override
    public String toString() {
        if (this.terms.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.terms.size() == 1) {
            sb.append(this.terms.iterator().next().toString());
        } else {
            sb.append('(');
            for (Term term : this.terms) {
                if (sb.length() > 1) {
                    sb.append(' ').append(this.operandName).append(' ');
                }
                sb.append(term.toString());
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

