/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.util.ConcurrentLog;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.MultiMapSolrParams;

public class SchemaConfiguration
extends Configuration
implements Serializable {
    private static final long serialVersionUID = -5961730809008841258L;
    private static final ConcurrentLog log = new ConcurrentLog(SchemaConfiguration.class.getName());

    public SchemaConfiguration() {
    }

    public SchemaConfiguration(File file) throws IOException {
        super(file);
    }

    public void fill(SchemaConfiguration other, boolean defaultActivated) {
        Iterator<Configuration.Entry> i = other.entryIterator();
        Configuration.Entry enew = null;
        while (i.hasNext()) {
            Configuration.Entry e = i.next();
            if (this.contains(e.key()) || this.containsDisabled(e.key())) continue;
            enew = new Configuration.Entry(e.key(), e.getValue(), defaultActivated && e.enabled());
            enew.setComment(e.getComment());
            this.put(e.key(), enew);
        }
        if (enew != null) {
            try {
                this.commit();
            }
            catch (IOException ex) {
                log.warn(ex);
            }
        }
    }

    public SolrInputDocument toSolrInputDocument(SolrDocument doc, Set<String> omitFields) {
        SolrInputDocument sid = new SolrInputDocument(new String[0]);
        for (String name : doc.getFieldNames()) {
            if (!this.contains(name) || omitFields != null && omitFields.contains(name)) continue;
            sid.addField(name, doc.getFieldValue(name));
        }
        return sid;
    }

    public SolrInputDocument toSolrInputDocument(MultiMapSolrParams params) {
        SolrInputDocument sid = new SolrInputDocument(new String[0]);
        for (String name : params.getMap().keySet()) {
            if (!this.contains(name)) continue;
            sid.addField(name, (Object)params.getParams(name));
        }
        return sid;
    }

    public SolrDocument toSolrDocument(SolrInputDocument doc, Set<String> omitFields) {
        SolrDocument sd = new SolrDocument();
        for (SolrInputField field : doc) {
            if (!this.contains(field.getName()) || omitFields != null && omitFields.contains(field.getName())) continue;
            sd.setField(field.getName(), field.getValue());
        }
        return sd;
    }

    public boolean contains(SchemaDeclaration field) {
        return this.contains(field.getSolrFieldName());
    }

    public void remove(SolrInputDocument doc, SchemaDeclaration key) {
        key.remove(doc);
    }

    public void remove(SolrInputDocument doc, String key) {
        doc.removeField(key);
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, String value) {
        assert (!key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || value != null && !value.isEmpty())) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, Date value) {
        assert (!key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || value != null && value.getTime() > 0L)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, Date[] value) {
        assert (key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || value != null && value.length > 0)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, String[] value) {
        assert (key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || value != null && value.length > 0)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, Integer[] value) {
        assert (key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || value != null && value.length > 0)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, List<?> values) {
        assert (key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if ((this.isEmpty() || this.contains(key)) && (!this.lazy || values != null && !values.isEmpty())) {
            key.add(doc, values);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, int value) {
        assert (!key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if (this.isEmpty() || this.contains(key)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, long value) {
        assert (!key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if (this.isEmpty() || this.contains(key)) {
            key.add(doc, value);
        }
    }

    public void add(SolrInputDocument doc, SchemaDeclaration key, boolean value) {
        assert (!key.isMultiValued()) : "key = " + key.getSolrFieldName();
        if (this.isEmpty() || this.contains(key)) {
            key.add(doc, value);
        }
    }
}

