/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.FederateSearchConnector;
import net.yacy.cora.federate.solr.SchemaConfiguration;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.SolrDocument;

public abstract class AbstractFederateSearchConnector
implements FederateSearchConnector {
    private static final ConcurrentLog LOG = new ConcurrentLog(AbstractFederateSearchConnector.class.getName());
    public String instancename;
    protected SchemaConfiguration localcfg;
    public long lastaccesstime = -1L;
    protected String baseurl;

    @Override
    public boolean init(String instance, String cfgFileName) {
        this.instancename = instance;
        File instanceCfgFile = new File(cfgFileName);
        if (instanceCfgFile.exists()) {
            try {
                this.localcfg = new SchemaConfiguration(instanceCfgFile);
            }
            catch (IOException ex) {
                LOG.config("Error reading schema " + cfgFileName + " for connector " + this.instancename);
                return false;
            }
            if (this.localcfg.contains(CollectionSchema.sku) || this.localcfg.contains("_skufieldname")) {
                return true;
            }
            LOG.config("Mandatory mapping for sku or _skufieldname missing in " + cfgFileName + " for connector " + this.instancename);
            return false;
        }
        this.localcfg = null;
        return false;
    }

    @Override
    public void search(final SearchEvent theSearch) {
        Thread job = new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName("heuristic:" + AbstractFederateSearchConnector.this.instancename);
                LOG.info("Send search query to " + AbstractFederateSearchConnector.this.instancename);
                theSearch.oneFeederStarted();
                List<URIMetadataNode> doclist = AbstractFederateSearchConnector.this.query(theSearch.getQuery());
                if (doclist != null) {
                    LOG.info("Got " + doclist.size() + " documents from " + AbstractFederateSearchConnector.this.instancename);
                    HashMap<String, LinkedHashSet<String>> snippets = new HashMap<String, LinkedHashSet<String>>();
                    theSearch.addNodes(doclist, null, snippets, false, AbstractFederateSearchConnector.this.instancename, doclist.size(), true);
                    for (URIMetadataNode doc : doclist) {
                        theSearch.addHeuristic(doc.hash(), AbstractFederateSearchConnector.this.instancename, false);
                    }
                } else {
                    LOG.info("Got no results from " + AbstractFederateSearchConnector.this.instancename);
                }
                theSearch.oneFeederTerminated();
                if (doclist != null && !doclist.isEmpty() && theSearch.addResultsToLocalIndex) {
                    ArrayList<DigestURL> urls2 = new ArrayList<DigestURL>();
                    for (URIMetadataNode doc : doclist) {
                        urls2.add(doc.url());
                    }
                    Switchboard.getSwitchboard().addToCrawler(urls2, false);
                }
            }
        };
        job.start();
    }

    protected URIMetadataNode toYaCySchema(SolrDocument doc) throws MalformedURLException {
        Object urlstr;
        if (this.localcfg.contains("sku")) {
            urlstr = (String)doc.getFieldValue(((Configuration.Entry)this.localcfg.get("sku")).getValue());
        } else {
            urlstr = (String)doc.getFieldValue(((Configuration.Entry)this.localcfg.get("_skufieldname")).getValue());
            if (this.localcfg.contains("_skuprefix")) {
                String skuprefix = ((Configuration.Entry)this.localcfg.get("_skuprefix")).getValue();
                urlstr = skuprefix + (String)urlstr;
            }
        }
        DigestURL url = new DigestURL((String)urlstr);
        URIMetadataNode newdoc = new URIMetadataNode(url);
        Iterator<Configuration.Entry> it = this.localcfg.entryIterator();
        while (it.hasNext()) {
            Configuration.Entry et = it.next();
            String yacyfieldname = et.key();
            String remotefieldname = et.getValue();
            if (remotefieldname == null || remotefieldname.isEmpty() || !Switchboard.getSwitchboard().index.fulltext().getDefaultConfiguration().contains(yacyfieldname)) continue;
            CollectionSchema est = CollectionSchema.valueOf(yacyfieldname);
            if (est.isMultiValued()) {
                if (doc.getFieldValues(remotefieldname) == null) continue;
                newdoc.addField(yacyfieldname, doc.getFieldValues(remotefieldname));
                continue;
            }
            if (doc.getFieldValue(remotefieldname) == null) continue;
            Object val = doc.getFirstValue(remotefieldname);
            try {
                if (est.getType() == SolrType.num_integer && val instanceof String) {
                    newdoc.setField(yacyfieldname, Integer.parseInt((String)val));
                    continue;
                }
                newdoc.setField(yacyfieldname, val);
            }
            catch (Exception ex) {}
        }
        newdoc.addField(CollectionSchema.httpstatus_i.name(), 200);
        return newdoc;
    }
}

