/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

public abstract class ReadingListener
implements SelectionListener {
    private final ByteBuffer byteBuffer;
    private final ReadableByteChannel byteChannel;

    public ReadingListener(ReadableByteChannel byteChannel, ByteBuffer byteBuffer) throws IOException {
        this.byteBuffer = byteBuffer;
        this.byteChannel = byteChannel;
    }

    public ReadingListener(ReadableByteChannel byteChannel, int bufferSize) throws IOException {
        this(byteChannel, ByteBuffer.allocate(bufferSize));
    }

    public ReadingListener(Representation source) throws IOException {
        this(source, IoUtils.BUFFER_SIZE);
    }

    public ReadingListener(Representation source, int bufferSize) throws IOException {
        this(source.getChannel(), bufferSize);
    }

    protected abstract void onContent(ByteBuffer var1);

    protected void onEnd() {
    }

    protected void onError(IOException ioe) {
        Context.getCurrentLogger().log(Level.WARNING, "", ioe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSelected(SelectionRegistration selectionRegistration) throws IOException {
        try {
            ByteBuffer byteBuffer = this.byteBuffer;
            synchronized (byteBuffer) {
                this.byteBuffer.clear();
                int result = this.byteChannel.read(this.byteBuffer);
                if (result > 0) {
                    this.byteBuffer.flip();
                    this.onContent(this.byteBuffer);
                } else if (result == -1) {
                    this.onEnd();
                } else {
                    Context.getCurrentLogger().fine("NIO selection detected with no content available");
                }
            }
        }
        catch (IOException ioe) {
            this.onError(ioe);
        }
    }
}

