/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.ArchiveDB;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Decoder;
import SevenZip.Archive.SevenZip.ExtractFolderInfo;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.FolderOutStream;
import SevenZip.Archive.SevenZip.InStream;
import SevenZip.Archive.SevenZip.MethodID;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.Common.LocalCompressProgressInfo;
import SevenZip.Common.LocalProgress;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class Handler
implements IInArchive {
    public IInStream _inStream;
    public ArchiveDB _database;
    int _numThreads = 1;

    public Handler(File archive) throws IOException {
        this(new MyRandomAccessFile(archive, "r"), 0x400000L);
    }

    public Handler(IInStream stream) throws IOException {
        this(stream, 0x400000L);
    }

    public Handler(IInStream stream, long maxCheckStartPosition) throws IOException {
        InStream archive = new InStream(stream, maxCheckStartPosition);
        this._database = new ArchiveDB(archive);
        this._inStream = stream;
    }

    @Override
    public void Extract(int[] indices, int numItems, int testModeSpec, IArchiveExtractCallback extractCallback) throws IOException {
        boolean allFilesMode;
        boolean testMode = testModeSpec != 0;
        long importantTotalUnPacked = 0L;
        boolean bl = allFilesMode = numItems == -1;
        if (allFilesMode) {
            numItems = this._database.Files.size();
        }
        if (numItems == 0) {
            return;
        }
        Vector<ExtractFolderInfo> extractFolderInfoVector = new Vector<ExtractFolderInfo>();
        for (int ii = 0; ii < numItems; ++ii) {
            int ref2Index = allFilesMode ? ii : indices[ii];
            ArchiveDB database = this._database;
            int fileIndex = ref2Index;
            int folderIndex = database.FileIndexToFolderIndexMap.get(fileIndex);
            if (folderIndex == -1) {
                extractFolderInfoVector.add(new ExtractFolderInfo(fileIndex, -1));
                continue;
            }
            if (extractFolderInfoVector.isEmpty() || folderIndex != ((ExtractFolderInfo)extractFolderInfoVector.lastElement()).FolderIndex) {
                extractFolderInfoVector.add(new ExtractFolderInfo(-1, folderIndex));
                Folder folderInfo = database.Folders.get(folderIndex);
                long unPackSize = folderInfo.GetUnPackSize();
                importantTotalUnPacked += unPackSize;
                ((ExtractFolderInfo)extractFolderInfoVector.lastElement()).UnPackSize = unPackSize;
            }
            ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.lastElement();
            int startIndex = database.FolderStartFileIndex.get(folderIndex);
            for (int index = efi.ExtractStatuses.size(); index <= fileIndex - startIndex; ++index) {
                efi.ExtractStatuses.add(index == fileIndex - startIndex);
            }
        }
        extractCallback.SetTotal(importantTotalUnPacked);
        Decoder decoder = new Decoder(false);
        long currentImportantTotalUnPacked = 0L;
        int i = 0;
        while (i < extractFolderInfoVector.size()) {
            ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.get(i);
            long totalFolderUnPacked = efi.UnPackSize;
            extractCallback.SetCompleted(currentImportantTotalUnPacked);
            int startIndex = efi.FileIndex != -1 ? efi.FileIndex : this._database.FolderStartFileIndex.get(efi.FolderIndex);
            FolderOutStream folderOutStream = new FolderOutStream(this._database, 0, startIndex, efi.ExtractStatuses, extractCallback, testMode);
            int result = 0;
            if (efi.FileIndex == -1) {
                int folderIndex = efi.FolderIndex;
                Folder folderInfo = this._database.Folders.get(folderIndex);
                LocalProgress localProgressSpec = new LocalProgress(extractCallback, false);
                LocalCompressProgressInfo compressProgress = new LocalCompressProgressInfo(localProgressSpec, -1L, currentImportantTotalUnPacked);
                int packStreamIndex = this._database.FolderStartPackStreamIndex.get(folderIndex);
                long folderStartPackPos = this._database.GetFolderStreamPos(folderIndex, 0);
                try {
                    decoder.Decode(this._inStream, folderStartPackPos, this._database.PackSizes, packStreamIndex, folderInfo, folderOutStream, compressProgress);
                    if (result == 1) {
                        folderOutStream.FlushCorrupted(2);
                    } else if (result == -2147467263) {
                        folderOutStream.FlushCorrupted(1);
                    } else if (folderOutStream.IsWritingFinished()) {
                        folderOutStream.FlushCorrupted(2);
                    }
                }
                catch (Exception e) {
                    System.out.println("IOException : " + e);
                    e.printStackTrace();
                    folderOutStream.FlushCorrupted(2);
                }
            }
            ++i;
            currentImportantTotalUnPacked += totalFolderUnPacked;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this._inStream != null) {
            this._inStream.close();
        }
        this._inStream = null;
        this._database.clear();
    }

    @Override
    public int size() {
        return this._database.Files.size();
    }

    private long getPackSize(int index2) {
        long packSize = 0L;
        int folderIndex = this._database.FileIndexToFolderIndexMap.get(index2);
        if (folderIndex != -1 && this._database.FolderStartFileIndex.get(folderIndex) == index2) {
            packSize = this._database.GetFolderFullPackSize(folderIndex);
        }
        return packSize;
    }

    private static int GetUInt32FromMemLE(byte[] p, int off) {
        return p[off] | p[off + 1] << 8 | p[off + 2] << 16 | p[off + 3] << 24;
    }

    private static String GetStringForSizeValue(int value) {
        for (int i = 31; i >= 0; --i) {
            if (1 << i != value) continue;
            return Integer.toString(i);
        }
        StringBuffer result = new StringBuffer();
        if (value % 0x100000 == 0) {
            result.append(value >> 20);
            result.append('m');
        } else if (value % 1024 == 0) {
            result.append(value >> 10);
            result.append('k');
        } else {
            result.append(value);
            result.append('b');
        }
        return result.toString();
    }

    private String getMethods(int index2) {
        int folderIndex = this._database.FileIndexToFolderIndexMap.get(index2);
        if (folderIndex != -1) {
            Folder folderInfo = this._database.Folders.get(folderIndex);
            StringBuffer methodsString = new StringBuffer();
            for (int i = folderInfo.Coders.size() - 1; i >= 0; --i) {
                CoderInfo coderInfo = folderInfo.Coders.get(i);
                if (methodsString.length() > 0) {
                    methodsString.append(' ');
                }
                for (int j = 0; j < coderInfo.AltCoders.size(); ++j) {
                    if (j > 0) {
                        methodsString.append('|');
                    }
                    AltCoderInfo altCoderInfo = (AltCoderInfo)coderInfo.AltCoders.get(j);
                    if (altCoderInfo.MethodID.getName() == null) continue;
                    methodsString.append(altCoderInfo.MethodID.getName());
                    if (!altCoderInfo.MethodID.equals(MethodID.k_LZMA) || altCoderInfo.Properties.size() < 5) continue;
                    methodsString.append(':');
                    int dicSize = Handler.GetUInt32FromMemLE(altCoderInfo.Properties.toByteArray(), 1);
                    methodsString.append(Handler.GetStringForSizeValue(dicSize));
                }
            }
            return methodsString.toString();
        }
        return new String();
    }

    @Override
    public SevenZipEntry getEntry(int index) {
        FileItem item = this._database.Files.get(index);
        return new SevenZipEntry(item.name, this.getPackSize(index), item.UnPackSize, item.IsFileCRCDefined ? (long)item.FileCRC & 0xFFFFFFFFL : -1L, item.LastWriteTime, item.IsStartPosDefined ? item.StartPos : -1L, item.IsDirectory, item.Attributes, this.getMethods(index));
    }
}

