/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.IntVector;
import Common.LimitedSequentialInStream;
import Common.LockedInStream;
import Common.LockedSequentialInStreamImp;
import Common.LongVector;
import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.Common.CoderStreamsInfo;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.BindInfoEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.IInStream;
import java.io.IOException;
import java.util.Vector;

public class Folder {
    public Vector<CoderInfo> Coders = new Vector();
    public Vector<BindPair> BindPairs = new Vector();
    public IntVector PackStreams = new IntVector();
    public LongVector UnPackSizes = new LongVector();
    int UnPackCRC;
    boolean UnPackCRCDefined = false;

    Folder() {
    }

    public long GetUnPackSize() throws IOException {
        if (this.UnPackSizes.isEmpty()) {
            return 0L;
        }
        for (int i = this.UnPackSizes.size() - 1; i >= 0; --i) {
            if (this.FindBindPairForOutStream(i) >= 0) continue;
            return this.UnPackSizes.get(i);
        }
        throw new IOException("1");
    }

    public int FindBindPairForInStream(int inStreamIndex) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (this.BindPairs.get((int)i).InIndex != inStreamIndex) continue;
            return i;
        }
        return -1;
    }

    public int FindBindPairForOutStream(int outStreamIndex) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (this.BindPairs.get((int)i).OutIndex != outStreamIndex) continue;
            return i;
        }
        return -1;
    }

    public int FindPackStreamArrayIndex(int inStreamIndex) {
        for (int i = 0; i < this.PackStreams.size(); ++i) {
            if (this.PackStreams.get(i) != inStreamIndex) continue;
            return i;
        }
        return -1;
    }

    public int GetNumOutStreams() {
        int result = 0;
        for (int i = 0; i < this.Coders.size(); ++i) {
            result += this.Coders.get((int)i).NumOutStreams;
        }
        return result;
    }

    public Vector getInStreams(IInStream inStream, long startPos, LongVector packSizes, int packSizesOffset) {
        Vector<LimitedSequentialInStream> inStreams = new Vector<LimitedSequentialInStream>(this.PackStreams.size());
        LockedInStream lockedInStream = new LockedInStream(inStream);
        for (int j = 0; j < this.PackStreams.size(); ++j) {
            inStreams.add(new LimitedSequentialInStream(new LockedSequentialInStreamImp(lockedInStream, startPos), packSizes.get(j + packSizesOffset)));
            startPos += packSizes.get(j + packSizesOffset);
        }
        return inStreams;
    }

    public BindInfoEx toBindInfoEx() {
        int i;
        BindInfoEx bindInfo = new BindInfoEx();
        for (int i2 = 0; i2 < this.BindPairs.size(); ++i2) {
            BindPair bindPair = new BindPair();
            bindPair.InIndex = this.BindPairs.get((int)i2).InIndex;
            bindPair.OutIndex = this.BindPairs.get((int)i2).OutIndex;
            bindInfo.BindPairs.add(bindPair);
        }
        int outStreamIndex = 0;
        for (i = 0; i < this.Coders.size(); ++i) {
            CoderStreamsInfo coderStreamsInfo = new CoderStreamsInfo();
            CoderInfo coderInfo = this.Coders.get(i);
            coderStreamsInfo.NumInStreams = coderInfo.NumInStreams;
            coderStreamsInfo.NumOutStreams = coderInfo.NumOutStreams;
            bindInfo.Coders.add(coderStreamsInfo);
            AltCoderInfo altCoderInfo = (AltCoderInfo)coderInfo.AltCoders.firstElement();
            bindInfo.CoderMethodIDs.add(altCoderInfo.MethodID);
            int j = 0;
            while (j < coderStreamsInfo.NumOutStreams) {
                if (this.FindBindPairForOutStream(outStreamIndex) < 0) {
                    bindInfo.OutStreams.add(outStreamIndex);
                }
                ++j;
                ++outStreamIndex;
            }
        }
        for (i = 0; i < this.PackStreams.size(); ++i) {
            bindInfo.InStreams.add(this.PackStreams.get(i));
        }
        return bindInfo;
    }
}

