/*
 * Decompiled with CFR 0.152.
 */
package Common;

import java.io.IOException;
import java.io.InputStream;

public class LimitedSequentialInStream
extends InputStream {
    final InputStream _stream;
    final long _size;
    long _pos;
    boolean _wasFinished;

    public LimitedSequentialInStream(InputStream stream, long streamSize) {
        this._stream = stream;
        this._size = streamSize;
        this._pos = 0L;
        this._wasFinished = false;
    }

    @Override
    public int read() throws IOException {
        int ret = this._stream.read();
        if (ret == -1) {
            this._wasFinished = true;
        }
        return ret;
    }

    @Override
    public int read(byte[] data, int off, int size) throws IOException {
        int sizeToRead;
        long sizeToRead2 = this._size - this._pos;
        if ((long)size < sizeToRead2) {
            sizeToRead2 = size;
        }
        if ((sizeToRead = (int)sizeToRead2) > 0) {
            int realProcessedSize = this._stream.read(data, off, sizeToRead);
            if (realProcessedSize == -1) {
                this._wasFinished = true;
                return -1;
            }
            this._pos += (long)realProcessedSize;
            return realProcessedSize;
        }
        return -1;
    }
}

