/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSON;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class JSONArray {
    private final ArrayList<Object> values;

    public JSONArray() {
        this.values = new ArrayList();
    }

    public JSONArray(int initialCapacity) {
        this.values = new ArrayList(initialCapacity);
    }

    public void trimToSize() {
        this.values.trimToSize();
    }

    public JSONArray(Collection<?> copyFrom) {
        this(copyFrom == null ? 0 : copyFrom.size());
        if (copyFrom != null) {
            Iterator<?> it = copyFrom.iterator();
            while (it.hasNext()) {
                this.put(JSONObject.wrap(it.next()));
            }
        }
    }

    public JSONArray(JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (!(object instanceof JSONArray)) {
            throw JSON.typeMismatch(object, "JSONArray");
        }
        this.values = ((JSONArray)object).values;
    }

    public JSONArray(String json) throws JSONException {
        this(new JSONTokener(json));
    }

    public JSONArray(Object array) throws JSONException {
        if (!array.getClass().isArray()) {
            throw new JSONException("Not a primitive array: " + array.getClass());
        }
        int length = Array.getLength(array);
        this.values = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            this.put(JSONObject.wrap(Array.get(array, i)));
        }
    }

    public int length() {
        return this.values.size();
    }

    public JSONArray put(boolean value) {
        this.values.add(value);
        return this;
    }

    public JSONArray put(double value) throws JSONException {
        this.values.add(JSON.checkDouble(value));
        return this;
    }

    public JSONArray put(int value) {
        this.values.add(value);
        return this;
    }

    public JSONArray put(long value) {
        this.values.add(value);
        return this;
    }

    public JSONArray put(Object value) {
        this.values.add(value);
        return this;
    }

    void checkedPut(Object value) throws JSONException {
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.put(value);
    }

    public JSONArray put(int index2, boolean value) throws JSONException {
        return this.put(index2, (Object)value);
    }

    public JSONArray put(int index2, double value) throws JSONException {
        return this.put(index2, (Object)value);
    }

    public JSONArray put(int index2, int value) throws JSONException {
        return this.put(index2, (Object)value);
    }

    public JSONArray put(int index2, long value) throws JSONException {
        return this.put(index2, (Object)value);
    }

    public JSONArray put(int index2, Object value) throws JSONException {
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        while (this.values.size() <= index2) {
            this.values.add(null);
        }
        this.values.set(index2, value);
        return this;
    }

    public boolean isNull(int index2) {
        Object value = this.opt(index2);
        return value == null || value == JSONObject.NULL;
    }

    public Object get(int index2) throws JSONException {
        try {
            Object value = this.values.get(index2);
            if (value == null) {
                throw new JSONException("Value at " + index2 + " is null.");
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("Index " + index2 + " out of range [0.." + this.values.size() + ")", e);
        }
    }

    public Object opt(int index2) {
        if (index2 < 0 || index2 >= this.values.size()) {
            return null;
        }
        return this.values.get(index2);
    }

    public Object remove(int index2) {
        if (index2 < 0 || index2 >= this.values.size()) {
            return null;
        }
        return this.values.remove(index2);
    }

    public boolean getBoolean(int index2) throws JSONException {
        Object object = this.get(index2);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSON.typeMismatch(index2, object, "boolean");
        }
        return result;
    }

    public boolean optBoolean(int index2) {
        return this.optBoolean(index2, false);
    }

    public boolean optBoolean(int index2, boolean fallback) {
        Object object = this.opt(index2);
        Boolean result = JSON.toBoolean(object);
        return result != null ? result : fallback;
    }

    public double getDouble(int index2) throws JSONException {
        Object object = this.get(index2);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSON.typeMismatch(index2, object, "double");
        }
        return result;
    }

    public double optDouble(int index2) {
        return this.optDouble(index2, Double.NaN);
    }

    public double optDouble(int index2, double fallback) {
        Object object = this.opt(index2);
        Double result = JSON.toDouble(object);
        return result != null ? result : fallback;
    }

    public int getInt(int index2) throws JSONException {
        Object object = this.get(index2);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSON.typeMismatch(index2, object, "int");
        }
        return result;
    }

    public int optInt(int index2) {
        return this.optInt(index2, 0);
    }

    public int optInt(int index2, int fallback) {
        Object object = this.opt(index2);
        Integer result = JSON.toInteger(object);
        return result != null ? result : fallback;
    }

    public long getLong(int index2) throws JSONException {
        Object object = this.get(index2);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSON.typeMismatch(index2, object, "long");
        }
        return result;
    }

    public long optLong(int index2) {
        return this.optLong(index2, 0L);
    }

    public long optLong(int index2, long fallback) {
        Object object = this.opt(index2);
        Long result = JSON.toLong(object);
        return result != null ? result : fallback;
    }

    public String getString(int index2) throws JSONException {
        Object object = this.get(index2);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSON.typeMismatch(index2, object, "String");
        }
        return result;
    }

    public String optString(int index2) {
        return this.optString(index2, "");
    }

    public String optString(int index2, String fallback) {
        Object object = this.opt(index2);
        String result = JSON.toString(object);
        return result != null ? result : fallback;
    }

    public JSONArray getJSONArray(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSON.typeMismatch(index2, object, "JSONArray");
    }

    public JSONArray optJSONArray(int index2) {
        Object object = this.opt(index2);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSON.typeMismatch(index2, object, "JSONObject");
    }

    public JSONObject optJSONObject(int index2) {
        Object object = this.opt(index2);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        JSONObject result = new JSONObject();
        int length = Math.min(names.length(), this.values.size());
        if (length == 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            String name = JSON.toString(names.opt(i));
            result.put(name, this.opt(i));
        }
        return result;
    }

    public String join(String separator) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        stringer.open(JSONStringer.Scope.NULL, "");
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                stringer.out.append(separator);
            }
            stringer.value(this.values.get(i));
        }
        stringer.close(JSONStringer.Scope.NULL, JSONStringer.Scope.NULL, "");
        return stringer.out.toString();
    }

    public String toString() {
        try {
            JSONStringer stringer = new JSONStringer();
            this.writeTo(stringer);
            return stringer.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString(int indentSpaces) throws JSONException {
        JSONStringer stringer = new JSONStringer(indentSpaces);
        this.writeTo(stringer);
        return stringer.toString();
    }

    void writeTo(JSONStringer stringer) throws JSONException {
        stringer.array();
        for (Object value : this.values) {
            stringer.value(value);
        }
        stringer.endArray();
    }

    public boolean equals(Object o) {
        return o instanceof JSONArray && ((JSONArray)o).values.equals(this.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

