/*
 * Decompiled with CFR 0.152.
 */
package net.yacy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.plugin.ClassProvider;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.TimeoutRequest;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.Translator;
import net.yacy.gui.YaCyApp;
import net.yacy.gui.framework.Browser;
import net.yacy.http.YaCyHttpServer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.OS;
import net.yacy.migration;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.peers.operation.yacyRelease;
import net.yacy.search.Switchboard;
import net.yacy.server.serverSwitch;
import net.yacy.shutdownHookThread;
import net.yacy.utils.translation.TranslatorXliff;
import org.apache.http.Header;
import org.apache.http.entity.mime.content.ContentBody;

public final class yacy {
    public static final String vString = yacyBuildProperties.getVersion();
    public static final String copyright = "[ YaCy v" + vString + " by Michael Christen / www.yacy.net ]";
    public static final String hline = "-------------------------------------------------------------------------------";
    public static final Semaphore shutdownSemaphore = new Semaphore(0);
    public static File htDocsPath = null;
    public static File shareDefaultPath = null;
    public static File shareDumpDefaultPath = null;
    private static Switchboard sb = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startup(File dataHome, File appHome, long startupMemFree, long startupMemTotal, boolean gui) {
        String tmpdir = null;
        try {
            File htdocsReadme;
            double oldVer;
            System.out.println(copyright);
            System.out.println(hline);
            yacy.mkdirsIfNeseccary(dataHome);
            yacy.mkdirsIfNeseccary(appHome);
            File f = new File(dataHome, "DATA/");
            yacy.mkdirsIfNeseccary(f);
            if (!f.exists()) {
                System.err.println("Error creating DATA-directory in " + dataHome.toString() + " . Please check your write-permission for this folder. YaCy will now terminate.");
                System.exit(-1);
            }
            try {
                tmpdir = Files.createTempDirectory("yacy-tmp-", new FileAttribute[0]).toString();
                System.setProperty("java.io.tmpdir", tmpdir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            f = new File(dataHome, "DATA/LOG/");
            yacy.mkdirsIfNeseccary(f);
            f = new File(f, "yacy.logging");
            File f0 = new File(appHome, "defaults/yacy.logging");
            if (!f.exists() || f0.lastModified() > f.lastModified()) {
                try {
                    com.google.common.io.Files.copy((File)f0, (File)f);
                }
                catch (IOException e) {
                    System.out.println("could not copy yacy.logging: " + e.getMessage());
                }
            }
            try {
                ConcurrentLog.configureLogging(dataHome, new File(dataHome, "DATA/LOG/yacy.logging"));
            }
            catch (IOException e) {
                System.out.println("could not find logging properties in homePath=" + dataHome);
                ConcurrentLog.logException(e);
            }
            ConcurrentLog.config("STARTUP", "YaCy version: " + yacyBuildProperties.getReleaseStub());
            ConcurrentLog.config("STARTUP", "Java version: " + System.getProperty("java.version", "no-java-version"));
            ConcurrentLog.config("STARTUP", "Operation system: " + System.getProperty("os.name", "unknown"));
            ConcurrentLog.config("STARTUP", "Application root-path: " + appHome);
            ConcurrentLog.config("STARTUP", "Data root-path: " + dataHome);
            ConcurrentLog.config("STARTUP", "Time zone: UTC" + GenericFormatter.UTCDiffString() + "; UTC+0000 is " + System.currentTimeMillis());
            ConcurrentLog.config("STARTUP", "Maximum file system path length: " + OS.maxPathLength);
            f = new File(dataHome, "DATA/yacy.running");
            if (!f.createNewFile()) {
                ConcurrentLog.severe("STARTUP", "WARNING: the file " + f + " can not be created!");
            }
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(Integer.toString(OS.getPID()).getBytes());
                fos.close();
            }
            catch (Exception fos) {
                // empty catch block
            }
            f.deleteOnExit();
            FileChannel channel = null;
            FileLock lock = null;
            try {
                RandomAccessFile raf = new RandomAccessFile(f, "rw");
                channel = raf.getChannel();
                lock = channel.tryLock();
                raf.close();
            }
            catch (Exception raf) {
                // empty catch block
            }
            String conf = "DATA/SETTINGS/yacy.conf".replace("/", File.separator);
            try {
                sb = new Switchboard(dataHome, appHome, "defaults/yacy.init".replace("/", File.separator), conf);
            }
            catch (RuntimeException e) {
                ConcurrentLog.severe("STARTUP", "YaCy cannot start: " + e.getMessage(), e);
                System.exit(-1);
            }
            MemoryControl.setStandardStrategy(sb.getConfigBool("memory.standardStrategy", true));
            sb.setConfig("memoryFreeAfterStartup", startupMemFree);
            sb.setConfig("memoryTotalAfterStartup", startupMemTotal);
            if (gui) {
                YaCyApp.start("localhost", sb.getLocalPort());
            }
            sb.setConfig("htTemplatePath", "htroot/env/templates");
            try {
                String tmpversion = sb.getConfig("Version", "");
                if (tmpversion.isEmpty()) {
                    tmpversion = yacyBuildProperties.getVersion();
                    int oldRev = Integer.parseInt(sb.getConfig("svnRevision", "0"));
                    oldVer = oldRev > 1 ? Double.parseDouble(tmpversion) + (double)oldRev / 1.0E8 : Double.parseDouble(yacyBuildProperties.getVersion());
                } else {
                    oldVer = Double.parseDouble(tmpversion);
                }
            }
            catch (NumberFormatException e) {
                oldVer = 0.0;
            }
            double newRev = Double.parseDouble(yacyBuildProperties.getVersion());
            sb.setConfig("Version", yacyBuildProperties.getVersion());
            sb.setConfig("applicationRoot", appHome.toString());
            sb.setConfig("dataRoot", dataHome.toString());
            File htRootPath = new File(appHome, sb.getConfig("htRootPath", "htroot"));
            yacy.mkdirIfNeseccary(htRootPath);
            htDocsPath = sb.getDataPath("htDocsPath", "DATA/HTDOCS");
            yacy.mkdirIfNeseccary(htDocsPath);
            File notifierFile = new File(htDocsPath, "notifier.gif");
            if (!notifierFile.exists()) {
                try {
                    com.google.common.io.Files.copy((File)new File(htRootPath, "env/grafics/empty.gif"), (File)notifierFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!(htdocsReadme = new File(htDocsPath, "readme.txt")).exists()) {
                try {
                    FileUtils.copy("This is your root directory for individual Web Content\r\n\r\nPlease place your html files into the www subdirectory.\r\nThe URL of that path is either\r\nhttp://www.<your-peer-name>.yacy    or\r\nhttp://<your-ip>:<your-port>/www\r\n\r\nOther subdirectories may be created; they map to corresponding sub-domains.\r\nThis directory shares it's content with the applications htroot path, so you\r\nmay access your yacy search page with\r\nhttp://<your-peer-name>.yacy/\r\n\r\n".getBytes(), htdocsReadme);
                }
                catch (IOException e) {
                    System.out.println("Error creating htdocs readme: " + e.getMessage());
                }
            }
            shareDefaultPath = new File(htDocsPath, "share");
            yacy.mkdirIfNeseccary(shareDefaultPath);
            shareDumpDefaultPath = new File(shareDefaultPath, "dump");
            yacy.mkdirIfNeseccary(shareDumpDefaultPath);
            migration.migrate(sb, oldVer, newRev);
            int deleteOldDownloadsAfterDays = (int)sb.getConfigLong("update.deleteOld", 30L);
            yacyRelease.deleteOldDownloads(yacy.sb.releasePath, deleteOldDownloadsAfterDays);
            final int port = sb.getLocalPort();
            try {
                List<String> langlist;
                YaCyHttpServer httpServer = new YaCyHttpServer(port);
                httpServer.startupServer();
                sb.setHttpServer(httpServer);
                ConnectionInfo.setServerMaxcount(sb.getConfigInt("connectionsMax", ConnectionInfo.getMaxcount()));
                ConcurrentLog.info("STARTUP", httpServer.getVersion());
                boolean browserPopUpTrigger = sb.getConfig("browserPopUpTrigger", "true").equals("true");
                if (browserPopUpTrigger) {
                    try {
                        final String browserPopUpPage = sb.getConfig("browserPopUpPage", "ConfigBasic.html");
                        new Thread("Browser opening"){

                            @Override
                            public void run() {
                                Browser.openBrowser("http://localhost:" + port + "/" + browserPopUpPage);
                            }
                        }.start();
                    }
                    catch (Throwable browserPopUpPage) {
                        // empty catch block
                    }
                }
                yacy.sb.tray.setReady();
                File locale_source = sb.getAppPath("locale.source", "locales");
                String lang = sb.getConfig("locale.language", "");
                if (lang.endsWith("browser")) {
                    langlist = Translator.activeTranslations();
                } else {
                    langlist = new ArrayList<String>();
                    langlist.add(lang);
                }
                for (String tmplang : langlist) {
                    if (tmplang.equals("") || tmplang.equals("default") || tmplang.equals("browser")) continue;
                    String currentRev = null;
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(sb.getDataPath("locale.translated_html", "DATA/LOCALE/htroot"), tmplang + "/version"))));
                        currentRev = br.readLine();
                    }
                    catch (IOException ioe) {
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException ioe) {
                            ConcurrentLog.warn("STARTUP", "Could not close " + tmplang + " version file");
                        }
                    }
                    if (currentRev != null && currentRev.equals(sb.getConfig("Version", ""))) continue;
                    try {
                        File destDir;
                        File sourceDir = new File(sb.getConfig("htRootPath", "htroot"));
                        if (!new TranslatorXliff().translateFilesRecursive(sourceDir, destDir = new File(sb.getDataPath("locale.translated_html", "DATA/LOCALE/htroot"), tmplang), new File(locale_source, tmplang + ".lng"), "html,template,inc", "locale")) continue;
                        BufferedWriter bw = new BufferedWriter(new PrintWriter(new FileWriter(new File(destDir, "version"))));
                        bw.write(sb.getConfig("Version", "Error getting Version"));
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!lang.equals("browser")) {
                    Formatter.setLocale(lang);
                }
                ConcurrentLog.config("STARTUP", "Registering Shutdown Hook");
                Runtime run = Runtime.getRuntime();
                run.addShutdownHook(new shutdownHookThread(sb, shutdownSemaphore));
                sb.setConfig("memoryFreeAfterInitBGC", MemoryControl.free());
                sb.setConfig("memoryTotalAfterInitBGC", MemoryControl.total());
                System.gc();
                sb.setConfig("memoryFreeAfterInitAGC", MemoryControl.free());
                sb.setConfig("memoryTotalAfterInitAGC", MemoryControl.total());
                try {
                    sb.waitForShutdown();
                }
                catch (Exception e) {
                    ConcurrentLog.severe("MAIN CONTROL LOOP", "PANIC: " + e.getMessage(), e);
                }
                ConcurrentLog.config("SHUTDOWN", "caught termination signal");
                httpServer.stop();
                ConcurrentLog.config("SHUTDOWN", "server has terminated");
                sb.close();
            }
            catch (Exception e) {
                ConcurrentLog.severe("STARTUP", "Unexpected Error: " + e.getClass().getName(), e);
            }
            if (lock != null && lock.isValid()) {
                lock.release();
            }
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception ee) {
            ConcurrentLog.severe("STARTUP", "FATAL ERROR: " + ee.getMessage(), ee);
        }
        if (tmpdir != null) {
            FileUtils.deletedelete(new File(tmpdir));
        }
        ConcurrentLog.config("SHUTDOWN", "goodbye. (this is the last line)");
        ConcurrentLog.shutdown();
        shutdownSemaphore.release(1000);
        try {
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void delete(File f) {
        if (!f.delete()) {
            ConcurrentLog.severe("STARTUP", "WARNING: the file " + f + " can not be deleted!");
        }
    }

    private static void mkdirIfNeseccary(File path) {
        if (!path.exists() && !path.mkdir()) {
            ConcurrentLog.warn("STARTUP", "could not create directory " + path.toString());
        }
    }

    public static void mkdirsIfNeseccary(File path) {
        if (!path.exists() && !path.mkdirs()) {
            ConcurrentLog.warn("STARTUP", "could not create directories " + path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties configuration(String mes, File homePath) {
        ConcurrentLog.config(mes, "Application Root Path: " + homePath.toString());
        File dataFolder = new File(homePath, "DATA");
        if (!dataFolder.exists()) {
            ConcurrentLog.severe(mes, "Application was never started or root path wrong.");
            System.exit(-1);
        }
        Properties config = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(homePath, "DATA/SETTINGS/yacy.conf"));
            config.load(fis);
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.severe(mes, "could not find configuration file.");
            System.exit(-1);
        }
        catch (IOException e) {
            ConcurrentLog.severe(mes, "could not read configuration file.");
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        return config;
    }

    public static void shutdown(File homePath) {
        System.out.println(copyright);
        System.out.println(hline);
        LinkedHashMap<String, ContentBody> post = new LinkedHashMap<String, ContentBody>();
        post.put("shutdown", (ContentBody)UTF8.StringBody(""));
        yacy.submitPostURL(homePath, "Steering.html", "Terminate YaCy", post);
    }

    public static void update(File homePath) {
        System.out.println(copyright);
        System.out.println(hline);
        yacy.submitURL(homePath, "ConfigUpdate_p.html?autoUpdate=", "Update YaCy to most recent version");
    }

    private static void submitPostURL(File homePath, String path, String processdescription, Map<String, ContentBody> post) {
        block16: {
            Properties config = yacy.configuration("COMMAND-STEERING", homePath);
            int port = Integer.parseInt(config.getProperty("port", "8090"));
            String encodedPassword = config.getProperty("adminAccountBase64MD5", "");
            String adminUser = config.getProperty("adminAccountUserName", "admin");
            try (HTTPClient con = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
                con.GETbytes("http://localhost:" + port + "/" + path, adminUser, encodedPassword, false);
                if (con.getStatusCode() != 200) {
                    throw new IOException("Error response from YACY socket: " + con.getHttpResponse().getStatusLine());
                }
                Header transactionTokenHeader = con.getHttpResponse().getFirstHeader("X-YaCy-Transaction-Token");
                if (transactionTokenHeader == null) {
                    throw new IOException("Could not retrieve a valid transaction token");
                }
                post.put("transactionToken", (ContentBody)UTF8.StringBody(transactionTokenHeader.getValue()));
                con.POSTbytes(new MultiProtocolURL("http://localhost:" + port + "/" + path), null, post, adminUser, encodedPassword, false, false);
                if (con.getStatusCode() >= 200 && con.getStatusCode() < 300) {
                    ConcurrentLog.config("COMMAND-STEERING", "YACY accepted steering command: " + processdescription);
                    break block16;
                }
                ConcurrentLog.severe("COMMAND-STEERING", "error response from YACY socket: " + con.getHttpResponse().getStatusLine());
                try {
                    HTTPClient.closeConnectionManager();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                RemoteInstance.closeConnectionManager();
                System.exit(-1);
            }
            catch (IOException e) {
                ConcurrentLog.severe("COMMAND-STEERING", "could not establish connection to YACY socket: " + e.getMessage());
                try {
                    HTTPClient.closeConnectionManager();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                RemoteInstance.closeConnectionManager();
                System.exit(-1);
            }
        }
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RemoteInstance.closeConnectionManager();
        ConcurrentLog.config("COMMAND-STEERING", "SUCCESSFULLY FINISHED COMMAND: " + processdescription);
    }

    private static void submitURL(File homePath, String path, String processdescription) {
        Properties config = yacy.configuration("COMMAND-STEERING", homePath);
        int port = Integer.parseInt(config.getProperty("port", "8090"));
        String encodedPassword = (String)config.get("adminAccountBase64MD5");
        if (encodedPassword == null) {
            encodedPassword = "";
        }
        try (HTTPClient con = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
            con.GETbytes("http://localhost:" + port + "/" + path, config.getProperty("adminAccountUserName", "admin"), encodedPassword, false);
            if (con.getStatusCode() > 199 && con.getStatusCode() < 300) {
                ConcurrentLog.config("COMMAND-STEERING", "YACY accepted steering command: " + processdescription);
            } else {
                ConcurrentLog.severe("COMMAND-STEERING", "error response from YACY socket: " + con.getHttpResponse().getStatusLine());
                System.exit(-1);
            }
        }
        catch (IOException e) {
            ConcurrentLog.severe("COMMAND-STEERING", "could not establish connection to YACY socket: " + e.getMessage());
            System.exit(-1);
        }
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RemoteInstance.closeConnectionManager();
        ConcurrentLog.config("COMMAND-STEERING", "SUCCESSFULLY FINISHED COMMAND: " + processdescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preReadSavedConfigandInit(File dataHome) {
        File lockFile = new File(dataHome, "DATA/yacy.running");
        String conf = "DATA/SETTINGS/yacy.conf";
        File configFile = new File(dataHome, "DATA/SETTINGS/yacy.conf");
        if (configFile.exists()) {
            Properties p = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(configFile);
                p.load(fis);
                if (lockFile.exists()) {
                    System.out.println("WARNING: the file " + lockFile + " exists, this usually means that a YaCy instance is still running. If you want to restart YaCy, try first ./stopYACY.sh, then ./startYACY.sh. If ./stopYACY.sh fails, try ./killYACY.sh");
                    int port = Integer.parseInt(p.getProperty("port", "8090"));
                    if (TimeoutRequest.ping("127.0.0.1", port, 1000)) {
                        Browser.openBrowser("http://localhost:" + port + "/" + p.getProperty("browserPopUpPage", "index.html"));
                        System.out.println("WARNING: YaCy instance was still running; just opening the browser and exit.");
                        System.exit(0);
                    } else {
                        System.err.println("INFO: delete old yacy.running file; likely previous YaCy session was not orderly shutdown!");
                        yacy.delete(lockFile);
                    }
                }
            }
            catch (IOException ex) {
                System.err.println("ERROR: config file seems to be corrupt");
                System.err.println("ERROR: if problem persists, delete file");
                System.err.println(configFile.getAbsolutePath());
                ConcurrentLog.logException(ex);
                ConcurrentLog.severe("Startup", "cannot read " + configFile.toString() + ", please delete the corrupted file if problem persits");
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ConcurrentLog.warn("Startup", "Could not close file " + configFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            boolean assertionenabled = false;
            if (!$assertionsDisabled) {
                assertionenabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertionenabled) {
                System.out.println("Asserts are enabled");
            }
            System.gc();
            long startupMemFree = MemoryControl.free();
            long startupMemTotal = MemoryControl.total();
            boolean headless = true;
            if (OS.isWindows) {
                headless = false;
            }
            if (args.length >= 1 && args[0].toLowerCase(Locale.ROOT).equals("-gui")) {
                headless = false;
            }
            System.setProperty("java.awt.headless", headless ? "true" : "false");
            StringBuilder s = new StringBuilder();
            for (String a : args) {
                s.append(a).append(" ");
            }
            yacyRelease.startParameter = s.toString().trim();
            File applicationRoot = new File(System.getProperty("user.dir").replace('\\', '/'));
            if (!OS.isWindows) {
                try {
                    Class<?> comAppleEioFileManagerClass = Class.forName("com.apple.eio.FileManager");
                    Method getPathToApplicationBundleMethod = ClassProvider.getStaticMethod(comAppleEioFileManagerClass, "getPathToApplicationBundle", null);
                    String apppath = (String)getPathToApplicationBundleMethod.invoke(null, new Object[0]);
                    System.out.println("PathToApplicationBundle = " + apppath);
                    if (apppath != null && apppath.endsWith(".app")) {
                        applicationRoot = new File(apppath + "/Contents");
                        System.setProperty("user.dir", applicationRoot.getAbsolutePath());
                        System.setProperty("user.home", applicationRoot.getAbsolutePath());
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            File dataRoot = applicationRoot;
            if (args.length >= 1 && (args[0].toLowerCase(Locale.ROOT).equals("-startup") || args[0].equals("-start"))) {
                if (args.length > 1 && !(dataRoot = new File(args[1])).isAbsolute()) {
                    dataRoot = new File(System.getProperty("user.home").replace('\\', '/'), args[1]);
                }
                yacy.preReadSavedConfigandInit(dataRoot);
                yacy.startup(dataRoot, applicationRoot, startupMemFree, startupMemTotal, false);
            } else if (args.length >= 1 && args[0].toLowerCase(Locale.ROOT).equals("-gui")) {
                if (args.length > 1 && !(dataRoot = new File(args[1])).isAbsolute()) {
                    dataRoot = new File(System.getProperty("user.home").replace('\\', '/'), args[1]);
                }
                yacy.preReadSavedConfigandInit(dataRoot);
                yacy.startup(dataRoot, applicationRoot, startupMemFree, startupMemTotal, true);
            } else if (args.length >= 1 && (args[0].toLowerCase(Locale.ROOT).equals("-shutdown") || args[0].equals("-stop"))) {
                if (args.length == 2) {
                    applicationRoot = new File(args[1]);
                }
                yacy.shutdown(applicationRoot);
            } else if (args.length >= 1 && args[0].toLowerCase(Locale.ROOT).equals("-update")) {
                if (args.length == 2) {
                    applicationRoot = new File(args[1]);
                }
                yacy.update(applicationRoot);
            } else if (args.length >= 1 && args[0].toLowerCase(Locale.ROOT).equals("-version")) {
                System.out.println(copyright);
            } else if (args.length > 1 && args[0].toLowerCase(Locale.ROOT).equals("-config")) {
                File f = new File(dataRoot, "DATA/SETTINGS/");
                if (!f.exists()) {
                    yacy.mkdirsIfNeseccary(f);
                } else if (new File(dataRoot, "DATA/yacy.running").exists()) {
                    System.out.println("please restart YaCy");
                }
                serverSwitch ss = new serverSwitch(dataRoot, applicationRoot, "defaults/yacy.init", "DATA/SETTINGS/yacy.conf");
                for (int icnt = 1; icnt < args.length; ++icnt) {
                    String cfg = args[icnt];
                    int pos = cfg.indexOf(61);
                    if (pos > 0) {
                        String cmd = cfg.substring(0, pos);
                        String val = cfg.substring(pos + 1);
                        if (!val.isEmpty()) {
                            if (cmd.equalsIgnoreCase("adminAccount")) {
                                int cpos = val.indexOf(58);
                                if (cpos >= 0) {
                                    String username = val.substring(0, cpos);
                                    String pwdtxt = val.substring(cpos + 1);
                                    if (!username.isEmpty()) {
                                        ss.setConfig("adminAccountUserName", username);
                                        System.out.println("Set property adminAccountUserName = " + username);
                                    } else {
                                        username = ss.getConfig("adminAccountUserName", "admin");
                                    }
                                    ss.setConfig("adminAccountBase64MD5", sb.encodeDigestAuth(username, pwdtxt));
                                    System.out.println("Set property adminAccountBase64MD5 = " + ss.getConfig("adminAccountBase64MD5", ""));
                                }
                            } else {
                                ss.setConfig(cmd, val);
                                System.out.println("Set property " + cmd + " = " + val);
                            }
                        }
                    } else {
                        System.out.println("skip parameter " + cfg + " (equal sign missing, put parameter in doublequotes)");
                    }
                    System.out.println();
                }
            } else {
                if (args.length == 1) {
                    applicationRoot = new File(args[0]);
                }
                yacy.preReadSavedConfigandInit(dataRoot);
                yacy.startup(dataRoot, applicationRoot, startupMemFree, startupMemTotal, false);
            }
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }
}

