/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class Captcha
extends RasterPlotter {
    public Captcha(int width, int height, RasterPlotter.DrawMode displayMode, String code) {
        super(width, height, displayMode, "FFFFFF");
        this.create(code);
    }

    private void create(String code) {
        int x;
        int y;
        int i;
        Random random = new Random();
        int chars = code.length();
        int ub = 0;
        int widthPerChar = this.width / chars;
        int pixels = this.width * this.height;
        for (i = 0; i < chars; ++i) {
            y = random.nextInt(this.height / 2) + this.height / 4;
            this.setColor((random.nextInt(128) + 64 << 16) + (random.nextInt(128) + 64 << 8) + random.nextInt(128) + 64);
            PrintTool.print(this, widthPerChar * i + random.nextInt(widthPerChar / 2), y, 0, code.substring(i, i + 1), -1, 100);
        }
        ub = pixels / 100;
        for (i = 0; i < ub; ++i) {
            this.setColor((random.nextInt(128) + 64 << 16) + (random.nextInt(128) + 64 << 8) + random.nextInt(128) + 64);
            x = random.nextInt(this.width);
            y = random.nextInt(this.height);
            this.plot(x, y, 100);
        }
        ub = pixels / 1000;
        for (i = 0; i < ub; ++i) {
            this.setColor((random.nextInt(128) + 64 << 16) + (random.nextInt(128) + 64 << 8) + random.nextInt(128) + 64);
            x = random.nextInt(this.width);
            y = random.nextInt(this.height);
            this.line(x, y, x + random.nextInt(5), y + random.nextInt(5), 100);
        }
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        Captcha m = new Captcha(200, 70, RasterPlotter.DrawMode.MODE_REPLACE, args[1]);
        try {
            ImageIO.write((RenderedImage)m.getImage(), "png", new File(args[0]));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

