/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class AnimationPlotter {
    private final List<Frame> frames = new ArrayList<Frame>();

    public void addFrame(BufferedImage image, int delayMillis) {
        this.frames.add(new Frame(image, delayMillis));
    }

    public void save(File path, String filestub, String type) throws IOException {
        assert (path.isDirectory());
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = this.frames.get(i);
            File file = new File(path, filestub + "_" + this.intformat(i) + '.' + type);
            try (FileOutputStream fos = new FileOutputStream(file);){
                ImageIO.write((RenderedImage)frame.image, type, fos);
                continue;
            }
        }
    }

    private String intformat(int i) {
        String n = Integer.toString(i);
        while (n.length() < 6) {
            n = '0' + n;
        }
        return n;
    }

    public void show() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        JComponent label = null;
        block2: while (true) {
            int i = 0;
            while (true) {
                if (i >= this.frames.size()) continue block2;
                Frame frame = this.frames.get(i);
                if (label == null) {
                    label = new JLabel(new ImageIcon(frame.image));
                    f.getContentPane().add(label);
                    f.pack();
                } else {
                    label.getGraphics().drawImage(frame.image, 0, 0, label);
                }
                try {
                    Thread.sleep(frame.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            break;
        }
    }

    public static class Frame {
        BufferedImage image;
        int delayMillis;

        public Frame(BufferedImage image, int delayMillis) {
            this.image = image;
            this.delayMillis = delayMillis;
        }
    }
}

