/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnimationGIF {
    private static final String formatName = "javax_imageio_gif_image_1.0";
    private static final String aesNodeName = "ApplicationExtensions";
    private static final String aeNodeName = "ApplicationExtension";
    private static final String gceNodeName = "GraphicControlExtension";
    private static final String delayNodeName = "delayTime";
    private static final String transparencyFlagNodeName = "transparentColorFlag";
    private static final String transparencyIndexNodeName = "transparentColorIndex";
    private int counter = 0;
    private int loops;
    private IIOMetadata iiom;
    private ImageWriter writer;
    private ImageWriteParam iwp;
    private ImageOutputStream ios;
    private ByteArrayOutputStream baos;

    public AnimationGIF(int loops) {
        this.loops = loops;
        this.ios = null;
        this.writer = null;
        this.baos = new ByteArrayOutputStream();
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByFormatName("GIF");
        this.writer = writerIterator.next();
        this.ios = new MemoryCacheImageOutputStream(this.baos);
        this.writer.setOutput(this.ios);
        this.iwp = this.writer.getDefaultWriteParam();
    }

    public void addImage(RenderedImage image, int delayMillis, int transparencyColorIndex) throws IOException {
        if (this.counter == 0) {
            this.iiom = this.writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(image), this.iwp);
            this.writer.prepareWriteSequence(this.writer.getDefaultStreamMetadata(this.iwp));
        }
        if (this.counter == 0 && this.loops >= 0) {
            IIOMetadata imageMetadata2 = this.writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(image), this.iwp);
            try {
                AnimationGIF.setMetadata(imageMetadata2, delayMillis, transparencyColorIndex);
                AnimationGIF.setLoops(imageMetadata2, this.loops);
                this.writer.writeToSequence(new IIOImage(image, null, imageMetadata2), this.iwp);
            }
            catch (IIOInvalidTreeException e) {
                throw new IOException(e.getMessage());
            }
        }
        try {
            AnimationGIF.setMetadata(this.iiom, delayMillis, transparencyColorIndex);
            this.writer.writeToSequence(new IIOImage(image, null, this.iiom), this.iwp);
        }
        catch (IIOInvalidTreeException e) {
            throw new IOException(e.getMessage());
        }
        ++this.counter;
    }

    public byte[] get() {
        if (this.ios != null) {
            try {
                this.ios.close();
                this.ios = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.writer != null) {
            this.writer.dispose();
            this.writer = null;
        }
        return this.baos.toByteArray();
    }

    private static void setMetadata(IIOMetadata metaData, int delayMillis, int transparencyColorIndex) throws IIOInvalidTreeException {
        Node tree = metaData.getAsTree(formatName);
        NodeList nodeList = tree.getChildNodes();
        Node gceNode = null;
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = nodeList.item(i);
            if (!curNode.getNodeName().equals(gceNodeName)) continue;
            gceNode = curNode;
            break;
        }
        if (gceNode == null) {
            throw new IIOInvalidTreeException("Invalid image metadata, could not find GraphicControlExtensionnode.", null, tree);
        }
        Node delayNode = gceNode.getAttributes().getNamedItem(delayNodeName);
        if (delayNode == null) {
            delayNode = tree.getOwnerDocument().createAttribute(delayNodeName);
            gceNode.appendChild(delayNode);
        }
        delayNode.setNodeValue(Integer.valueOf(delayMillis / 10).toString());
        if (transparencyColorIndex >= 0) {
            Node transparencyFlagNode = gceNode.getAttributes().getNamedItem(transparencyFlagNodeName);
            if (transparencyFlagNode == null) {
                transparencyFlagNode = tree.getOwnerDocument().createAttribute(transparencyFlagNodeName);
                gceNode.appendChild(transparencyFlagNode);
            }
            transparencyFlagNode.setNodeValue("TRUE");
            Node transparencyIndexNode = gceNode.getAttributes().getNamedItem(transparencyIndexNodeName);
            if (transparencyIndexNode == null) {
                transparencyIndexNode = tree.getOwnerDocument().createAttribute(transparencyIndexNodeName);
                gceNode.appendChild(transparencyIndexNode);
            }
            transparencyIndexNode.setNodeValue(Integer.valueOf(transparencyColorIndex).toString());
        }
        metaData.setFromTree(formatName, tree);
    }

    private static void setLoops(IIOMetadata metaData, int loops) throws IIOInvalidTreeException {
        Node tree = metaData.getAsTree(formatName);
        IIOMetadataNode aes = new IIOMetadataNode(aesNodeName);
        IIOMetadataNode ae = new IIOMetadataNode(aeNodeName);
        ae.setAttribute("applicationID", "NETSCAPE");
        ae.setAttribute("authenticationCode", "2.0");
        ae.setUserObject(new byte[]{1, (byte)(loops & 0xFF), (byte)(loops >> 8 & 0xFF)});
        aes.appendChild(ae);
        tree.appendChild(aes);
        metaData.setFromTree(formatName, tree);
    }

    private static RenderedImage generateTestImage(int width, int height, Random r, double angle) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLUE);
        int x = width / 2;
        int y = height / 2;
        int radius = Math.min(x, y);
        g.drawLine(x, y, x + (int)((double)radius * Math.cos(angle)), y + (int)((double)radius * Math.sin(angle)));
        g.drawString("giftest", r.nextInt(width), r.nextInt(height));
        return img;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        Random r = new Random(System.currentTimeMillis());
        int framescount = 100;
        AnimationGIF generator = new AnimationGIF(0);
        try {
            for (int i = 0; i < framescount; ++i) {
                generator.addImage(AnimationGIF.generateTestImage(320, 160, r, (double)(i * 2) * Math.PI / (double)framescount), 10, 0);
            }
            try (FileOutputStream fos = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + File.separator + "giftest.gif"));){
                fos.write(generator.get());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

