/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.upnp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.utils.upnp.UPnPMapping;
import net.yacy.utils.upnp.UPnPMappingType;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.bitlet.weupnp.PortMappingEntry;
import org.xml.sax.SAXException;

public class UPnP {
    private static final ConcurrentLog LOG = new ConcurrentLog("UPNP");
    private static final Switchboard SB = Switchboard.getSwitchboard();
    private static GatewayDevice gatewayDevice;
    private static final Map<UPnPMappingType, UPnPMapping> MAPPINGS;
    private static final int MIN_CANDIDATE_PORT = 49152;
    private static final int MAX_CANDIDATE_PORT = 65535;

    private static boolean init() {
        boolean init = true;
        try {
            if (gatewayDevice == null || !gatewayDevice.isConnected()) {
                GatewayDiscover discover = new GatewayDiscover();
                discover.discover();
                gatewayDevice = discover.getValidGateway();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            init = false;
        }
        if (gatewayDevice != null) {
            LOG.info("found device: " + gatewayDevice.getFriendlyName());
        } else {
            LOG.info("no device found");
            init = false;
        }
        return init;
    }

    public static void addPortMappings() {
        if (SB == null) {
            return;
        }
        for (Map.Entry<UPnPMappingType, UPnPMapping> entry2 : MAPPINGS.entrySet()) {
            UPnPMapping mapping = entry2.getValue();
            UPnP.addPortMapping(entry2.getKey(), mapping, SB.getConfigInt(mapping.getConfigPortKey(), 0));
        }
        SB.setConnectedViaUpnp(true);
    }

    public static void deletePortMappings() {
        if (SB == null) {
            return;
        }
        SB.setConnectedViaUpnp(false);
        for (Map.Entry<UPnPMappingType, UPnPMapping> entry2 : MAPPINGS.entrySet()) {
            UPnPMapping mapping = entry2.getValue();
            UPnP.deletePortMapping(mapping);
        }
    }

    private static void addPortMapping(UPnPMappingType type, UPnPMapping mapping, int port) {
        if (port < 1) {
            return;
        }
        if (mapping.getPort() > 0) {
            UPnP.deletePortMapping(mapping);
        }
        if ((mapping.isConfigEnabledKeyEmpty() || SB.getConfigBool(mapping.getConfigEnabledKey(), false)) && mapping.getPort() == 0 && (gatewayDevice != null || UPnP.init())) {
            try {
                String msg;
                boolean mapped;
                String localHostIP = UPnP.toString(gatewayDevice.getLocalAddress());
                int portCandidate = port;
                while (UPnP.isInUse(portCandidate) && portCandidate > 0) {
                    portCandidate = UPnP.getNewPortCandidate(portCandidate);
                }
                if (portCandidate > 0) {
                    mapped = gatewayDevice.addPortMapping(portCandidate, port, localHostIP, mapping.getProtocol(), mapping.getDescription());
                    msg = "mapped port " + port + " to port " + portCandidate + " on device " + gatewayDevice.getFriendlyName() + ", external IP is " + gatewayDevice.getExternalIPAddress();
                } else {
                    mapped = false;
                    msg = "no free port found";
                }
                if (mapped) {
                    LOG.info("mapped " + msg);
                    mapping.setPort(portCandidate);
                    SB.setUpnpPorts(mapping.getConfigPortKey(), portCandidate);
                } else {
                    LOG.warn("could not map " + msg);
                }
            }
            catch (IOException | SAXException e) {
                LOG.severe("mapping error: " + e.getMessage());
            }
        }
    }

    private static void deletePortMapping(UPnPMapping mapping) {
        if (mapping.getPort() > 0 && gatewayDevice != null) {
            try {
                boolean unmapped = gatewayDevice.deletePortMapping(mapping.getPort(), mapping.getProtocol());
                String msg = "port " + mapping.getPort() + " on device " + gatewayDevice.getFriendlyName();
                if (unmapped) {
                    LOG.info("unmapped " + msg);
                } else {
                    LOG.warn("could not unmap " + msg);
                }
            }
            catch (IOException | SAXException e) {
                LOG.severe("unmapping error: " + e.getMessage());
            }
        }
        mapping.setPort(0);
    }

    public static int getMappedPort(UPnPMappingType type) {
        if (type == null) {
            return 0;
        }
        return MAPPINGS.get((Object)type).getPort();
    }

    private static int getNewPortCandidate(int oldCandidate) {
        int newPortCandidate = Math.min(Math.max(49152, oldCandidate + 1), 65535);
        if (newPortCandidate == 65535) {
            newPortCandidate = -1;
        }
        return newPortCandidate;
    }

    private static boolean isInUse(int port) {
        try {
            return gatewayDevice != null && gatewayDevice.getSpecificPortMappingEntry(port, "TCP", new PortMappingEntry());
        }
        catch (IOException | SAXException e) {
            return false;
        }
    }

    private static String toString(InetAddress inetAddress) {
        String localHostIP;
        if (inetAddress != null) {
            localHostIP = inetAddress.getHostAddress();
            if (!inetAddress.isSiteLocalAddress() || localHostIP.startsWith("127.")) {
                LOG.warn("found odd local address: " + localHostIP + "; UPnP may fail");
            }
        } else {
            localHostIP = "";
            LOG.warn("unknown local address, UPnP may fail");
        }
        return localHostIP;
    }

    static {
        MAPPINGS = new EnumMap<UPnPMappingType, UPnPMapping>(UPnPMappingType.class);
        MAPPINGS.put(UPnPMappingType.HTTP, new UPnPMapping("port", null, "TCP", "YaCy HTTP"));
        MAPPINGS.put(UPnPMappingType.HTTPS, new UPnPMapping("port.ssl", "server.https", "TCP", "YaCy HTTPS"));
    }
}

