/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.Translator;
import net.yacy.search.Switchboard;

public class TranslatorXliff
extends Translator {
    public Map<String, Map<String, String>> loadTranslationsListsFromXliff(File xliffFile) {
        TreeMap<String, Map<String, String>> lngLists = new TreeMap<String, Map<String, String>>();
        try (FileInputStream fis = new FileInputStream(xliffFile);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlreader = factory.createXMLStreamReader(fis);
            Map<String, String> translationList = null;
            String source = null;
            String target = null;
            String state = null;
            while (xmlreader.hasNext()) {
                String ename;
                int eventtype = xmlreader.next();
                if (eventtype == 1) {
                    ename = xmlreader.getLocalName();
                    if (ename.equalsIgnoreCase("file")) {
                        String forFile = xmlreader.getAttributeValue(null, "original");
                        if (lngLists.containsKey(forFile)) {
                            translationList = (Map)lngLists.get(forFile);
                        } else {
                            translationList = new LinkedHashMap<String, Object>();
                            lngLists.put(forFile, translationList);
                        }
                        source = null;
                        target = null;
                        continue;
                    }
                    if (ename.equalsIgnoreCase("trans-unit")) {
                        source = null;
                        target = null;
                        continue;
                    }
                    if (ename.equalsIgnoreCase("source")) {
                        source = xmlreader.getElementText();
                        continue;
                    }
                    if (!ename.equalsIgnoreCase("target")) continue;
                    state = xmlreader.getAttributeValue(null, "state");
                    target = xmlreader.getElementText();
                    continue;
                }
                if (eventtype != 2) continue;
                ename = xmlreader.getLocalName();
                if (ename.equalsIgnoreCase("trans-unit") && translationList != null) {
                    if (source != null) {
                        if (target != null) {
                            if ("translated".equals(state)) {
                                translationList.put(source, target);
                            } else {
                                translationList.put(source, null);
                            }
                        } else {
                            translationList.put(source, null);
                        }
                        source = null;
                    }
                    target = null;
                }
                if (!ename.equalsIgnoreCase("file")) continue;
                translationList = null;
            }
            xmlreader.close();
        }
        catch (IOException | XMLStreamException ex) {
            ConcurrentLog.warn("TRANSLATOR", "error reading " + xliffFile.getAbsolutePath() + " -> " + ex.getMessage());
        }
        return lngLists;
    }

    @Override
    public Map<String, Map<String, String>> loadTranslationsLists(File xliffFile) {
        File locallng = this.getScratchFile(xliffFile);
        if (xliffFile.getName().toLowerCase(Locale.ROOT).endsWith(".xlf") || xliffFile.getName().toLowerCase(Locale.ROOT).endsWith(".xliff")) {
            if (locallng.exists()) {
                Map<String, Map<String, String>> mergedList = this.loadTranslationsListsFromXliff(xliffFile);
                Map<String, Map<String, String>> tmplist = this.loadTranslationsListsFromXliff(locallng);
                return this.mergeTranslationLists(mergedList, tmplist);
            }
            return this.loadTranslationsListsFromXliff(xliffFile);
        }
        if (locallng.exists()) {
            Map<String, Map<String, String>> mergedList = super.loadTranslationsLists(xliffFile);
            Map<String, Map<String, String>> tmplist = super.loadTranslationsLists(locallng);
            return this.mergeTranslationLists(mergedList, tmplist);
        }
        return super.loadTranslationsLists(xliffFile);
    }

    protected Map<String, Map<String, String>> mergeTranslationLists(Map<String, Map<String, String>> masterTrans, Map<String, Map<String, String>> localTrans) {
        if (localTrans != null && !localTrans.isEmpty()) {
            for (String transfilename : localTrans.keySet()) {
                Map<String, String> origList = localTrans.get(transfilename);
                if (masterTrans.containsKey(transfilename)) {
                    Map<String, String> xliffList = masterTrans.get(transfilename);
                    xliffList.putAll(origList);
                    continue;
                }
                masterTrans.put(transfilename, origList);
            }
        }
        return masterTrans;
    }

    public boolean saveAsXliff(String targetLanguageCode, File xliffFile, Map<String, Map<String, String>> lng) {
        String sourceLanguage = "en";
        try (FileOutputStream fileOutStream = new FileOutputStream(xliffFile);
             OutputStreamWriter output = new OutputStreamWriter((OutputStream)fileOutStream, StandardCharsets.UTF_8.name());){
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            output.write("<xliff version='1.2' xmlns='urn:oasis:names:tc:xliff:document:1.2'> \n");
            for (String afilemap : lng.keySet()) {
                output.write("<file original=\"" + afilemap + "\"  source-language=\"" + "en" + "\" ");
                if (targetLanguageCode != null && !targetLanguageCode.isEmpty()) {
                    output.write(" target-language=\"" + targetLanguageCode + "\" ");
                }
                output.write(" datatype=\"html\">\n");
                output.write("  <body>\n");
                Map<String, String> txtmap = lng.get(afilemap);
                for (String source : txtmap.keySet()) {
                    String target = txtmap.get(source);
                    output.write("    <trans-unit id=\"" + Integer.toHexString(source.hashCode()) + "\" xml:space=\"preserve\" approved=\"no\"");
                    if (target == null || target.isEmpty()) {
                        output.write(" translate=\"yes\">\n");
                        output.write("       <source>" + this.toXmlStr(source) + "</source>\n");
                    } else {
                        output.write(">\n");
                        output.write("       <source>" + this.toXmlStr(source) + "</source>\n");
                        output.write("       <target" + (target.equals(source) ? "" : " state='translated'") + ">" + this.toXmlStr(target) + "</target>\n");
                    }
                    output.write("    </trans-unit>\n");
                }
                output.write("  </body>\n");
                output.write("</file>\n\n");
            }
            output.write("</xliff>\n");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void writeFileSection(String filename, Map<String, String> textlist, OutputStreamWriter output) throws IOException {
        if (!filename.isEmpty()) {
            output.write("#File: " + filename + "\n#---------------------------\n");
            for (String source : textlist.keySet()) {
                String target = textlist.get(source);
                if (target != null && !target.isEmpty()) {
                    if (source.equals(target)) {
                        output.write("#" + source + "==" + target + "\n");
                        continue;
                    }
                    output.write(source + "==" + target + "\n");
                    continue;
                }
                output.write("#" + source + "==" + source + "\n");
            }
            output.write("#-----------------------------\n\n");
        }
    }

    public boolean saveAsLngFile(String targetLanguageCode, File lngFile, Map<String, Map<String, String>> lng) {
        try (FileOutputStream fileOutStream = new FileOutputStream(lngFile);
             OutputStreamWriter output = new OutputStreamWriter((OutputStream)fileOutStream, StandardCharsets.UTF_8.name());){
            output.write("# " + (targetLanguageCode == null ? "master" : targetLanguageCode) + ".lng\n");
            output.write("# -----------------------\n");
            output.write("# This is a part of YaCy, a peer-to-peer based web search engine\n\n");
            output.write("# Each translation list starts with #File: relative/path/to/file\n");
            output.write("# followed by the translations  OriginalText==TranslatedText (in one line)\n");
            output.write("# Comment lines or not translated lines start with #\n\n");
            Map<String, String> txtmap = lng.get("ConfigLanguage_p.html");
            if (txtmap != null) {
                this.writeFileSection("ConfigLanguage_p.html", txtmap, output);
            }
            for (String afilemap : lng.keySet()) {
                txtmap = lng.get(afilemap);
                if ("ConfigLanguage_p.html".equals(afilemap)) continue;
                this.writeFileSection(afilemap, txtmap, output);
            }
            output.write("# EOF");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String toXmlStr(String s) {
        int control = s.indexOf("&");
        while (control >= 0) {
            if (control < (s = s.substring(0, control) + "&amp;" + s.substring(control + 1)).length()) {
                ++control;
            }
            control = s.indexOf("&", control);
        }
        control = s.indexOf("<");
        while (control >= 0) {
            if (control < (s = s.substring(0, control) + "&lt;" + s.substring(control + 1)).length()) {
                ++control;
            }
            control = s.indexOf("<", control);
        }
        control = s.indexOf(">");
        while (control >= 0) {
            if (control < (s = s.substring(0, control) + "&gt;" + s.substring(control + 1)).length()) {
                ++control;
            }
            control = s.indexOf(">", control);
        }
        return s;
    }

    public File getScratchFile(File langFile) {
        if (Switchboard.getSwitchboard() != null) {
            File f = Switchboard.getSwitchboard().getDataPath("locale.translated_html", "DATA/LOCALE");
            return new File(f.getParentFile(), langFile.getName());
        }
        return langFile;
    }
}

