/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.util.Locale;

public abstract class TranslatorUtil {
    protected static File getSourceDir(String[] args, int argIndex) {
        File sourceDir;
        if (args.length > argIndex && argIndex >= 0) {
            sourceDir = new File(args[argIndex]);
        } else {
            String workingDir = System.getProperty("user.dir");
            if (workingDir == null) {
                throw new IllegalArgumentException("No translation file specified, and default not found");
            }
            sourceDir = new File(workingDir, "htroot");
            if (!sourceDir.exists() && !sourceDir.isDirectory()) {
                throw new IllegalArgumentException("No translation file specified, and default not found : " + sourceDir.getPath());
            }
        }
        return sourceDir;
    }

    protected static File getTranslationFile(String[] args, int argIndex) {
        File translationFile;
        if (args.length > argIndex && argIndex >= 0) {
            translationFile = new File(args[argIndex]);
        } else {
            String workingDir = System.getProperty("user.dir");
            if (workingDir == null) {
                throw new IllegalArgumentException("No translation file specified, and default not found");
            }
            translationFile = new File(workingDir, "locales" + File.separator + Locale.getDefault().getLanguage() + ".lng");
            if (!translationFile.exists()) {
                throw new IllegalArgumentException("No translation file specified, and default not found : " + translationFile.getPath());
            }
        }
        return translationFile;
    }

    protected static String getExtensions(String[] args, int argIndex) {
        String extensions = args.length > argIndex && argIndex >= 0 ? args[argIndex] : "html,template,inc";
        return extensions;
    }
}

