/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.util.ConcurrentLog;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class tarTools {
    public static InputStream getInputStream(String tarPath) throws FileNotFoundException {
        if (tarPath.endsWith(".gz")) {
            FileInputStream fileInStream = null;
            try {
                fileInStream = new FileInputStream(new File(tarPath));
                return new GZIPInputStream(fileInStream);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                if (fileInStream != null) {
                    try {
                        fileInStream.close();
                    }
                    catch (IOException e1) {
                        ConcurrentLog.warn("UNTAR", "Could not close input stream on file " + tarPath);
                    }
                }
                return new FileInputStream(new File(tarPath));
            }
        }
        return new FileInputStream(new File(tarPath));
    }

    public static InputStream getInputStream(File tarFile) throws Exception {
        return tarTools.getInputStream(tarFile.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unTar(InputStream in, String untarDir) throws IOException {
        ConcurrentLog.info("UNTAR", "starting");
        if (new File(untarDir).exists()) {
            TarArchiveInputStream tin = new TarArchiveInputStream(in);
            try {
                TarArchiveEntry tarEntry = tin.getNextTarEntry();
                if (tarEntry == null) {
                    throw new IOException("tar archive is empty or corrupted");
                }
                while (tarEntry != null) {
                    File destPath = new File(untarDir + File.separator + tarEntry.getName());
                    if (!tarEntry.isDirectory()) {
                        new File(destPath.getParent()).mkdirs();
                        try (FileOutputStream fout = new FileOutputStream(destPath);){
                            IOUtils.copyLarge((InputStream)tin, (OutputStream)fout, (long)0L, (long)tarEntry.getSize());
                        }
                    } else {
                        destPath.mkdir();
                    }
                    tarEntry = tin.getNextTarEntry();
                }
            }
            finally {
                try {
                    tin.close();
                }
                catch (IOException ignored) {
                    ConcurrentLog.warn("UNTAR", "InputStream could not be closed");
                }
            }
        }
        ConcurrentLog.warn("UNTAR", "destination " + untarDir + " doesn't exist.");
        try {
            in.close();
        }
        catch (IOException ignored) {
            ConcurrentLog.warn("UNTAR", "InputStream could not be closed");
        }
        throw new FileNotFoundException("Output untar directory not found : " + untarDir);
        ConcurrentLog.info("UNTAR", "finished");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 2) {
                try {
                    tarTools.unTar(tarTools.getInputStream(args[0]), args[1]);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else {
                System.out.println("usage: <source> <destination>");
            }
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }
}

