/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.util.Formatter;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.json.JSONObject;

public class serverObjects
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3999165204849858546L;
    public static final String ACTION_AUTHENTICATE = "AUTHENTICATE";
    public static final String ACTION_LOCATION = "LOCATION";
    public static final String ADMIN_AUTHENTICATE_MSG = "admin log-in. If you don't know the password, set it with {yacyhome}/bin/passwd.sh {newpassword}";
    private static final Pattern patternNewline = Pattern.compile("\n");
    private boolean localized = true;
    private static final char BOM = '\ufeff';
    private final MultiMapSolrParams map;

    public serverObjects() {
        this.map = new MultiMapSolrParams(new HashMap());
    }

    protected serverObjects(serverObjects o) {
        this.map = o.map;
    }

    protected serverObjects(Map<String, String[]> input) {
        this.map = new MultiMapSolrParams(input);
    }

    public void authenticationRequired() {
        this.put(ACTION_AUTHENTICATE, ADMIN_AUTHENTICATE_MSG);
    }

    public int size() {
        return this.map.toNamedList().size() / 2;
    }

    public void clear() {
        this.map.getMap().clear();
    }

    public boolean isEmpty() {
        return this.map.getMap().isEmpty();
    }

    private static final String removeByteOrderMark(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.charAt(0) == '\ufeff') {
            return s.substring(1);
        }
        return s;
    }

    public boolean containsKey(String key) {
        String[] arr = this.map.getParams(key);
        return arr != null && arr.length > 0;
    }

    public MultiMapSolrParams getSolrParams() {
        return this.map;
    }

    public List<Map.Entry<String, String>> entrySet() {
        ArrayList<Map.Entry<String, String>> set = new ArrayList<Map.Entry<String, String>>(this.map.getMap().size() * 2);
        Set mset = this.map.getMap().entrySet();
        for (Map.Entry entry2 : mset) {
            String[] vlist;
            for (String v : vlist = (String[])entry2.getValue()) {
                set.add(new AbstractMap.SimpleEntry<String, String>((String)entry2.getKey(), v));
            }
        }
        return set;
    }

    public Set<String> values() {
        HashSet<String> set = new HashSet<String>(this.map.getMap().size() * 2);
        for (Map.Entry entry2 : this.map.getMap().entrySet()) {
            for (String v : (String[])entry2.getValue()) {
                set.add(v);
            }
        }
        return set;
    }

    public Set<String> keySet() {
        return this.map.getMap().keySet();
    }

    public String[] remove(String key) {
        return (String[])this.map.getMap().remove(key);
    }

    public int remove(String key, int dflt) {
        String result = serverObjects.removeByteOrderMark(this.get(key));
        this.map.getMap().remove(key);
        if (result == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void add(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        String[] a = (String[])this.map.getMap().get(key);
        if (a == null) {
            this.map.getMap().put(key, new String[]{value});
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(value)) continue;
            return;
        }
        String[] aa = new String[a.length + 1];
        System.arraycopy(a, 0, aa, 0, a.length);
        aa[a.length] = value;
        this.map.getMap().put(key, aa);
    }

    public void put(String key, boolean value) {
        this.put(key, value ? "1" : "0");
    }

    public void put(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.map.getMap().remove(key);
            return;
        }
        String[] a = (String[])this.map.getMap().get(key);
        if (a == null) {
            this.map.getMap().put(key, new String[]{value});
            return;
        }
        this.map.getMap().put(key, new String[]{value});
    }

    public void add(String key, byte[] value) {
        if (value == null) {
            return;
        }
        this.add(key, UTF8.String(value));
    }

    public void put(String key, byte[] value) {
        if (value == null) {
            return;
        }
        this.put(key, UTF8.String(value));
    }

    public void put(String key, String[] values) {
        if (key == null) {
            return;
        }
        if (values == null) {
            this.map.getMap().remove(key);
            return;
        }
        this.map.getMap().put(key, values);
    }

    public void put(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void put(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void put(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void put(String key, Date value) {
        this.put(key, value.toString());
    }

    public void put(String key, InetAddress value) {
        this.put(key, value.toString());
    }

    public void putJSON(String key, String value) {
        value = JSONObject.quote(value);
        value = value.substring(1, value.length() - 1);
        this.put(key, value);
    }

    public void putHTML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2html(UTF8.decodeURL(value), true));
    }

    public void putHTML(String key, byte[] value) {
        this.putHTML(key, value == null ? "" : UTF8.String(value));
    }

    public void putUrlEncodedHTML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2html(value, true));
    }

    public void putXML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2xml(value, true));
    }

    public void put(RequestHeader.FileType fileType, String key, String value) {
        if (fileType == RequestHeader.FileType.JSON) {
            this.putJSON(key, value == null ? "" : value);
        } else if (fileType == RequestHeader.FileType.XML) {
            this.putXML(key, value == null ? "" : value);
        } else {
            this.putHTML(key, value == null ? "" : value);
        }
    }

    public void putUrlEncoded(RequestHeader.FileType fileType, String key, String value) {
        if (fileType == RequestHeader.FileType.JSON) {
            this.putJSON(key, value == null ? "" : value);
        } else if (fileType == RequestHeader.FileType.XML) {
            this.putXML(key, value == null ? "" : value);
        } else {
            this.putUrlEncodedHTML(key, value == null ? "" : value);
        }
    }

    public void putNum(String key, long value) {
        this.put(key, Formatter.number(value, this.localized));
    }

    public void putNum(String key, double value) {
        this.put(key, Formatter.number(value, this.localized));
    }

    public void putNum(String key, String value) {
        this.put(key, value == null ? "" : Formatter.number(value));
    }

    public void putWiki(String hostport, String key, String wikiCode) {
        this.put(key, Switchboard.wikiParser.transform(hostport, wikiCode));
    }

    public void putWiki(String key, String wikiCode) {
        this.putWiki(null, key, wikiCode);
    }

    public void putWiki(String hostport, String key, byte[] wikiCode) {
        try {
            this.put(key, Switchboard.wikiParser.transform(hostport, wikiCode));
        }
        catch (UnsupportedEncodingException e) {
            this.put(key, "Internal error pasting wiki-code: " + e.getMessage());
        }
    }

    public void putWiki(String key, byte[] wikiCode) {
        this.putWiki(null, key, wikiCode);
    }

    public long inc(String key) {
        String c = this.get(key);
        if (c == null) {
            c = "0";
        }
        long l = Long.parseLong(c) + 1L;
        this.put(key, Long.toString(l));
        return l;
    }

    public String[] getParams(String name) {
        return (String[])this.map.getMap().get(name);
    }

    public String get(String name) {
        String[] arr = (String[])this.map.getMap().get(name);
        return arr == null || arr.length == 0 ? null : arr[0];
    }

    public Object get(String key, Object dflt) {
        String result = this.get(key);
        return result == null ? dflt : result;
    }

    public String get(String key, String dflt) {
        String result = serverObjects.removeByteOrderMark(this.get(key));
        return result == null ? dflt : result;
    }

    public int getInt(String key, int dflt) {
        String s = serverObjects.removeByteOrderMark(this.get(key));
        if (s == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public long getLong(String key, long dflt) {
        String s = serverObjects.removeByteOrderMark(this.get(key));
        if (s == null) {
            return dflt;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public float getFloat(String key, float dflt) {
        String s = serverObjects.removeByteOrderMark(this.get(key));
        if (s == null) {
            return dflt;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public double getDouble(String key, double dflt) {
        String s = serverObjects.removeByteOrderMark(this.get(key));
        if (s == null) {
            return dflt;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean getBoolean(String key) {
        String s = serverObjects.removeByteOrderMark(this.get(key));
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase(Locale.ROOT)).equals("true") || s.equals("on") || s.equals("1");
    }

    public String[] getAll(String keyMapper) throws PatternSyntaxException {
        ArrayList<String> v = new ArrayList<String>();
        Pattern keyPattern = Pattern.compile(keyMapper);
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            if (!keyPattern.matcher(entry2.getKey()).matches()) continue;
            v.add(entry2.getValue());
        }
        return v.toArray(new String[0]);
    }

    public Map<String, String> getMatchingEntries(String keyMapper) throws PatternSyntaxException {
        Pattern keyPattern = Pattern.compile(keyMapper);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            if (!keyPattern.matcher(entry2.getKey()).matches()) continue;
            map.put(entry2.getKey(), entry2.getValue());
        }
        return map;
    }

    public void putAll(serverObjects add) {
        for (Map.Entry<String, String> entry2 : add.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File f) throws IOException {
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(f));
            StringBuilder line = new StringBuilder(64);
            for (Map.Entry<String, String> entry2 : this.entrySet()) {
                line.delete(0, line.length());
                line.append(entry2.getKey());
                line.append("=");
                line.append(patternNewline.matcher(entry2.getValue()).replaceAll("\\\\n"));
                line.append("\r\n");
                fos.write(UTF8.getBytes(line.toString()));
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setLocalized(boolean loc) {
        this.localized = loc;
    }

    public Object clone() {
        return new serverObjects(this.map.getMap());
    }

    public String toString() {
        if (this.map.getMap().isEmpty()) {
            return "";
        }
        StringBuilder param = new StringBuilder(this.map.getMap().size() * 40);
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            param.append((CharSequence)MultiProtocolURL.escape(entry2.getKey())).append('=').append((CharSequence)MultiProtocolURL.escape(entry2.getValue())).append('&');
        }
        param.setLength(param.length() - 1);
        return param.toString();
    }

    public MultiMapSolrParams toSolrParams(CollectionSchema[] facets) {
        if (!this.containsKey("df")) {
            this.put("df", CollectionSchema.text_t.getSolrFieldName());
        }
        if (!this.containsKey("start")) {
            this.put("start", "0");
        }
        if (!this.containsKey("rows")) {
            this.put("rows", "10");
        }
        if (facets != null && facets.length > 0) {
            this.remove("facet");
            this.put("facet", "true");
            for (int i = 0; i < facets.length; ++i) {
                this.add("facet.field", facets[i].getSolrFieldName());
            }
        }
        return this.map;
    }
}

