/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.schema;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.SolrType;
import org.apache.solr.common.SolrInputDocument;

public final class WebgraphSchema
extends Enum<WebgraphSchema>
implements SchemaDeclaration {
    public static final /* enum */ WebgraphSchema id = new WebgraphSchema(SolrType.string, true, true, false, false, false, "primary key of document, a combination of <source-url-hash><target-url-hash><four-digit-hex-counter> (28 characters)");
    public static final /* enum */ WebgraphSchema last_modified = new WebgraphSchema(SolrType.date, true, true, false, false, false, "last-modified from http header");
    public static final /* enum */ WebgraphSchema load_date_dt = new WebgraphSchema(SolrType.date, true, true, false, false, false, "time when resource was loaded");
    public static final /* enum */ WebgraphSchema collection_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "tags that are attached to crawls/index generation to separate the search result into user-defined subsets");
    public static final /* enum */ WebgraphSchema process_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "needed (post-)processing steps on this metadata set.");
    public static final /* enum */ WebgraphSchema harvestkey_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "key from a harvest process (i.e. the crawl profile hash key) which is needed for near-realtime postprocessing. This shall be deleted as soon as postprocessing has been terminated.");
    public static final /* enum */ WebgraphSchema source_id_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "primary key of document, the URL hash (source)");
    public static final /* enum */ WebgraphSchema source_protocol_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the protocol of the url (source)");
    public static final /* enum */ WebgraphSchema source_urlstub_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the url without the protocol (source)");
    public static final /* enum */ WebgraphSchema source_file_name_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the file name without the extension (source)");
    public static final /* enum */ WebgraphSchema source_file_ext_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the file name extension (source)");
    public static final /* enum */ WebgraphSchema source_chars_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "number of all characters in the url (source)");
    public static final /* enum */ WebgraphSchema source_path_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "path of the url (source)");
    public static final /* enum */ WebgraphSchema source_path_folders_count_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "count of all path elements in the url (source)");
    public static final /* enum */ WebgraphSchema source_path_folders_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "all path elements in the url without the file name (source)");
    public static final /* enum */ WebgraphSchema source_parameter_count_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "number of key-value pairs in search part of the url (source)");
    public static final /* enum */ WebgraphSchema source_parameter_key_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "the keys from key-value pairs in the search part of the url (source)");
    public static final /* enum */ WebgraphSchema source_parameter_value_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "the values from key-value pairs in the search part of the url (source)");
    public static final /* enum */ WebgraphSchema source_crawldepth_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "depth of web page according to number of clicks from the 'main' page, which is the page that appears if only the host is entered as url (source)");
    public static final /* enum */ WebgraphSchema source_cr_host_norm_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "copy of the citation rank norm value from the source link");
    public static final /* enum */ WebgraphSchema source_host_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "host of the url (source)");
    public static final /* enum */ WebgraphSchema source_host_id_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "id of the host (source)");
    public static final /* enum */ WebgraphSchema source_host_dnc_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the Domain Class Name, either the TLD or a combination of ccSLD+TLD if a ccSLD is used (source)");
    public static final /* enum */ WebgraphSchema source_host_organization_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "either the second level domain or, if a ccSLD is used, the third level domain");
    public static final /* enum */ WebgraphSchema source_host_organizationdnc_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the organization and dnc concatenated with '.' (source)");
    public static final /* enum */ WebgraphSchema source_host_subdomain_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the remaining part of the host without organizationdnc (source)");
    public static final /* enum */ WebgraphSchema target_linktext_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "the text content of the a-tag (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_linktext_charcount_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "the length of the a-tag content text as number of characters (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_linktext_wordcount_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "the length of the a-tag content text as number of words (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_alt_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "if the link is an image link, this contains the alt tag if the image is also liked as img link (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_alt_charcount_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "the length of the a-tag content text as number of characters (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_alt_wordcount_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "the length of the a-tag content text as number of words (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_name_t = new WebgraphSchema(SolrType.text_general, true, true, false, false, true, "the name property of the a-tag (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_rel_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the rel property of the a-tag (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_relflags_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "the rel property of the a-tag, coded binary (in source, but pointing to a target)");
    public static final /* enum */ WebgraphSchema target_id_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "primary key of document, the URL hash (target)");
    public static final /* enum */ WebgraphSchema target_order_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "order number of target url, a count from first to last URL on the source page (target)");
    public static final /* enum */ WebgraphSchema target_protocol_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the protocol of the url (target)");
    public static final /* enum */ WebgraphSchema target_urlstub_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the url without the protocol (target)");
    public static final /* enum */ WebgraphSchema target_file_name_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "the file name without the extension (target)");
    public static final /* enum */ WebgraphSchema target_file_ext_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "the file name extension (target)");
    public static final /* enum */ WebgraphSchema target_chars_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "number of all characters in the url (target)");
    public static final /* enum */ WebgraphSchema target_path_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "path of the url (target)");
    public static final /* enum */ WebgraphSchema target_path_folders_count_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "count of all path elements in the url (target)");
    public static final /* enum */ WebgraphSchema target_path_folders_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, true, "all path elements in the url without the file name (target)");
    public static final /* enum */ WebgraphSchema target_parameter_count_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "number of key-value pairs in search part of the url (target)");
    public static final /* enum */ WebgraphSchema target_parameter_key_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, false, "the keys from key-value pairs in the search part of the url (target)");
    public static final /* enum */ WebgraphSchema target_parameter_value_sxt = new WebgraphSchema(SolrType.string, true, true, true, false, true, "the values from key-value pairs in the search part of the url (target)");
    public static final /* enum */ WebgraphSchema target_crawldepth_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "depth of web page according to number of clicks from the 'main' page, which is the page that appears if only the host is entered as url (target)");
    public static final /* enum */ WebgraphSchema target_cr_host_norm_i = new WebgraphSchema(SolrType.num_integer, true, true, false, false, false, "copy of the citation rank norm value from the target link; this is only filled if the target host is identical to the source host");
    public static final /* enum */ WebgraphSchema target_host_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "host of the url (target)");
    public static final /* enum */ WebgraphSchema target_host_id_s = new WebgraphSchema(SolrType.string, true, true, false, false, false, "id of the host (target)");
    public static final /* enum */ WebgraphSchema target_host_dnc_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "the Domain Class Name, either the TLD or a combination of ccSLD+TLD if a ccSLD is used (target)");
    public static final /* enum */ WebgraphSchema target_host_organization_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "either the second level domain or, if a ccSLD is used, the third level domain (target)");
    public static final /* enum */ WebgraphSchema target_host_organizationdnc_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "the organization and dnc concatenated with '.' (target)");
    public static final /* enum */ WebgraphSchema target_host_subdomain_s = new WebgraphSchema(SolrType.string, true, true, false, false, true, "the remaining part of the host without organizationdnc (target)");
    public static final /* enum */ WebgraphSchema target_inbound_b = new WebgraphSchema(SolrType.bool, true, true, false, false, false, "flag shows if the target host is equal to the source host");
    public static final String CORE_NAME = "webgraph";
    public static final String VOCABULARY_PREFIX = "vocabulary_";
    public static final String VOCABULARY_SUFFIX = "_sxt";
    private String solrFieldName = null;
    private final SolrType type;
    private final boolean indexed;
    private final boolean stored;
    private final boolean multiValued;
    private final boolean omitNorms;
    private final boolean searchable;
    private final boolean docValues;
    private String comment;
    private static final /* synthetic */ WebgraphSchema[] $VALUES;

    public static WebgraphSchema[] values() {
        return (WebgraphSchema[])$VALUES.clone();
    }

    public static WebgraphSchema valueOf(String name) {
        return Enum.valueOf(WebgraphSchema.class, name);
    }

    private WebgraphSchema(SolrType type, boolean indexed, boolean stored, boolean multiValued, boolean omitNorms, boolean searchable, String comment) {
        this.type = type;
        this.indexed = indexed;
        this.stored = stored;
        this.multiValued = multiValued;
        this.omitNorms = omitNorms;
        this.searchable = searchable;
        this.comment = comment;
        this.docValues = type == SolrType.string || type == SolrType.date || type.name().startsWith("num_");
        String name = this.name();
        int p = name.indexOf(95);
        if (p > 0) {
            String ext = name.substring(p + 1);
            assert (!ext.equals("i") || type == SolrType.num_integer && !multiValued) : name;
            assert (!ext.equals("l") || type == SolrType.num_long && !multiValued) : name;
            assert (!ext.equals("b") || type == SolrType.bool && !multiValued) : name;
            assert (!ext.equals("s") || type == SolrType.string && !multiValued) : name;
            assert (!ext.equals("sxt") || type == SolrType.string && multiValued) : name;
            assert (!ext.equals("dt") || type == SolrType.date && !multiValued) : name;
            assert (!ext.equals("t") || type == SolrType.text_general && !multiValued) : name;
            assert (!ext.equals("coordinate") || type == SolrType.coordinate && !multiValued) : name;
            assert (!ext.equals("txt") || type == SolrType.text_general && multiValued) : name;
            assert (!ext.equals("val") || type == SolrType.num_integer && multiValued) : name;
            assert (!ext.equals("d") || type == SolrType.num_double && !multiValued) : name;
        }
        assert (type.appropriateName(this)) : "bad configuration: " + this.name();
    }

    @Override
    public final String getSolrFieldName() {
        return this.solrFieldName == null ? this.name() : this.solrFieldName;
    }

    @Override
    public final void setSolrFieldName(String theValue) {
        this.solrFieldName = theValue != null && !theValue.isEmpty() ? theValue.toLowerCase(Locale.ROOT) : null;
    }

    @Override
    public final SolrType getType() {
        return this.type;
    }

    @Override
    public final boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public final boolean isStored() {
        return this.stored;
    }

    @Override
    public final boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public final boolean isOmitNorms() {
        return this.omitNorms;
    }

    @Override
    public final boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public boolean isDocValue() {
        return this.docValues;
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public final void add(SolrInputDocument doc, String value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Date value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.date);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, int value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.num_integer);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, long value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.num_long);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Date[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, String[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Integer[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, List<?> value) {
        assert (this.isMultiValued());
        if (value == null || value.size() == 0) {
            if (this.type == SolrType.num_integer) {
                doc.setField(this.getSolrFieldName(), (Object)new Integer[0]);
            } else if (this.type == SolrType.string) {
                doc.setField(this.getSolrFieldName(), (Object)new String[0]);
            } else {
                assert (false);
                doc.setField(this.getSolrFieldName(), (Object)new Object[0]);
            }
            return;
        }
        if (this.type == SolrType.num_integer) {
            assert (value.iterator().next() instanceof Integer);
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new Integer[value.size()]));
        } else if (this.type == SolrType.string || this.type == SolrType.text_general) {
            assert (value.iterator().next() instanceof String);
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new String[value.size()]));
        } else {
            assert (false) : "ADD: type is " + this.type.name();
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new Object[value.size()]));
        }
    }

    @Override
    public final void add(SolrInputDocument doc, float value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)Float.valueOf(value));
    }

    @Override
    public final void add(SolrInputDocument doc, double value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, boolean value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void remove(SolrInputDocument doc) {
        doc.removeField(this.getSolrFieldName());
    }

    static {
        $VALUES = new WebgraphSchema[]{id, last_modified, load_date_dt, collection_sxt, process_sxt, harvestkey_s, source_id_s, source_protocol_s, source_urlstub_s, source_file_name_s, source_file_ext_s, source_chars_i, source_path_s, source_path_folders_count_i, source_path_folders_sxt, source_parameter_count_i, source_parameter_key_sxt, source_parameter_value_sxt, source_crawldepth_i, source_cr_host_norm_i, source_host_s, source_host_id_s, source_host_dnc_s, source_host_organization_s, source_host_organizationdnc_s, source_host_subdomain_s, target_linktext_s, target_linktext_charcount_i, target_linktext_wordcount_i, target_alt_s, target_alt_charcount_i, target_alt_wordcount_i, target_name_t, target_rel_s, target_relflags_i, target_id_s, target_order_i, target_protocol_s, target_urlstub_s, target_file_name_s, target_file_ext_s, target_chars_i, target_path_s, target_path_folders_count_i, target_path_folders_sxt, target_parameter_count_i, target_parameter_key_sxt, target_parameter_value_sxt, target_crawldepth_i, target_cr_host_norm_i, target_host_s, target_host_id_s, target_host_dnc_s, target_host_organization_s, target_host_organizationdnc_s, target_host_subdomain_s, target_inbound_b};
    }
}

