/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.schema;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.SolrType;
import org.apache.poi.ss.formula.atp.DateParser;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.solr.common.SolrInputDocument;

public final class CollectionSchema
extends Enum<CollectionSchema>
implements SchemaDeclaration {
    public static final /* enum */ CollectionSchema id = new CollectionSchema(SolrType.string, true, true, false, false, false, "primary key of document, the URL hash **mandatory field**", true);
    public static final /* enum */ CollectionSchema sku = new CollectionSchema(SolrType.string, true, true, false, true, true, "url of document", true);
    public static final /* enum */ CollectionSchema last_modified = new CollectionSchema(SolrType.date, true, true, false, false, false, "last-modified from http header", true);
    public static final /* enum */ CollectionSchema load_date_dt = new CollectionSchema(SolrType.date, true, true, false, false, false, "time when resource was loaded", true);
    public static final /* enum */ CollectionSchema content_type = new CollectionSchema(SolrType.string, true, true, true, false, false, "mime-type of document", true);
    public static final /* enum */ CollectionSchema title = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "content of title tag", true);
    public static final /* enum */ CollectionSchema host_id_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "id of the host, a 6-byte hash that is part of the document id", true);
    public static final /* enum */ CollectionSchema host_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "host of the url", true);
    public static final /* enum */ CollectionSchema size_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "the size of the raw source", true);
    public static final /* enum */ CollectionSchema failreason_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "fail reason if a page was not loaded. if the page was loaded then this field is empty", true);
    public static final /* enum */ CollectionSchema failtype_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "fail type if a page was not loaded. This field is either empty, 'excl' or 'fail'", true);
    public static final /* enum */ CollectionSchema httpstatus_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "html status return code (i.e. \"200\" for ok), -1 if not loaded", true);
    public static final /* enum */ CollectionSchema url_file_ext_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "the file name extension", true);
    public static final /* enum */ CollectionSchema host_organization_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "either the second level domain or, if a ccSLD is used, the third level domain", true);
    public static final /* enum */ CollectionSchema inboundlinks_urlstub_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "internal links, the url only without the protocol", true);
    public static final /* enum */ CollectionSchema inboundlinks_protocol_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "internal links, only the protocol", true);
    public static final /* enum */ CollectionSchema outboundlinks_protocol_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "external links, only the protocol", true);
    public static final /* enum */ CollectionSchema outboundlinks_urlstub_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "external links, the url only without the protocol", true);
    public static final /* enum */ CollectionSchema images_urlstub_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "all image links without the protocol and '://'", true);
    public static final /* enum */ CollectionSchema images_protocol_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "all image link protocols", true);
    public static final /* enum */ CollectionSchema fresh_date_dt = new CollectionSchema(SolrType.date, true, true, false, false, false, "date until resource shall be considered as fresh");
    public static final /* enum */ CollectionSchema referrer_id_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "id of the referrer to this document, discovered during crawling");
    public static final /* enum */ CollectionSchema publisher_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "the name of the publisher of the document");
    public static final /* enum */ CollectionSchema language_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "the language used in the document");
    public static final /* enum */ CollectionSchema audiolinkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of links to audio resources");
    public static final /* enum */ CollectionSchema videolinkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of links to video resources");
    public static final /* enum */ CollectionSchema applinkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of links to application resources");
    public static final /* enum */ CollectionSchema title_exact_signature_l = new CollectionSchema(SolrType.num_long, true, true, false, false, false, "the 64 bit hash of the org.apache.solr.update.processor.Lookup3Signature of title, used to compute title_unique_b");
    public static final /* enum */ CollectionSchema title_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag shows if title is unique within all indexable documents of the same host with status code 200; if yes and another document appears with same title, the unique-flag is set to false");
    public static final /* enum */ CollectionSchema exact_signature_copycount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "counter for the number of documents which are not unique (== count of not-unique-flagged documents + 1)");
    public static final /* enum */ CollectionSchema fuzzy_signature_text_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "intermediate data produced in EnhancedTextProfileSignature: a list of word frequencies");
    public static final /* enum */ CollectionSchema fuzzy_signature_copycount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "counter for the number of documents which are not unique (== count of not-unique-flagged documents + 1)");
    public static final /* enum */ CollectionSchema process_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "needed (post-)processing steps on this metadata set");
    public static final /* enum */ CollectionSchema dates_in_content_dts = new CollectionSchema(SolrType.date, true, true, true, false, true, "if date expressions can be found in the content, these dates are listed here as date objects in order of the appearances");
    public static final /* enum */ CollectionSchema dates_in_content_count_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "the number of entries in dates_in_content_sxt");
    public static final /* enum */ CollectionSchema startDates_dts = new CollectionSchema(SolrType.date, true, true, true, false, true, "content of itemprop attributes with content='startDate'");
    public static final /* enum */ CollectionSchema endDates_dts = new CollectionSchema(SolrType.date, true, true, true, false, true, "content of itemprop attributes with content='endDate'");
    public static final /* enum */ CollectionSchema references_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of unique http references, should be equal to references_internal_i + references_external_i");
    public static final /* enum */ CollectionSchema references_internal_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of unique http references from same host to referenced url");
    public static final /* enum */ CollectionSchema references_external_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of unique http references from external hosts");
    public static final /* enum */ CollectionSchema references_exthosts_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of external hosts which provide http references");
    public static final /* enum */ CollectionSchema crawldepth_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "crawl depth of web page according to the number of steps that the crawler did to get to this document; if the crawl was started at a root document, then this is equal to the clickdepth");
    public static final /* enum */ CollectionSchema harvestkey_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "key from a harvest process (i.e. the crawl profile hash key) which is needed for near-realtime postprocessing. This shall be deleted as soon as postprocessing has been terminated.");
    public static final /* enum */ CollectionSchema http_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "unique-field which is true when an url appears the first time. If the same url which was http then appears as https (or vice versa) then the field is false");
    public static final /* enum */ CollectionSchema www_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "unique-field which is true when an url appears the first time. If the same url within the subdomain www then appears without that subdomain (or vice versa) then the field is false");
    public static final /* enum */ CollectionSchema exact_signature_l = new CollectionSchema(SolrType.num_long, true, true, false, false, false, "the 64 bit hash of the org.apache.solr.update.processor.Lookup3Signature of text_t");
    public static final /* enum */ CollectionSchema exact_signature_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag shows if exact_signature_l is unique at the time of document creation, used for double-check during search");
    public static final /* enum */ CollectionSchema fuzzy_signature_l = new CollectionSchema(SolrType.num_long, true, true, false, false, false, "64 bit of the Lookup3Signature from EnhancedTextProfileSignature of text_t");
    public static final /* enum */ CollectionSchema fuzzy_signature_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag shows if fuzzy_signature_l is unique at the time of document creation, used for double-check during search");
    public static final /* enum */ CollectionSchema coordinate_p = new CollectionSchema(SolrType.location, true, true, false, false, false, "point in degrees of latitude,longitude as declared in WSG84");
    public static final /* enum */ CollectionSchema coordinate_p_0_coordinate = new CollectionSchema(SolrType.coordinate, true, false, false, false, false, "automatically created subfield, (latitude)");
    public static final /* enum */ CollectionSchema coordinate_p_1_coordinate = new CollectionSchema(SolrType.coordinate, true, false, false, false, false, "automatically created subfield, (longitude)");
    public static final /* enum */ CollectionSchema ip_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "ip of host of url (after DNS lookup)");
    public static final /* enum */ CollectionSchema author = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "content of author-tag");
    public static final /* enum */ CollectionSchema author_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "content of author-tag as copy-field from author. This is used for facet generation");
    public static final /* enum */ CollectionSchema description_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "content of description-tag(s)");
    public static final /* enum */ CollectionSchema description_exact_signature_l = new CollectionSchema(SolrType.num_long, true, true, false, false, false, "the 64 bit hash of the org.apache.solr.update.processor.Lookup3Signature of description, used to compute description_unique_b");
    public static final /* enum */ CollectionSchema description_unique_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag shows if description is unique within all indexable documents of the same host with status code 200; if yes and another document appears with same description, the unique-flag is set to false");
    public static final /* enum */ CollectionSchema keywords = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "content of keywords tag; words are separated by space");
    public static final /* enum */ CollectionSchema charset_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "character encoding");
    public static final /* enum */ CollectionSchema wordcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of words in visible area");
    public static final /* enum */ CollectionSchema linkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of all outgoing links; including linksnofollowcount_i");
    public static final /* enum */ CollectionSchema linksnofollowcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of all outgoing inks with nofollow tag");
    public static final /* enum */ CollectionSchema inboundlinkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of outgoing inbound (to same domain) links; including inboundlinksnofollowcount_i");
    public static final /* enum */ CollectionSchema inboundlinksnofollowcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of outgoing inbound (to same domain) links with nofollow tag");
    public static final /* enum */ CollectionSchema outboundlinkscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of outgoing outbound (to other domain) links, including outboundlinksnofollowcount_i");
    public static final /* enum */ CollectionSchema outboundlinksnofollowcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of outgoing outbound (to other domain) links with nofollow tag");
    public static final /* enum */ CollectionSchema imagescount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of images");
    public static final /* enum */ CollectionSchema responsetime_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "response time of target server in milliseconds");
    public static final /* enum */ CollectionSchema text_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "all visible text");
    public static final /* enum */ CollectionSchema synonyms_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "additional synonyms to the words in the text");
    public static final /* enum */ CollectionSchema h1_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h1 header");
    public static final /* enum */ CollectionSchema h2_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h2 header");
    public static final /* enum */ CollectionSchema h3_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h3 header");
    public static final /* enum */ CollectionSchema h4_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h4 header");
    public static final /* enum */ CollectionSchema h5_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h5 header");
    public static final /* enum */ CollectionSchema h6_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "h6 header");
    @Deprecated
    public static final /* enum */ CollectionSchema md5_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "the md5 of the raw source");
    @Deprecated
    public static final /* enum */ CollectionSchema httpstatus_redirect_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "redirect url if the error code is 299 < httpstatus_i < 310");
    public static final /* enum */ CollectionSchema collection_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "tags that are attached to crawls/index generation to separate the search result into user-defined subsets");
    public static final /* enum */ CollectionSchema csscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of entries in css_tag_txt and css_url_txt");
    public static final /* enum */ CollectionSchema css_tag_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "full css tag with normalized url");
    public static final /* enum */ CollectionSchema css_url_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "normalized urls within a css tag");
    public static final /* enum */ CollectionSchema scripts_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "normalized urls within a scripts tag");
    public static final /* enum */ CollectionSchema scriptscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of entries in scripts_sxt");
    public static final /* enum */ CollectionSchema robots_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "content of <meta name=\"robots\" content=#content#> tag and the \"X-Robots-Tag\" HTTP property");
    public static final /* enum */ CollectionSchema metagenerator_t = new CollectionSchema(SolrType.text_general, true, true, false, false, false, "content of <meta name=\"generator\" content=#content#> tag");
    public static final /* enum */ CollectionSchema inboundlinks_anchortext_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "internal links, the visible anchor text");
    public static final /* enum */ CollectionSchema outboundlinks_anchortext_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "external links, the visible anchor text");
    public static final /* enum */ CollectionSchema icons_urlstub_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "all icon links without the protocol and '://'");
    public static final /* enum */ CollectionSchema icons_protocol_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "all icon links protocols");
    public static final /* enum */ CollectionSchema icons_rel_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "all icon links relationships space separated (e.g.. 'icon apple-touch-icon')");
    public static final /* enum */ CollectionSchema icons_sizes_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "all icon sizes space separated (e.g. '16x16 32x32')");
    public static final /* enum */ CollectionSchema images_text_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "all text/words appearing in image alt texts or the tokenized url");
    public static final /* enum */ CollectionSchema images_alt_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "all image link alt tag");
    public static final /* enum */ CollectionSchema images_height_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "size of images:height");
    public static final /* enum */ CollectionSchema images_width_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "size of images:width");
    public static final /* enum */ CollectionSchema images_pixel_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "size of images as number of pixels (easier for a search restriction than width and height)");
    public static final /* enum */ CollectionSchema images_withalt_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of image links with alt tag");
    public static final /* enum */ CollectionSchema htags_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "binary pattern for the existance of h1..h6 headlines");
    public static final /* enum */ CollectionSchema canonical_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "url inside the canonical link element");
    public static final /* enum */ CollectionSchema canonical_equal_sku_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag shows if the url in canonical_t is equal to sku");
    public static final /* enum */ CollectionSchema refresh_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "link from the url property inside the refresh link element");
    public static final /* enum */ CollectionSchema li_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts in <li> tags");
    public static final /* enum */ CollectionSchema licount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of <li> tags");
    public static final /* enum */ CollectionSchema dt_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts in <dt> tags");
    public static final /* enum */ CollectionSchema dtcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of <dt> tags");
    public static final /* enum */ CollectionSchema dd_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts in <dd> tags");
    public static final /* enum */ CollectionSchema ddcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of <dd> tags");
    public static final /* enum */ CollectionSchema article_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts in <article> tags");
    public static final /* enum */ CollectionSchema articlecount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of <article> tags");
    public static final /* enum */ CollectionSchema bold_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts inside of <b> or <strong> tags. no doubles. listed in the order of number of occurrences in decreasing order");
    public static final /* enum */ CollectionSchema boldcount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "total number of occurrences of <b> or <strong>");
    public static final /* enum */ CollectionSchema italic_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts inside of <i> tags. no doubles. listed in the order of number of occurrences in decreasing order");
    public static final /* enum */ CollectionSchema italiccount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "total number of occurrences of <i>");
    public static final /* enum */ CollectionSchema underline_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, true, "all texts inside of <u> tags. no doubles. listed in the order of number of occurrences in decreasing order");
    public static final /* enum */ CollectionSchema underlinecount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "total number of occurrences of <u>");
    public static final /* enum */ CollectionSchema flash_b = new CollectionSchema(SolrType.bool, true, true, false, false, false, "flag that shows if a swf file is linked");
    public static final /* enum */ CollectionSchema frames_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "list of all links to frames");
    public static final /* enum */ CollectionSchema framesscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of frames_txt");
    public static final /* enum */ CollectionSchema iframes_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "list of all links to iframes");
    public static final /* enum */ CollectionSchema iframesscount_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of iframes_txt");
    public static final /* enum */ CollectionSchema hreflang_url_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "url of the hreflang link tag, see http://support.google.com/webmasters/bin/answer.py?hl=de&answer=189077");
    public static final /* enum */ CollectionSchema hreflang_cc_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "country code of the hreflang link tag, see http://support.google.com/webmasters/bin/answer.py?hl=de&answer=189077");
    public static final /* enum */ CollectionSchema navigation_url_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "page navigation url, see http://googlewebmastercentral.blogspot.de/2011/09/pagination-with-relnext-and-relprev.html");
    public static final /* enum */ CollectionSchema navigation_type_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "page navigation rel property value, can contain one of {top,up,next,prev,first,last}");
    public static final /* enum */ CollectionSchema publisher_url_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "publisher url as defined in http://support.google.com/plus/answer/1713826?hl=de");
    public static final /* enum */ CollectionSchema url_protocol_s = new CollectionSchema(SolrType.string, true, true, false, false, false, "the protocol of the url");
    public static final /* enum */ CollectionSchema url_file_name_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "the file name (which is the string after the last '/' and before the query part from '?' on) without the file extension");
    public static final /* enum */ CollectionSchema url_file_name_tokens_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "tokens generated from url_file_name_s which can be used for better matching and result boosting");
    public static final /* enum */ CollectionSchema url_paths_count_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of all path elements in the url hpath (see: http://www.ietf.org/rfc/rfc1738.txt) without the file name");
    public static final /* enum */ CollectionSchema url_paths_sxt = new CollectionSchema(SolrType.string, true, true, true, false, true, "all path elements in the url hpath (see: http://www.ietf.org/rfc/rfc1738.txt) without the file name");
    public static final /* enum */ CollectionSchema url_parameter_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of key-value pairs in search part of the url");
    public static final /* enum */ CollectionSchema url_parameter_key_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "the keys from key-value pairs in the search part of the url");
    public static final /* enum */ CollectionSchema url_parameter_value_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "the values from key-value pairs in the search part of the url");
    public static final /* enum */ CollectionSchema url_chars_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of all characters in the url == length of sku field");
    public static final /* enum */ CollectionSchema host_dnc_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "the Domain Class Name, either the TLD or a combination of ccSLD+TLD if a ccSLD is used.");
    public static final /* enum */ CollectionSchema host_organizationdnc_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "the organization and dnc concatenated with '.'");
    public static final /* enum */ CollectionSchema host_subdomain_s = new CollectionSchema(SolrType.string, true, true, false, false, true, "the remaining part of the host without organizationdnc");
    public static final /* enum */ CollectionSchema host_extent_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of documents from the same host; can be used to measure references_internal_i for likelihood computation");
    public static final /* enum */ CollectionSchema title_count_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of titles (counting the 'title' field) in the document");
    public static final /* enum */ CollectionSchema title_chars_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of characters for each title");
    public static final /* enum */ CollectionSchema title_words_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of words in each title");
    public static final /* enum */ CollectionSchema description_count_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of descriptions in the document. Its not counting the 'description' field since there is only one. But it counts the number of descriptions that appear in the document (if any)");
    public static final /* enum */ CollectionSchema description_chars_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of characters for each description");
    public static final /* enum */ CollectionSchema description_words_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of words in each description");
    public static final /* enum */ CollectionSchema h1_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h1 header lines");
    public static final /* enum */ CollectionSchema h2_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h2 header lines");
    public static final /* enum */ CollectionSchema h3_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h3 header lines");
    public static final /* enum */ CollectionSchema h4_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h4 header lines");
    public static final /* enum */ CollectionSchema h5_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h5 header lines");
    public static final /* enum */ CollectionSchema h6_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of h6 header lines");
    public static final /* enum */ CollectionSchema schema_org_breadcrumb_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "number of itemprop=\"breadcrumb\" appearances in div tags");
    public static final /* enum */ CollectionSchema opengraph_title_t = new CollectionSchema(SolrType.text_general, true, true, false, false, true, "Open Graph Metadata from og:title metadata field, see http://ogp.me/ns#");
    public static final /* enum */ CollectionSchema opengraph_type_s = new CollectionSchema(SolrType.text_general, true, true, false, false, false, "Open Graph Metadata from og:type metadata field, see http://ogp.me/ns#");
    public static final /* enum */ CollectionSchema opengraph_url_s = new CollectionSchema(SolrType.text_general, true, true, false, false, false, "Open Graph Metadata from og:url metadata field, see http://ogp.me/ns#");
    public static final /* enum */ CollectionSchema opengraph_image_s = new CollectionSchema(SolrType.text_general, true, true, false, false, false, "Open Graph Metadata from og:image metadata field, see http://ogp.me/ns#");
    public static final /* enum */ CollectionSchema cr_host_count_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "the number of documents within a single host");
    public static final /* enum */ CollectionSchema cr_host_chance_d = new CollectionSchema(SolrType.num_double, true, true, false, false, false, "the chance to click on this page when randomly clicking on links within on one host");
    public static final /* enum */ CollectionSchema cr_host_norm_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "normalization of chance: 0 for lower halve of cr_host_count_i urls, 1 for 1/2 of the remaining and so on. the maximum number is 10");
    public static final /* enum */ CollectionSchema rating_i = new CollectionSchema(SolrType.num_integer, true, true, false, false, false, "custom rating; to be set with external rating information");
    public static final /* enum */ CollectionSchema bold_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of occurrences of texts in bold_txt");
    public static final /* enum */ CollectionSchema italic_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of occurrences of texts in italic_txt");
    public static final /* enum */ CollectionSchema underline_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of occurrences of texts in underline_txt");
    public static final /* enum */ CollectionSchema ext_cms_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names of cms attributes; if several are recognized then they are listen in decreasing order of number of matching criterias");
    public static final /* enum */ CollectionSchema ext_cms_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of attributes that count for a specific cms in ext_cms_txt");
    public static final /* enum */ CollectionSchema ext_ads_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names of ad-servers/ad-services");
    public static final /* enum */ CollectionSchema ext_ads_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of attributes counts in ext_ads_txt");
    public static final /* enum */ CollectionSchema ext_community_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names of recognized community functions");
    public static final /* enum */ CollectionSchema ext_community_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of attribute counts in attr_community");
    public static final /* enum */ CollectionSchema ext_maps_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names of map services");
    public static final /* enum */ CollectionSchema ext_maps_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of attribute counts in ext_maps_txt");
    public static final /* enum */ CollectionSchema ext_tracker_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names of tracker server");
    public static final /* enum */ CollectionSchema ext_tracker_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of attribute counts in ext_tracker_txt");
    public static final /* enum */ CollectionSchema ext_title_txt = new CollectionSchema(SolrType.text_general, true, true, true, false, false, "names matching title expressions");
    public static final /* enum */ CollectionSchema ext_title_val = new CollectionSchema(SolrType.num_integer, true, true, true, false, false, "number of matching title expressions");
    public static final /* enum */ CollectionSchema vocabularies_sxt = new CollectionSchema(SolrType.string, true, true, true, false, false, "collection of all vocabulary names that have a matcher in the document - use this to boost with vocabularies");
    public static final String CORE_NAME = "collection1";
    public static final String VOCABULARY_PREFIX = "vocabulary_";
    public static final String VOCABULARY_TERMS_SUFFIX = "_sxt";
    public static final String VOCABULARY_COUNT_SUFFIX = "_i";
    public static final String VOCABULARY_LOGCOUNT_SUFFIX = "_log_i";
    public static final String VOCABULARY_LOGCOUNTS_SUFFIX = "_log_val";
    private String solrFieldName = null;
    private final SolrType type;
    private final boolean indexed;
    private final boolean stored;
    private final boolean searchable;
    private final boolean multiValued;
    private final boolean omitNorms;
    private final boolean docValues;
    private String comment;
    private boolean mandatory = false;
    private static final /* synthetic */ CollectionSchema[] $VALUES;

    public static CollectionSchema[] values() {
        return (CollectionSchema[])$VALUES.clone();
    }

    public static CollectionSchema valueOf(String name) {
        return Enum.valueOf(CollectionSchema.class, name);
    }

    private CollectionSchema(SolrType type, boolean indexed, boolean stored, boolean multiValued, boolean omitNorms, boolean searchable, String comment) {
        this(type, indexed, stored, multiValued, omitNorms, searchable, comment, false);
    }

    private CollectionSchema(SolrType type, boolean indexed, boolean stored, boolean multiValued, boolean omitNorms, boolean searchable, String comment, boolean mandatory) {
        this.type = type;
        this.indexed = indexed;
        this.stored = stored;
        this.multiValued = multiValued;
        this.omitNorms = omitNorms;
        this.searchable = searchable;
        this.comment = comment;
        this.mandatory = mandatory;
        this.docValues = type == SolrType.string || type == SolrType.date || type.name().startsWith("num_");
        String name = this.name();
        int p = name.indexOf(95);
        if (p > 0) {
            String ext = name.substring(p + 1);
            assert (!ext.equals("i") || type == SolrType.num_integer && !multiValued) : name;
            assert (!ext.equals("l") || type == SolrType.num_long && !multiValued) : name;
            assert (!ext.equals("b") || type == SolrType.bool && !multiValued) : name;
            assert (!ext.equals("s") || type == SolrType.string && !multiValued) : name;
            assert (!ext.equals("sxt") || type == SolrType.string && multiValued) : name;
            assert (!ext.equals("dt") || type == SolrType.date && !multiValued) : name;
            assert (!ext.equals("dts") || type == SolrType.date && multiValued) : name;
            assert (!ext.equals("t") || type == SolrType.text_general && !multiValued) : name;
            assert (!ext.equals("coordinate") || type == SolrType.coordinate && !multiValued) : name;
            assert (!ext.equals("txt") || type == SolrType.text_general && multiValued) : name;
            assert (!ext.equals("val") || type == SolrType.num_integer && multiValued) : name;
            assert (!ext.equals("d") || type == SolrType.num_double && !multiValued) : name;
        }
        assert (type.appropriateName(this)) : "bad configuration: " + this.name();
    }

    @Override
    public final String getSolrFieldName() {
        return this.solrFieldName == null ? this.name() : this.solrFieldName;
    }

    @Override
    public final void setSolrFieldName(String theValue) {
        this.solrFieldName = theValue != null && !theValue.isEmpty() ? theValue.toLowerCase(Locale.ROOT) : null;
    }

    @Override
    public final SolrType getType() {
        return this.type;
    }

    @Override
    public final boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public final boolean isStored() {
        return this.stored;
    }

    @Override
    public final boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public final boolean isOmitNorms() {
        return this.omitNorms;
    }

    @Override
    public final boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public boolean isDocValue() {
        return this.docValues;
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public final boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public final void add(SolrInputDocument doc, String value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Date value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.date);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, int value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.num_integer);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, long value) {
        assert (!this.isMultiValued());
        assert (this.type == SolrType.num_long);
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Date[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, String[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, Integer[] value) {
        assert (this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, List<?> value) {
        assert (this.isMultiValued());
        if (value == null || value.size() == 0) {
            if (this.type == SolrType.num_integer) {
                doc.setField(this.getSolrFieldName(), (Object)new Integer[0]);
            } else if (this.type == SolrType.string || this.type == SolrType.text_general) {
                doc.setField(this.getSolrFieldName(), (Object)new String[0]);
            } else if (this.type == SolrType.date) {
                doc.setField(this.getSolrFieldName(), (Object)new Date[0]);
            } else {
                assert (false) : "ADD(1): type is " + this.type.name();
                doc.setField(this.getSolrFieldName(), (Object)new Object[0]);
            }
            return;
        }
        if (this.type == SolrType.num_integer) {
            assert (value.iterator().next() instanceof Integer) : "type: " + value.iterator().next().getClass().getName();
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new Integer[value.size()]));
        } else if (this.type == SolrType.string || this.type == SolrType.text_general) {
            assert (value.iterator().next() instanceof String) : "type: " + value.iterator().next().getClass().getName();
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new String[value.size()]));
        } else if (this.type == SolrType.date) {
            assert (value.iterator().next() instanceof String || value.iterator().next() instanceof Date) : "type: " + value.iterator().next().getClass().getName();
            if (value.iterator().next() instanceof String) {
                Date[] da = new Date[value.size()];
                for (int i = 0; i < value.size(); ++i) {
                    try {
                        da[i] = DateParser.parseDate((String)((String)value.get(i))).getTime();
                        continue;
                    }
                    catch (EvaluationException e) {
                        da[i] = null;
                    }
                }
                doc.setField(this.getSolrFieldName(), (Object)da);
            } else {
                doc.setField(this.getSolrFieldName(), (Object)value.toArray(new Date[value.size()]));
            }
        } else {
            assert (false) : "ADD(2): type is " + this.type.name();
            doc.setField(this.getSolrFieldName(), (Object)value.toArray(new Object[value.size()]));
        }
    }

    @Override
    public final void add(SolrInputDocument doc, float value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)Float.valueOf(value));
    }

    @Override
    public final void add(SolrInputDocument doc, double value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void add(SolrInputDocument doc, boolean value) {
        assert (!this.isMultiValued());
        doc.setField(this.getSolrFieldName(), (Object)value);
    }

    @Override
    public final void remove(SolrInputDocument doc) {
        doc.removeField(this.getSolrFieldName());
    }

    static {
        $VALUES = new CollectionSchema[]{id, sku, last_modified, load_date_dt, content_type, title, host_id_s, host_s, size_i, failreason_s, failtype_s, httpstatus_i, url_file_ext_s, host_organization_s, inboundlinks_urlstub_sxt, inboundlinks_protocol_sxt, outboundlinks_protocol_sxt, outboundlinks_urlstub_sxt, images_urlstub_sxt, images_protocol_sxt, fresh_date_dt, referrer_id_s, publisher_t, language_s, audiolinkscount_i, videolinkscount_i, applinkscount_i, title_exact_signature_l, title_unique_b, exact_signature_copycount_i, fuzzy_signature_text_t, fuzzy_signature_copycount_i, process_sxt, dates_in_content_dts, dates_in_content_count_i, startDates_dts, endDates_dts, references_i, references_internal_i, references_external_i, references_exthosts_i, crawldepth_i, harvestkey_s, http_unique_b, www_unique_b, exact_signature_l, exact_signature_unique_b, fuzzy_signature_l, fuzzy_signature_unique_b, coordinate_p, coordinate_p_0_coordinate, coordinate_p_1_coordinate, ip_s, author, author_sxt, description_txt, description_exact_signature_l, description_unique_b, keywords, charset_s, wordcount_i, linkscount_i, linksnofollowcount_i, inboundlinkscount_i, inboundlinksnofollowcount_i, outboundlinkscount_i, outboundlinksnofollowcount_i, imagescount_i, responsetime_i, text_t, synonyms_sxt, h1_txt, h2_txt, h3_txt, h4_txt, h5_txt, h6_txt, md5_s, httpstatus_redirect_s, collection_sxt, csscount_i, css_tag_sxt, css_url_sxt, scripts_sxt, scriptscount_i, robots_i, metagenerator_t, inboundlinks_anchortext_txt, outboundlinks_anchortext_txt, icons_urlstub_sxt, icons_protocol_sxt, icons_rel_sxt, icons_sizes_sxt, images_text_t, images_alt_sxt, images_height_val, images_width_val, images_pixel_val, images_withalt_i, htags_i, canonical_s, canonical_equal_sku_b, refresh_s, li_txt, licount_i, dt_txt, dtcount_i, dd_txt, ddcount_i, article_txt, articlecount_i, bold_txt, boldcount_i, italic_txt, italiccount_i, underline_txt, underlinecount_i, flash_b, frames_sxt, framesscount_i, iframes_sxt, iframesscount_i, hreflang_url_sxt, hreflang_cc_sxt, navigation_url_sxt, navigation_type_sxt, publisher_url_s, url_protocol_s, url_file_name_s, url_file_name_tokens_t, url_paths_count_i, url_paths_sxt, url_parameter_i, url_parameter_key_sxt, url_parameter_value_sxt, url_chars_i, host_dnc_s, host_organizationdnc_s, host_subdomain_s, host_extent_i, title_count_i, title_chars_val, title_words_val, description_count_i, description_chars_val, description_words_val, h1_i, h2_i, h3_i, h4_i, h5_i, h6_i, schema_org_breadcrumb_i, opengraph_title_t, opengraph_type_s, opengraph_url_s, opengraph_image_s, cr_host_count_i, cr_host_chance_d, cr_host_norm_i, rating_i, bold_val, italic_val, underline_val, ext_cms_txt, ext_cms_val, ext_ads_txt, ext_ads_val, ext_community_txt, ext_community_val, ext_maps_txt, ext_maps_val, ext_tracker_txt, ext_tracker_val, ext_title_txt, ext_title_val, vocabularies_sxt};
    }
}

