/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.SetTools;
import net.yacy.peers.RemoteSearch;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEvent;

public class SecondarySearchSuperviser
extends Thread {
    private final SortedMap<String, SortedMap<String, Set<String>>> abstractsCache = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedSet<String> checkedPeers = Collections.synchronizedSortedSet(new TreeSet());
    private final Semaphore trigger = new Semaphore(0);
    private final SearchEvent searchEvent;

    protected SecondarySearchSuperviser(SearchEvent searchEvent) {
        super("SecondarySearchSuperviser");
        this.searchEvent = searchEvent;
    }

    public void addAbstract(String wordhash, final SortedMap<String, Set<String>> singleAbstract) {
        final SortedMap oldAbstract = (SortedMap)this.abstractsCache.get(wordhash);
        if (oldAbstract == null) {
            this.abstractsCache.put(wordhash, singleAbstract);
            return;
        }
        new Thread("SecondarySearch.addAbstract:" + wordhash){

            @Override
            public void run() {
                for (Map.Entry oneref : singleAbstract.entrySet()) {
                    Set peerlistNew;
                    String urlhash = (String)oneref.getKey();
                    Set peerlistOld = oldAbstract.put(urlhash, peerlistNew = (Set)oneref.getValue());
                    if (peerlistOld == null) continue;
                    peerlistOld.addAll(peerlistNew);
                }
            }
        }.start();
    }

    public void commitAbstract() {
        this.trigger.release();
    }

    private Set<String> wordsFromPeer(String peerhash, Set<String> urls2) {
        HashSet<String> wordlist = new HashSet<String>();
        block0: for (Map.Entry<String, SortedMap<String, Set<String>>> entry2 : this.abstractsCache.entrySet()) {
            String word = entry2.getKey();
            SortedMap<String, Set<String>> urlPeerlist = entry2.getValue();
            for (String url : urls2) {
                Set peerlist = (Set)urlPeerlist.get(url);
                if (peerlist == null || !peerlist.contains(peerhash)) continue;
                wordlist.add(word);
                continue block0;
            }
        }
        return wordlist;
    }

    @Override
    public void run() {
        try {
            boolean aquired;
            while ((aquired = this.trigger.tryAcquire(3000L, TimeUnit.MILLISECONDS)) && aquired && !MemoryControl.shortStatus()) {
                this.prepareSecondarySearch();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.abstractsCache.clear();
        this.checkedPeers.clear();
    }

    private void prepareSecondarySearch() {
        HashSet<String> urls2;
        if (this.abstractsCache == null || this.abstractsCache.size() != this.searchEvent.query.getQueryGoal().getIncludeHashes().size()) {
            return;
        }
        if (this.abstractsCache.size() != this.searchEvent.query.getQueryGoal().getIncludeHashes().size()) {
            return;
        }
        SortedMap abstractJoin = SetTools.joinConstructive(this.abstractsCache.values(), true);
        if (abstractJoin.isEmpty()) {
            return;
        }
        TreeMap<String, HashSet<String>> secondarySearchURLs = new TreeMap<String, HashSet<String>>();
        String mypeerhash = this.searchEvent.peers.mySeed().hash;
        boolean mypeerinvolved = false;
        for (Map.Entry entry2 : abstractJoin.entrySet()) {
            String url = (String)entry2.getKey();
            Set peerlist = (Set)entry2.getValue();
            int mypeercount = 0;
            for (String peer : peerlist) {
                if (peer.equals(mypeerhash) && mypeercount++ > 1) continue;
                urls2 = (HashSet<String>)secondarySearchURLs.get(peer);
                if (urls2 == null) {
                    urls2 = new HashSet<String>();
                    urls2.add(url);
                    secondarySearchURLs.put(peer, urls2);
                } else {
                    urls2.add(url);
                }
                secondarySearchURLs.put(peer, urls2);
            }
            if (mypeercount != true) continue;
            mypeerinvolved = true;
        }
        this.searchEvent.secondarySearchThreads = new Thread[mypeerinvolved ? secondarySearchURLs.size() - 1 : secondarySearchURLs.size()];
        int c = 0;
        for (Map.Entry entry3 : secondarySearchURLs.entrySet()) {
            Set<String> words;
            String peer = (String)entry3.getKey();
            if (peer.equals(mypeerhash) || this.checkedPeers.contains(peer) || (words = this.wordsFromPeer(peer, urls2 = (Set)entry3.getValue())).isEmpty()) continue;
            ConcurrentLog.info("SearchEvent.SecondarySearchSuperviser", "asking peer " + peer + " for urls: " + urls2 + " from words: " + words);
            this.checkedPeers.add(peer);
            this.searchEvent.secondarySearchThreads[c++] = RemoteSearch.secondaryRemoteSearch(this.searchEvent, words, ((Object)urls2).toString(), 6000L, peer, Switchboard.urlBlacklist);
        }
    }
}

