/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.EventTracker;
import net.yacy.search.query.QueryParams;

public class AccessTracker {
    private static final long DUMP_PERIOD = 3600000L;
    private static final int DUMP_SIZE = 50000;
    private static final int minSize = 100;
    private static final int maxSize = 1000;
    private static final int maxAge = 86400000;
    private static final LinkedList<QueryParams> localSearches = new LinkedList();
    private static final LinkedList<QueryParams> remoteSearches = new LinkedList();
    private static final ArrayList<String> log = new ArrayList();
    private static long lastLogDump = System.currentTimeMillis();
    private static long localCount = 0L;
    private static long remoteCount = 0L;
    private static File dumpFile = null;

    public static void setDumpFile(File f) {
        dumpFile = f;
    }

    public static File getDumpFile() {
        return dumpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Location location, QueryParams query2, int resultCount) {
        LinkedList<QueryParams> linkedList;
        if (location == Location.local) {
            linkedList = localSearches;
            synchronized (linkedList) {
                AccessTracker.add(localSearches, query2, resultCount);
            }
        }
        if (location == Location.remote) {
            linkedList = remoteSearches;
            synchronized (linkedList) {
                AccessTracker.add(remoteSearches, query2, resultCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(LinkedList<QueryParams> list2, QueryParams query2, int resultCount) {
        Serializable sb;
        String queryString = query2.getQueryGoal().getQueryString(false);
        if (resultCount > 10 && queryString != null && queryString.length() > 0) {
            sb = new StringBuilder(queryString);
            sb.append(queryString);
            WordCache.learn(sb);
        }
        list2.add(query2);
        while (list2.size() > 1000 || !list2.isEmpty() && MemoryControl.shortStatus()) {
            sb = list2;
            synchronized (sb) {
                if (list2.isEmpty()) {
                    break;
                }
                AccessTracker.addToDump(list2.removeFirst(), (long)resultCount);
            }
        }
        if (list2.size() <= 100) {
            return;
        }
        long timeout = System.currentTimeMillis() - 86400000L;
        while (!list2.isEmpty()) {
            QueryParams q = list2.getFirst();
            if (q.starttime > timeout) break;
            AccessTracker.addToDump(list2.removeFirst(), (long)resultCount);
        }
    }

    public static Iterator<QueryParams> get(Location location) {
        if (location == Location.local) {
            return localSearches.descendingIterator();
        }
        if (location == Location.remote) {
            return remoteSearches.descendingIterator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long size(Location location) {
        if (location == Location.local) {
            LinkedList<QueryParams> linkedList = localSearches;
            synchronized (linkedList) {
                return localCount + (long)localSearches.size();
            }
        }
        if (location == Location.remote) {
            LinkedList<QueryParams> linkedList = remoteSearches;
            synchronized (linkedList) {
                return remoteCount + (long)remoteSearches.size();
            }
        }
        return 0L;
    }

    private static void addToDump(QueryParams query2, long resultCount) {
        String queryString = query2.getQueryGoal().getQueryString(false);
        if (queryString == null || queryString.isEmpty()) {
            return;
        }
        AccessTracker.addToDump(queryString, resultCount, new Date(query2.starttime), "qs");
    }

    public static void addToDump(String querystring, long resultCount) {
        AccessTracker.addToDump(querystring, resultCount, new Date(), "qs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToDump(String querystring, long resultcount, Date d, String querySyntax) {
        if (querystring == null || querystring.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(40);
        sb.append(GenericFormatter.SHORT_SECOND_FORMATTER.format(d));
        sb.append(' ');
        sb.append(resultcount);
        sb.append(' ');
        sb.append(querySyntax);
        sb.append(' ');
        sb.append(querystring);
        ArrayList<String> arrayList = log;
        synchronized (arrayList) {
            log.add(sb.toString());
        }
        if (log.size() > 50000 || lastLogDump + 3600000L < System.currentTimeMillis()) {
            AccessTracker.dumpLog();
        }
    }

    public static void dumpLog() {
        lastLogDump = System.currentTimeMillis();
        localCount += (long)localSearches.size();
        while (!localSearches.isEmpty()) {
            AccessTracker.addToDump(localSearches.removeFirst(), 0L);
        }
        remoteCount += (long)remoteSearches.size();
        while (!remoteSearches.isEmpty()) {
            AccessTracker.addToDump(remoteSearches.removeFirst(), 0L);
        }
        Thread t = new Thread("AccessTracker.dumpLog"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList logCopy = new ArrayList();
                ArrayList arrayList = log;
                synchronized (arrayList) {
                    logCopy.addAll(log);
                    log.clear();
                }
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(dumpFile, "rw");
                    raf.seek(raf.length());
                    for (String s : logCopy) {
                        raf.write(UTF8.getBytes(s));
                        raf.writeByte(10);
                    }
                    logCopy.clear();
                }
                catch (FileNotFoundException e) {
                    ConcurrentLog.logException(e);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EventTracker.Event> readLog(File f, Date from, Date to) {
        ArrayList<EventTracker.Event> events = new ArrayList<EventTracker.Event>();
        RandomAccessFile raf = null;
        try {
            String line;
            raf = new RandomAccessFile(f, "r");
            Date fd = AccessTracker.readDate(raf, 0L);
            if (fd.after(from)) {
                from = fd;
            }
            long seekFrom = AccessTracker.binarySearch(raf, from, 0L, raf.length());
            long seekTo = AccessTracker.binarySearch(raf, to, seekFrom, raf.length());
            raf.seek(seekFrom);
            byte[] buffer = new byte[(int)(seekTo - seekFrom)];
            raf.readFully(buffer);
            raf.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bais, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                String countStr;
                if (line.length() < "yyyyMMddHHmmss".length() + 3 || line.charAt("yyyyMMddHHmmss".length()) != ' ') continue;
                String dateStr = line.substring(0, "yyyyMMddHHmmss".length());
                int countEnd = -1;
                for (int i = "yyyyMMddHHmmss".length() + 2; i < line.length(); ++i) {
                    if (line.charAt(i) != ' ') continue;
                    countEnd = i;
                    break;
                }
                if (countEnd == -1 || (countStr = line.substring("yyyyMMddHHmmss".length() + 1, countEnd)).length() > 5) continue;
                int hits = countStr.length() == 1 ? countStr.charAt(0) - 48 : Integer.parseInt(countStr);
                try {
                    EventTracker.Event event = new EventTracker.Event(dateStr, 0L, "query", (Object)line.substring(dateStr.length() + countStr.length() + 2), hits);
                    events.add(event);
                }
                catch (NumberFormatException e) {
                }
                catch (Throwable e) {}
            }
            reader.close();
            bais.close();
            buffer = null;
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.logException(e);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
        return events;
    }

    private static long binarySearch(RandomAccessFile raf, Date date, long l, long r) throws IOException {
        if (r <= l) {
            return l;
        }
        long m = AccessTracker.seekLB(raf, (l + r) / 2L);
        if (m <= l) {
            return m;
        }
        Date mDate = AccessTracker.readDate(raf, m);
        if (mDate.after(date)) {
            return AccessTracker.binarySearch(raf, date, l, m);
        }
        return AccessTracker.binarySearch(raf, date, m, r);
    }

    private static long seekLB(RandomAccessFile raf, long x) throws IOException {
        if (x <= 0L) {
            return x;
        }
        raf.seek(x);
        while (x > 0L && raf.read() >= 32) {
            raf.seek(--x);
        }
        if (x == 0L) {
            return 0L;
        }
        raf.seek(x);
        return raf.read() >= 32 ? x : x + 1L;
    }

    private static Date readDate(RandomAccessFile raf, long x) throws IOException {
        raf.seek(x);
        byte[] b = new byte["yyyyMMddHHmmss".length()];
        raf.readFully(b);
        try {
            return GenericFormatter.SHORT_SECOND_FORMATTER.parse(UTF8.String(b), 0).getTime();
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String file = args[0];
        try {
            Date from = GenericFormatter.SHORT_SECOND_FORMATTER.parse(args[1], 0).getTime();
            Date to = GenericFormatter.SHORT_SECOND_FORMATTER.parse(args[2], 0).getTime();
            List<EventTracker.Event> dump = AccessTracker.readLog(new File(file), from, to);
            for (EventTracker.Event s : dump) {
                System.out.println(s.toString());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static enum Location {
        local,
        remote;

    }

    public static class QueryEvent {
        public final String address;
        public final String userAgent;
        public final String query;
        public final Date date;
        public final short offset;
        public final short requestedResults;
        public final short returnedResults;
        public final short knownResults;
        public final short executionTime;

        public QueryEvent(String address, String userAgent, String query2, Date date, short offset, short requestedResults, short returnedResults, short knownResults, short executionTime) {
            this.address = address;
            this.userAgent = userAgent;
            this.query = query2;
            this.date = date;
            this.offset = offset;
            this.requestedResults = requestedResults;
            this.returnedResults = returnedResults;
            this.knownResults = knownResults;
            this.executionTime = executionTime;
        }
    }
}

