/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.rwi.IndexCell;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.operation.yacyRelease;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import org.apache.commons.io.FileUtils;

public class ResourceObserver {
    public static final ConcurrentLog log = new ConcurrentLog("RESOURCE OBSERVER");
    private final Switchboard sb;
    private final File path;
    private Space normalizedDiskFree = Space.AMPLE;
    private Space normalizedDiskUsed = Space.AMPLE;
    private Space normalizedMemoryFree = Space.AMPLE;
    private long sizeOfDirectory_lastCountTime = 0L;
    private long sizeOfDirectory_lastCountValue = 0L;

    public ResourceObserver(Switchboard sb) {
        this.sb = sb;
        this.path = sb.getDataPath("indexPrimaryPath", "").getParentFile();
        log.info("path for disc space measurement: " + this.path);
    }

    public void resourceObserverJob() {
        block26: {
            block25: {
                block24: {
                    IndexCell<WordReference> termIndex;
                    block28: {
                        block27: {
                            MemoryControl.setProperMbyte(this.getMinFreeMemory());
                            this.normalizedDiskFree = this.getNormalizedDiskFree();
                            this.normalizedDiskUsed = this.getNormalizedDiskUsed(true);
                            this.normalizedMemoryFree = this.getNormalizedMemoryFree();
                            if (this.normalizedDiskFree != Space.AMPLE || this.normalizedDiskUsed != Space.AMPLE || this.normalizedMemoryFree != Space.AMPLE) {
                                String reason = "";
                                if (this.normalizedDiskFree != Space.AMPLE) {
                                    reason = reason + " not enough disk space, " + this.getUsableSpace();
                                }
                                if (this.normalizedDiskUsed != Space.AMPLE) {
                                    reason = reason + " too high disk usage, " + this.getNormalizedDiskUsed(true);
                                }
                                if (this.normalizedMemoryFree != Space.AMPLE) {
                                    reason = reason + " not enough memory space";
                                }
                                if (!this.sb.crawlJobIsPaused("50_localcrawl")) {
                                    log.info("pausing local crawls");
                                    this.sb.pauseCrawlJob("50_localcrawl", "resource observer:" + reason);
                                    this.sb.setConfig("memory.disabledLocalCrawler", true);
                                }
                                if (!this.sb.crawlJobIsPaused("62_remotetriggeredcrawl")) {
                                    log.info("pausing remote triggered crawls");
                                    this.sb.pauseCrawlJob("62_remotetriggeredcrawl", "resource observer:" + reason);
                                    this.sb.setConfig("memory.disabledRemoteCrawler", true);
                                }
                                if ((this.normalizedDiskFree == Space.EXHAUSTED || this.normalizedMemoryFree != Space.AMPLE) && this.sb.getConfigBool("allowReceiveIndex", false)) {
                                    log.info("disabling index receive");
                                    this.sb.setConfig("allowReceiveIndex", false);
                                    this.sb.peers.mySeed().setFlagAcceptRemoteIndex(false);
                                    this.sb.setConfig("memory.disabledDHT", true);
                                }
                            }
                            if ((this.normalizedDiskFree != Space.EXHAUSTED || !this.sb.getConfigBool("resource.disk.free.autoregulate", false)) && (this.normalizedDiskUsed != Space.EXHAUSTED || !this.sb.getConfigBool("resource.disk.used.autoregulate", false))) break block26;
                            if (yacyRelease.deleteOldDownloads(this.sb.releasePath, 1)) {
                                log.warn("DISK SPACE EXHAUSTED - deleting downloaded releases files");
                            }
                            if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                            log.info("DISK SPACE EXHAUSTED - deleting HTCACHE");
                            Cache.clear();
                            if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                            log.info("DISK SPACE EXHAUSTED - deleting robots.txt database");
                            try {
                                this.sb.robots.clear();
                            }
                            catch (IOException reason) {
                                // empty catch block
                            }
                            if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                            log.info("DISK SPACE EXHAUSTED - deleting News database");
                            this.sb.peers.newsPool.clear(0);
                            this.sb.peers.newsPool.clear(1);
                            this.sb.peers.newsPool.clear(2);
                            this.sb.peers.newsPool.clear(3);
                            if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                            if (!this.sb.index.connectedCitation()) break block27;
                            log.info("DISK SPACE EXHAUSTED - deleting citations");
                            try {
                                this.sb.index.urlCitation().clear();
                            }
                            catch (IOException reason) {
                                // empty catch block
                            }
                            if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                        }
                        if (this.sb.crawlQueues.coreCrawlJobSize() <= 1000) break block28;
                        log.info("DISK SPACE EXHAUSTED - deleting crawl queues");
                        this.sb.crawlQueues.clear();
                        this.sb.crawlStacker.clear();
                        ResultURLs.clearStacks();
                        if (this.getNormalizedDiskFree() == Space.AMPLE && this.getNormalizedDiskUsed(false) == Space.AMPLE) break block25;
                    }
                    if ((termIndex = this.sb.index.termIndex()) != null) {
                        try {
                            int shrinkedReferences = termIndex.deleteOld(100, 10000L);
                            if (shrinkedReferences <= 0) break block24;
                            log.info("DISK SPACE EXHAUSTED - shrinked " + shrinkedReferences + " RWI references to a maximum of 100");
                            if (this.getNormalizedDiskFree() != Space.AMPLE || this.getNormalizedDiskUsed(false) != Space.AMPLE) break block24;
                            break block25;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                this.sb.index.fulltext().commit(false);
                if (this.getNormalizedDiskFree() != Space.AMPLE || this.getNormalizedDiskUsed(false) == Space.AMPLE) {
                    // empty if block
                }
            }
            this.normalizedDiskFree = this.getNormalizedDiskFree();
            this.normalizedDiskUsed = this.getNormalizedDiskUsed(false);
            this.normalizedMemoryFree = this.getNormalizedMemoryFree();
        }
        if (this.normalizedDiskFree == Space.AMPLE && this.normalizedDiskUsed == Space.AMPLE && this.normalizedMemoryFree == Space.AMPLE) {
            if (this.sb.getConfigBool("memory.disabledDHT", false)) {
                log.info("enabling index receive");
                this.sb.setConfig("allowReceiveIndex", true);
                this.sb.peers.mySeed().setFlagAcceptRemoteIndex(true);
                this.sb.setConfig("memory.disabledDHT", false);
            } else if (this.sb.getConfigBool("memory.disabledLocalCrawler", false)) {
                log.info("continue paused local crawls");
                this.sb.setConfig("memory.disabledLocalCrawler", false);
                this.sb.continueCrawlJob("50_localcrawl");
            } else if (this.sb.getConfigBool("memory.disabledRemoteCrawler", false)) {
                log.info("continue paused remote triggered crawls");
                this.sb.setConfig("memory.disabledRemoteCrawler", false);
                this.sb.continueCrawlJob("62_remotetriggeredcrawl");
            }
            log.info("resources ok");
        }
    }

    public long getSizeOfDataPath(boolean cached) {
        if (cached && System.currentTimeMillis() - this.sizeOfDirectory_lastCountTime < 600000L) {
            return this.sizeOfDirectory_lastCountValue;
        }
        this.sizeOfDirectory_lastCountTime = System.currentTimeMillis();
        try {
            this.sizeOfDirectory_lastCountValue = FileUtils.sizeOfDirectory((File)this.path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.sizeOfDirectory_lastCountValue;
    }

    public long getUsableSpace() {
        return this.path.getUsableSpace();
    }

    private Space getNormalizedDiskUsed(boolean cached) {
        long currentUsed = this.getSizeOfDataPath(cached);
        if (currentUsed < 1L) {
            return Space.AMPLE;
        }
        Space ret = Space.AMPLE;
        if (currentUsed > this.getMaxUsedDiskOvershot()) {
            log.warn("Volume " + this.path.toString() + ": used space (" + currentUsed / 1024L / 1024L + " MB) is too high (> " + this.getMaxUsedDiskOvershot() / 1024L / 1024L + " MB)");
            ret = Space.EXHAUSTED;
            return ret;
        }
        if (currentUsed > this.getMaxUsedDiskSteadystate()) {
            log.info("Volume " + this.path.toString() + ": used space (" + currentUsed / 1024L / 1024L + " MB) is high, but nominal (> " + this.getMaxUsedDiskSteadystate() / 1024L / 1024L + " MB)");
            ret = Space.NOMINAL;
            return ret;
        }
        return ret;
    }

    private Space getNormalizedDiskFree() {
        long currentSpace = this.getUsableSpace();
        if (currentSpace < 1L) {
            return Space.AMPLE;
        }
        Space ret = Space.AMPLE;
        if (currentSpace < this.getMinFreeDiskUndershot()) {
            log.warn("Volume " + this.path.toString() + ": free space (" + currentSpace / 1024L / 1024L + " MB) is too low (< " + this.getMinFreeDiskSteadystate() / 1024L / 1024L + " MB)");
            ret = Space.EXHAUSTED;
            return ret;
        }
        if (currentSpace < this.getMinFreeDiskSteadystate()) {
            log.info("Volume " + this.path.toString() + ": free space (" + currentSpace / 1024L / 1024L + " MB) is low, but nominal (< " + this.getMinFreeDiskSteadystate() / 1024L / 1024L + " MB)");
            ret = Space.NOMINAL;
            return ret;
        }
        return ret;
    }

    private Space getNormalizedMemoryFree() {
        if (MemoryControl.properState()) {
            return Space.AMPLE;
        }
        this.sb.index.clearCaches();
        SearchEventCache.cleanupEvents(true);
        this.sb.trail.clear();
        Switchboard.urlBlacklist.clearblacklistCache();
        WordCache.clearCommonWords();
        Domains.clear();
        return MemoryControl.properState() ? Space.AMPLE : Space.EXHAUSTED;
    }

    public boolean getDiskAvailable() {
        return this.normalizedDiskFree == Space.AMPLE;
    }

    public boolean getMemoryAvailable() {
        return this.normalizedMemoryFree == Space.AMPLE;
    }

    public long getMaxUsedDiskSteadystate() {
        return this.sb.getConfigLong("resource.disk.used.max.steadystate", 524288L) * 1024L * 1024L;
    }

    public long getMaxUsedDiskOvershot() {
        return this.sb.getConfigLong("resource.disk.used.max.overshot", 0x100000L) * 1024L * 1024L;
    }

    public long getMinFreeDiskSteadystate() {
        return this.sb.getConfigLong("resource.disk.free.min.steadystate", 2048L) * 1024L * 1024L;
    }

    public long getMinFreeDiskUndershot() {
        return this.sb.getConfigLong("resource.disk.free.min.undershot", 1024L) * 1024L * 1024L;
    }

    public long getMinFreeMemory() {
        return this.sb.getConfigLong("memory.acceptDHTabove", 0L);
    }

    public static enum Space implements Comparable<Space>
    {
        EXHAUSTED,
        NOMINAL,
        AMPLE;

    }
}

