/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.peers.graphics.ProfilingGraph;

public class EventTracker {
    private static final int maxQueueSize = 30000;
    private static final long maxQueueAge = ProfilingGraph.maxTime;
    private static final Map<EClass, Queue<Event>> historyMaps = new ConcurrentHashMap<EClass, Queue<Event>>();
    private static final Map<EClass, Long> eventAccess = new ConcurrentHashMap<EClass, Long>();

    public static final void delete(EClass eventName) {
        historyMaps.remove((Object)eventName);
        eventAccess.remove((Object)eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void update(EClass eventName, Object eventPayload, boolean useProtection) {
        Queue<Event> history;
        if (useProtection) {
            Long lastAcc = eventAccess.get((Object)eventName);
            if (lastAcc == null) {
                eventAccess.put(eventName, System.currentTimeMillis());
            } else {
                long time = System.currentTimeMillis();
                if (time - lastAcc < 1000L) {
                    return;
                }
                eventAccess.put(eventName, time);
            }
        }
        if ((history = historyMaps.get((Object)eventName)) == null) {
            history = new LinkedBlockingQueue<Event>();
            history.offer(new Event(new Date(), 0L, "update", eventPayload, 0));
            historyMaps.put(eventName, history);
            return;
        }
        history.offer(new Event(new Date(), 0L, "update", eventPayload, 0));
        int tp = history.size() - 30000;
        while (tp-- > 0) {
            history.poll();
        }
        if (history.size() % 10 == 0) {
            Queue<Event> queue = history;
            synchronized (queue) {
                if (history.size() % 10 == 0) {
                    Event e;
                    long now = System.currentTimeMillis();
                    while (!history.isEmpty() && now - (e = history.peek()).getTime() >= maxQueueAge) {
                        history.poll();
                    }
                }
            }
        }
    }

    public static final Iterator<Event> getHistory(EClass eventName) {
        Queue<Event> list2 = historyMaps.get((Object)eventName);
        if (list2 == null) {
            return null;
        }
        return list2.iterator();
    }

    public static final int countEvents(EClass eventName, long time) {
        Iterator<Event> event = EventTracker.getHistory(eventName);
        if (event == null) {
            return 0;
        }
        long now = System.currentTimeMillis();
        int count = 0;
        while (event.hasNext()) {
            if (now - event.next().getTime() >= time) continue;
            ++count;
        }
        return count;
    }

    public static final class Event {
        private final Object time;
        public final long duration;
        public final String type;
        public final Object payload;
        public final int count;

        public Event(Date time, long duration, String type, Object payload, int count) {
            this.time = time;
            this.duration = duration;
            this.type = type;
            this.payload = payload;
            this.count = count;
        }

        public Event(Long time, long duration, String type, Object payload, int count) {
            this.time = time;
            this.duration = duration;
            this.type = type;
            this.payload = payload;
            this.count = count;
        }

        public Event(String time, long duration, String type, Object payload, int count) {
            this.time = time;
            this.duration = duration;
            this.type = type;
            this.payload = payload;
            this.count = count;
        }

        public String getFormattedDate() {
            if (this.time instanceof String) {
                return (String)this.time;
            }
            if (this.time instanceof Long) {
                return GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date((Long)this.time));
            }
            if (this.time instanceof Date) {
                return GenericFormatter.SHORT_SECOND_FORMATTER.format((Date)this.time);
            }
            return null;
        }

        public long getTime() {
            if (this.time instanceof String) {
                try {
                    return GenericFormatter.SHORT_SECOND_FORMATTER.parse((String)this.time, 0).getTime().getTime();
                }
                catch (ParseException e) {
                    return -1L;
                }
            }
            if (this.time instanceof Long) {
                return (Long)this.time;
            }
            if (this.time instanceof Date) {
                return ((Date)this.time).getTime();
            }
            return -1L;
        }

        public Date getDate() {
            if (this.time instanceof String) {
                try {
                    return GenericFormatter.SHORT_SECOND_FORMATTER.parse((String)this.time, 0).getTime();
                }
                catch (ParseException e) {
                    return null;
                }
            }
            if (this.time instanceof Long) {
                return new Date((Long)this.time);
            }
            if (this.time instanceof Date) {
                return (Date)this.time;
            }
            return null;
        }

        public String toString() {
            return this.type + " " + this.getFormattedDate() + (this.duration == 0L ? " " : "(" + this.duration + "ms) ") + (this.count == 0 ? " " : "[" + this.count + "] ") + this.payload;
        }
    }

    public static enum EClass {
        WORDCACHE,
        MEMORY,
        PPM,
        PEERPING,
        DHT,
        INDEX,
        SEARCH;

    }
}

