/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.storage.HashARC;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.repository.RegexHelper;

public class FilterEngine {
    protected static final int CACHE_SIZE = 100;
    public static final int ERR_TWO_WILDCARDS_IN_HOST = 1;
    public static final int ERR_SUBDOMAIN_XOR_WILDCARD = 2;
    public static final int ERR_PATH_REGEX = 3;
    public static final int ERR_WILDCARD_BEGIN_OR_END = 4;
    public static final int ERR_HOST_WRONG_CHARS = 5;
    public static final int ERR_DOUBLE_OCCURANCE = 6;
    public static final int ERR_HOST_REGEX = 7;
    protected HashARC<DigestURL, EnumSet<listTypes>> cachedUrlHashs = null;
    protected Map<String, Set<FilterEntry>> hostpaths_matchable = new HashMap<String, Set<FilterEntry>>();
    protected Map<String, Set<FilterEntry>> hostpaths_notmatchable = new HashMap<String, Set<FilterEntry>>();

    public FilterEngine() {
        this.cachedUrlHashs = new HashARC(100);
    }

    public void clear() {
        this.cachedUrlHashs.clear();
        this.hostpaths_matchable.clear();
        this.hostpaths_notmatchable.clear();
    }

    public int size() {
        return this.hostpaths_matchable.size() + this.hostpaths_notmatchable.size();
    }

    public void add(String entry2, EnumSet<listTypes> types) {
        assert (entry2 != null);
        int pos = entry2.indexOf(47);
        if (pos > 0) {
            String host = entry2.substring(0, pos).trim().toLowerCase(Locale.ROOT);
            String path = entry2.substring(pos + 1).trim();
            if (!FilterEngine.isMatchable(host) && !host.isEmpty() && host.charAt(0) == '*') {
                host = "." + host;
            }
            if (FilterEngine.isMatchable(host)) {
                if (!this.hostpaths_matchable.containsKey(host)) {
                    this.hostpaths_matchable.put(host, new TreeSet());
                }
                this.hostpaths_matchable.get(host).add(new FilterEntry(path, types));
            } else {
                if (!this.hostpaths_notmatchable.containsKey(host)) {
                    this.hostpaths_notmatchable.put(host, new TreeSet());
                }
                this.hostpaths_notmatchable.get(host).add(new FilterEntry(path, types));
            }
        }
    }

    public void loadList(BufferedReader in, EnumSet<listTypes> types) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
            this.add(line, types);
        }
    }

    public void removeAll(String host) {
        assert (host != null);
        this.hostpaths_matchable.remove(host);
        this.hostpaths_notmatchable.remove(host);
    }

    public boolean isListed(DigestURL url, EnumSet<listTypes> type) {
        if (url.getHost() == null) {
            return false;
        }
        if (this.cachedUrlHashs.containsKey((Object)url)) {
            EnumSet e = (EnumSet)this.cachedUrlHashs.get((Object)url);
            return e.containsAll(type);
        }
        return this.isListed(url.getHost().toLowerCase(Locale.ROOT), url.getFile());
    }

    public static boolean isMatchable(String host) {
        try {
            if (Pattern.matches("^[a-z0-9.-]*$", host)) {
                return true;
            }
            if (Pattern.matches("^\\*\\.[a-z0-9-.]*$", host)) {
                return true;
            }
            if (Pattern.matches("^[a-z0-9-.]*\\.\\*$", host)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return false;
    }

    public boolean isListed(String host, String path) {
        Set<FilterEntry> app;
        if (host == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            throw new NullPointerException();
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((app = this.hostpaths_matchable.get(host)) != null) {
            for (FilterEntry e : app) {
                if (e.path.indexOf("?*", 0) > 0) {
                    ConcurrentLog.warn("FilterEngine", "ignored blacklist path to prevent 'Dangling meta character' exception: " + e);
                    continue;
                }
                if (!e.path.equals("*") && !path.matches(e.path)) continue;
                return true;
            }
        }
        int index2 = 0;
        while ((index2 = host.indexOf(46, index2 + 1)) != -1) {
            app = this.hostpaths_matchable.get(host.substring(0, index2 + 1) + "*");
            if (app != null) {
                for (FilterEntry e : app) {
                    if (!e.path.equals("*") && !path.matches(e.path)) continue;
                    return true;
                }
            }
            if ((app = this.hostpaths_matchable.get(host.substring(0, index2))) == null) continue;
            for (FilterEntry e : app) {
                if (!e.path.equals("*") && !path.matches(e.path)) continue;
                return true;
            }
        }
        index2 = host.length();
        while ((index2 = host.lastIndexOf(46, index2 - 1)) != -1) {
            app = this.hostpaths_matchable.get("*" + host.substring(index2, host.length()));
            if (app != null) {
                for (FilterEntry e : app) {
                    if (!e.path.equals("*") && !path.matches(e.path)) continue;
                    return true;
                }
            }
            if ((app = this.hostpaths_matchable.get(host.substring(index2 + 1, host.length()))) == null) continue;
            for (FilterEntry e : app) {
                if (!e.path.equals("*") && !path.matches(e.path)) continue;
                return true;
            }
        }
        for (Map.Entry<String, Set<FilterEntry>> entry2 : this.hostpaths_notmatchable.entrySet()) {
            try {
                if (!Pattern.matches(entry2.getKey(), host)) continue;
                app = entry2.getValue();
                for (FilterEntry e : app) {
                    if (!Pattern.matches(e.path, path)) continue;
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                System.out.println(e.toString());
            }
        }
        return false;
    }

    public int checkError(String element, Map<String, String> properties) {
        String path;
        String host;
        boolean allowRegex = properties != null && properties.get("allowRegex").equalsIgnoreCase("true");
        int slashPos = element.indexOf(47);
        if (slashPos == -1) {
            host = element;
            path = ".*";
        } else {
            host = element.substring(0, slashPos);
            path = element.substring(slashPos + 1);
        }
        if (!allowRegex || !RegexHelper.isValidRegex(host)) {
            int i = host.indexOf(42);
            if (!host.matches("([A-Za-z0-9_-]+|\\*)(\\.([A-Za-z0-9_-]+|\\*))*")) {
                if (i == 0 && host.length() > 1 && host.charAt(1) != '.') {
                    return 2;
                }
                return 5;
            }
            if (host.length() > 0 && i > -1) {
                if (i != 0 && i != host.length() - 1) {
                    return 4;
                }
                if (i == host.length() - 1 && host.length() > 1 && host.charAt(i - 1) != '.') {
                    return 2;
                }
            }
            if (host.indexOf("*", i + 1) > -1) {
                return 1;
            }
        } else if (allowRegex && !RegexHelper.isValidRegex(host)) {
            return 7;
        }
        if (!RegexHelper.isValidRegex(path) && !path.equals("*")) {
            return 3;
        }
        return 0;
    }

    protected class FilterEntry
    implements Comparable<FilterEntry> {
        public String path;
        public EnumSet<listTypes> types;

        public FilterEntry(String path, EnumSet<listTypes> types) {
            this.path = path;
            this.types = types;
        }

        @Override
        public int compareTo(FilterEntry fe) {
            return this.path.compareToIgnoreCase(fe.path);
        }
    }

    protected static enum listTypes {
        type1;

    }
}

