/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.operation;

import java.io.File;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.server.serverSwitch;

public class yacySeedUploadFtp
implements yacySeedUploader {
    public static final String CONFIG_FTP_SERVER = "seedFTPServer";
    public static final String CONFIG_FTP_ACCOUNT = "seedFTPAccount";
    public static final String CONFIG_FTP_PASSWORD = "seedFTPPassword";
    public static final String CONFIG_FTP_PATH = "seedFTPPath";

    @Override
    public String uploadSeedFile(serverSwitch sb, File seedFile) throws Exception {
        if (sb == null) {
            throw new NullPointerException("Reference to serverSwitch must not be null.");
        }
        if (seedFile == null || !seedFile.exists()) {
            throw new Exception("Seed file does not exist.");
        }
        if (!seedFile.isFile()) {
            throw new Exception("Seed file is not a file.");
        }
        if (!seedFile.canRead()) {
            throw new Exception("Seed file is not readable.");
        }
        String seedFTPServer = sb.getConfig(CONFIG_FTP_SERVER, null);
        String seedFTPAccount = sb.getConfig(CONFIG_FTP_ACCOUNT, null);
        String seedFTPPassword = sb.getConfig(CONFIG_FTP_PASSWORD, null);
        File seedFTPPath = new File(sb.getConfig(CONFIG_FTP_PATH, null));
        if (seedFTPServer != null && seedFTPAccount != null && seedFTPPassword != null && seedFTPPath != null) {
            String log = FTPClient.put(seedFTPServer, seedFile, seedFTPPath.getParent(), seedFTPPath.getName(), seedFTPAccount, seedFTPPassword);
            return log;
        }
        throw new Exception("Seed upload settings not configured properly. password-len=" + (seedFTPPassword == null ? "null" : Integer.valueOf(seedFTPPassword.length())) + ", filePath=" + seedFTPPath);
    }

    @Override
    public String[] getConfigurationOptions() {
        return new String[]{CONFIG_FTP_SERVER, CONFIG_FTP_ACCOUNT, CONFIG_FTP_PASSWORD, CONFIG_FTP_PATH};
    }
}

